/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.conformance.beans;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.conformance.beans.ExceptionBean;
import org.odpi.openmetadata.conformance.beans.OpenMetadataConformanceWorkbenchWorkPad;
import org.odpi.openmetadata.conformance.beans.OpenMetadataTestCaseResult;
import org.odpi.openmetadata.conformance.beans.OpenMetadataTestCaseSummary;
import org.odpi.openmetadata.conformance.ffdc.exception.AssertionFailureException;

public abstract class OpenMetadataTestCase {
    private static final String documentationRootURL = "https://egeria.odpi.org/open-metadata-conformance-suite/docs/";
    protected String testCaseId = "<Unknown>";
    protected String testCaseName = "<Unknown>";
    protected String testCaseDescriptionURL = "<Unknown>";
    protected Integer defaultProfileId = null;
    protected Integer defaultRequirementId = null;
    protected OpenMetadataConformanceWorkbenchWorkPad workPad = null;
    protected List<String> successfulAssertions = new ArrayList<String>();
    protected List<String> unsuccessfulAssertions = new ArrayList<String>();
    protected List<String> notSupportedAssertions = new ArrayList<String>();
    protected Map<String, Object> discoveredProperties = new HashMap<String, Object>();
    protected ExceptionBean exceptionBean = null;
    protected String successMessage = null;

    public OpenMetadataTestCase() {
    }

    public OpenMetadataTestCase(OpenMetadataConformanceWorkbenchWorkPad workPad, String testCaseId, String testCaseName, Integer defaultProfileId, Integer defaultRequirementId) {
        this.testCaseId = testCaseId;
        this.testCaseName = testCaseName;
        this.testCaseDescriptionURL = documentationRootURL + workPad.getWorkbenchId() + "/test-cases/" + testCaseId + "-test-case.md";
        this.defaultProfileId = defaultProfileId;
        this.defaultRequirementId = defaultRequirementId;
        this.workPad = workPad;
        workPad.registerTestCase(this);
    }

    public OpenMetadataTestCase(OpenMetadataConformanceWorkbenchWorkPad workPad, Integer defaultProfileId, Integer defaultRequirementId) {
        this.defaultProfileId = defaultProfileId;
        this.defaultRequirementId = defaultRequirementId;
        this.workPad = workPad;
    }

    protected void updateTestId(String testCaseRootId, String testCaseId, String testCaseName) {
        this.testCaseId = testCaseId;
        this.testCaseName = testCaseName;
        this.testCaseDescriptionURL = documentationRootURL + this.workPad.getWorkbenchId() + "/test-cases/" + testCaseRootId + "-test-case.md";
        this.workPad.registerTestCase(this);
    }

    protected abstract void logTestStart(String var1);

    protected abstract void logTestEnd(String var1);

    public String getTestCaseId() {
        return this.testCaseId;
    }

    public String getTestCaseName() {
        return this.testCaseName;
    }

    public String getTestCaseDescriptionURL() {
        return this.testCaseDescriptionURL;
    }

    public boolean isTestRan() {
        return !this.successfulAssertions.isEmpty() || !this.unsuccessfulAssertions.isEmpty();
    }

    public boolean isTestPassed() {
        return this.isTestRan() && this.unsuccessfulAssertions.isEmpty();
    }

    public OpenMetadataTestCaseResult getResult() {
        OpenMetadataTestCaseResult result = null;
        if (this.isTestRan()) {
            result = new OpenMetadataTestCaseResult(this);
            result.setConformanceException(this.exceptionBean);
            result.setSuccessfulAssertions(this.successfulAssertions);
            result.setUnsuccessfulAssertions(this.unsuccessfulAssertions);
            result.setNotSupportedAssertions(this.notSupportedAssertions);
            if (!this.discoveredProperties.isEmpty()) {
                result.setDiscoveredProperties(this.discoveredProperties);
            }
            if (this.isTestPassed()) {
                result.setSuccessMessage(this.successMessage);
            }
        }
        return result;
    }

    public OpenMetadataTestCaseSummary getSummary() {
        return new OpenMetadataTestCaseSummary(this);
    }

    protected void assertCondition(boolean condition, String assertionId, String assertionMessage, Integer profileId, Integer requirementId) throws AssertionFailureException {
        this.assertCondition(condition, assertionId, assertionMessage, profileId, requirementId, null, null);
    }

    protected void assertCondition(boolean condition, String assertionId, String assertionMessage, Integer profileId, Integer requirementId, String methodName, Long elapsedTime) throws AssertionFailureException {
        if (condition) {
            this.successfulAssertions.add(assertionId + ": " + assertionMessage);
            this.workPad.addSuccessfulCondition(profileId, requirementId, this.testCaseId, this.testCaseName, this.testCaseDescriptionURL, assertionId, methodName, elapsedTime);
            return;
        }
        this.unsuccessfulAssertions.add(assertionId + ": " + assertionMessage);
        this.workPad.addUnsuccessfulCondition(profileId, requirementId, this.testCaseId, this.testCaseName, this.testCaseDescriptionURL, assertionId, methodName, elapsedTime);
        throw new AssertionFailureException(assertionId, assertionMessage);
    }

    protected void verifyCondition(boolean condition, String assertionId, String assertionMessage, Integer profileId, Integer requirementId) {
        this.verifyCondition(condition, assertionId, assertionMessage, profileId, requirementId, null, null);
    }

    protected void verifyCondition(boolean condition, String assertionId, String assertionMessage, Integer profileId, Integer requirementId, String methodName, Long elapsedTime) {
        if (condition) {
            this.successfulAssertions.add(assertionId + ": " + assertionMessage);
            this.workPad.addSuccessfulCondition(profileId, requirementId, this.testCaseId, this.testCaseName, this.testCaseDescriptionURL, assertionId, methodName, elapsedTime);
            return;
        }
        this.unsuccessfulAssertions.add(assertionId + ": " + assertionMessage);
        this.workPad.addUnsuccessfulCondition(profileId, requirementId, this.testCaseId, this.testCaseName, this.testCaseDescriptionURL, assertionId, methodName, elapsedTime);
    }

    protected void addNotSupportedAssertion(String assertionId, String assertionMessage, Integer profileId, Integer requirementId) {
        this.notSupportedAssertions.add(assertionId + ": " + assertionMessage);
        this.workPad.addNotSupportedCondition(profileId, requirementId, this.testCaseId, this.testCaseName, this.testCaseDescriptionURL, assertionId);
    }

    protected void addDiscoveredProperty(String propertyName, Object propertyValue, Integer profileId, Integer requirementId) {
        this.discoveredProperties.put(propertyName, propertyValue);
        this.workPad.addDiscoveredProperty(profileId, requirementId, this.testCaseId, this.testCaseName, this.testCaseDescriptionURL, propertyName, propertyValue);
    }

    protected void setSuccessMessage(String message) {
        this.successMessage = message;
    }

    public void startAsynchronousTest() {
        String methodName = "startAsynchronousTest";
        this.logTestStart("startAsynchronousTest");
    }

    public void endAsynchronousTest() {
        String methodName = "endAsynchronousTest";
        this.logTestEnd("endAsynchronousTest");
    }

    public void executeTest() {
        String methodName = "executeTest";
        this.logTestStart("executeTest");
        try {
            this.run();
        }
        catch (AssertionFailureException assertionFailureException) {
        }
        catch (Exception exception) {
            String assertionMessage = "Unexpected Exception " + exception.getClass().getSimpleName() + " : " + exception.getMessage();
            this.unsuccessfulAssertions.add(assertionMessage);
            this.exceptionBean = new ExceptionBean();
            this.exceptionBean.setErrorMessage(exception.getMessage());
            this.exceptionBean.setExceptionClassName(exception.getClass().getName());
            this.workPad.addUnexpectedException(this.defaultProfileId, this.defaultRequirementId, this.testCaseId, this.testCaseName, this.testCaseDescriptionURL, assertionMessage, this.exceptionBean);
        }
        this.logTestEnd("executeTest");
    }

    public void executeTest(TestPhase phase) {
        String methodName = "executeTest";
        this.logTestStart("executeTest");
        try {
            this.run(phase);
        }
        catch (AssertionFailureException assertionFailureException) {
        }
        catch (Exception exception) {
            String assertionMessage = "Unexpected Exception " + exception.getClass().getSimpleName() + " : " + exception.getMessage();
            this.unsuccessfulAssertions.add(assertionMessage);
            this.exceptionBean = new ExceptionBean();
            this.exceptionBean.setErrorMessage(exception.getMessage());
            this.exceptionBean.setExceptionClassName(exception.getClass().getName());
            this.workPad.addUnexpectedException(this.defaultProfileId, this.defaultRequirementId, this.testCaseId, this.testCaseName, this.testCaseDescriptionURL, assertionMessage, this.exceptionBean);
        }
        this.logTestEnd("executeTest");
    }

    public void cleanTest() {
        try {
            this.cleanup();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void cleanup() throws Exception {
    }

    protected abstract void run() throws Exception;

    protected void run(TestPhase phase) throws Exception {
    }

    public String toString() {
        return "OpenMetadataTestCase{testCaseId='" + this.testCaseId + "', testCaseName='" + this.testCaseName + "', testCaseDescriptionURL='" + this.testCaseDescriptionURL + "', defaultProfileId=" + this.defaultProfileId + ", defaultRequirementId=" + this.defaultRequirementId + ", successfulAssertions=" + this.successfulAssertions + ", unsuccessfulAssertions=" + this.unsuccessfulAssertions + ", notSupportedAssertions=" + this.notSupportedAssertions + ", discoveredProperties=" + this.discoveredProperties + ", exceptionBean=" + this.exceptionBean + ", successMessage='" + this.successMessage + "', testRan=" + this.isTestRan() + ", testPassed=" + this.isTestPassed() + ", result=" + this.getResult() + ", summary=" + this.getSummary() + "}";
    }

    public static enum TestPhase {
        SEED,
        EXECUTE,
        CLEAN;

    }
}

