/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.conformance.beans;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.odpi.openmetadata.conformance.beans.ExceptionBean;
import org.odpi.openmetadata.conformance.beans.OpenMetadataConformanceProfileResults;
import org.odpi.openmetadata.conformance.beans.OpenMetadataConformanceProfileSummary;
import org.odpi.openmetadata.conformance.beans.OpenMetadataConformanceStatus;
import org.odpi.openmetadata.conformance.beans.OpenMetadataConformanceTestEvidence;
import org.odpi.openmetadata.conformance.beans.OpenMetadataConformanceTestEvidenceType;
import org.odpi.openmetadata.conformance.beans.OpenMetadataConformanceWorkbenchResults;
import org.odpi.openmetadata.conformance.beans.OpenMetadataConformanceWorkbenchStatus;
import org.odpi.openmetadata.conformance.beans.OpenMetadataConformanceWorkbenchSummary;
import org.odpi.openmetadata.conformance.beans.OpenMetadataTestCase;
import org.odpi.openmetadata.conformance.beans.OpenMetadataTestCaseResult;
import org.odpi.openmetadata.conformance.beans.OpenMetadataTestCaseSummary;
import org.odpi.openmetadata.conformance.ffdc.ConformanceSuiteErrorCode;
import org.odpi.openmetadata.conformance.ffdc.exception.ConformanceSuiteRuntimeException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;

public abstract class OpenMetadataConformanceWorkbenchWorkPad {
    protected String workbenchId;
    protected String workbenchName;
    protected String workbenchVersionNumber;
    protected String workbenchDocURL;
    protected String localServerUserId;
    protected String localServerPassword;
    protected String tutName;
    protected String tutType;
    protected int maxPageSize;
    protected boolean workbenchComplete;
    protected List<OpenMetadataConformanceTestEvidence> testEvidenceList = new ArrayList<OpenMetadataConformanceTestEvidence>();
    protected Map<String, OpenMetadataTestCase> testCaseMap = new HashMap<String, OpenMetadataTestCase>();
    protected Date lastActive = new Date();
    private static final long DELAY_TIME = 10000L;

    public OpenMetadataConformanceWorkbenchWorkPad(String workbenchId, String workbenchName, String workbenchVersionNumber, String workbenchDocURL, String localServerUserId, String localServerPassword, String tutType, int maxPageSize) {
        this.workbenchId = workbenchId;
        this.workbenchName = workbenchName;
        this.workbenchVersionNumber = workbenchVersionNumber;
        this.workbenchDocURL = workbenchDocURL;
        this.localServerUserId = localServerUserId;
        this.localServerPassword = localServerPassword;
        this.tutType = tutType;
        this.maxPageSize = maxPageSize;
        this.workbenchComplete = false;
    }

    public String getWorkbenchId() {
        return this.workbenchId;
    }

    public String getWorkbenchName() {
        return this.workbenchName;
    }

    public String getWorkbenchVersionNumber() {
        return this.workbenchVersionNumber;
    }

    public String getWorkbenchDocURL() {
        return this.workbenchDocURL;
    }

    public String getLocalServerUserId() {
        return this.localServerUserId;
    }

    public OpenMetadataConformanceWorkbenchStatus getWorkbenchStatus() {
        Date now;
        long millis;
        OpenMetadataConformanceWorkbenchStatus status = new OpenMetadataConformanceWorkbenchStatus();
        status.setWorkbenchId(this.workbenchId);
        if (this.workbenchComplete && (millis = (now = new Date()).getTime() - this.lastActive.getTime()) >= 10000L) {
            status.setWorkbenchComplete();
        }
        return status;
    }

    public void setWorkbenchComplete() {
        this.workbenchComplete = true;
    }

    public String getLocalServerPassword() {
        return this.localServerPassword;
    }

    public int getMaxPageSize() {
        return this.maxPageSize;
    }

    synchronized void registerTestCase(OpenMetadataTestCase testCase) {
        String methodName = "registerTestCase";
        OpenMetadataTestCase duplicateTestCase = this.testCaseMap.put(testCase.getTestCaseId(), testCase);
        if (duplicateTestCase != null) {
            HashMap<String, Object> relatedProperties = new HashMap<String, Object>();
            relatedProperties.put("Existing TestCase", duplicateTestCase);
            relatedProperties.put("New TestCase", testCase);
            throw new ConformanceSuiteRuntimeException(ConformanceSuiteErrorCode.DUPLICATE_TEST_CASE.getMessageDefinition(this.tutName, this.tutType, testCase.getTestCaseId()), this.getClass().getName(), "registerTestCase", relatedProperties);
        }
    }

    synchronized Set<String> getTestCaseIds() {
        return new TreeSet<String>(this.testCaseMap.keySet());
    }

    public abstract List<String> getProfileNames();

    public abstract OpenMetadataConformanceProfileResults getProfileResults(String var1);

    public abstract List<OpenMetadataConformanceProfileResults> getProfileResults();

    public abstract List<OpenMetadataConformanceProfileSummary> getProfileSummaries();

    private OpenMetadataConformanceStatus getStatusFromEvidence(List<OpenMetadataConformanceTestEvidence> positiveTestEvidence, List<OpenMetadataConformanceTestEvidence> negativeTestEvidence, List<OpenMetadataConformanceTestEvidence> unsupportedTestEvidence) {
        OpenMetadataConformanceStatus status = !(positiveTestEvidence != null && !positiveTestEvidence.isEmpty() || negativeTestEvidence != null && !negativeTestEvidence.isEmpty() || unsupportedTestEvidence != null && !unsupportedTestEvidence.isEmpty()) ? OpenMetadataConformanceStatus.UNKNOWN_STATUS : (negativeTestEvidence != null && !negativeTestEvidence.isEmpty() ? OpenMetadataConformanceStatus.NOT_CONFORMANT : (positiveTestEvidence != null && !positiveTestEvidence.isEmpty() ? (unsupportedTestEvidence != null && !unsupportedTestEvidence.isEmpty() ? OpenMetadataConformanceStatus.CONFORMANT_PARTIAL_SUPPORT : OpenMetadataConformanceStatus.CONFORMANT_FULL_SUPPORT) : OpenMetadataConformanceStatus.CONFORMANT_NO_SUPPORT));
        return status;
    }

    protected OpenMetadataConformanceStatus processEvidence(List<OpenMetadataConformanceTestEvidence> testEvidenceList, List<OpenMetadataConformanceTestEvidence> positiveTestEvidence, List<OpenMetadataConformanceTestEvidence> negativeTestEvidence) {
        ArrayList<OpenMetadataConformanceTestEvidence> unsupportedTestEvidence = new ArrayList<OpenMetadataConformanceTestEvidence>();
        if (testEvidenceList != null) {
            for (OpenMetadataConformanceTestEvidence testEvidenceItem : testEvidenceList) {
                OpenMetadataConformanceTestEvidenceType testEvidenceType;
                if (testEvidenceItem == null || (testEvidenceType = testEvidenceItem.getTestEvidenceType()) == null) continue;
                switch (testEvidenceType) {
                    case NO_DATA_AVAILABLE: {
                        break;
                    }
                    case SUCCESSFUL_ASSERTION: 
                    case DISCOVERED_PROPERTY: {
                        positiveTestEvidence.add(testEvidenceItem);
                        break;
                    }
                    case UNEXPECTED_EXCEPTION: 
                    case UNSUCCESSFUL_ASSERTION: {
                        negativeTestEvidence.add(testEvidenceItem);
                        break;
                    }
                    case NOT_SUPPORTED_FUNCTION: {
                        unsupportedTestEvidence.add(testEvidenceItem);
                    }
                }
            }
        }
        OpenMetadataConformanceStatus status = this.getStatusFromEvidence(positiveTestEvidence, negativeTestEvidence, unsupportedTestEvidence);
        if (positiveTestEvidence != null) {
            positiveTestEvidence.addAll(unsupportedTestEvidence);
        }
        return status;
    }

    public synchronized void addSuccessfulCondition(Integer profileId, Integer requirementId, String testCaseId, String testCaseName, String testCaseDocumentationURL, String assertionId, String methodName, Long elapsedTime) {
        OpenMetadataConformanceTestEvidence testEvidence = new OpenMetadataConformanceTestEvidence();
        testEvidence.setProfileId(profileId);
        testEvidence.setRequirementId(requirementId);
        testEvidence.setTestCaseId(testCaseId);
        testEvidence.setTestCaseName(testCaseName);
        testEvidence.setTestCaseDescriptionURL(testCaseDocumentationURL);
        testEvidence.setAssertionId(assertionId);
        testEvidence.setTestEvidenceType(OpenMetadataConformanceTestEvidenceType.SUCCESSFUL_ASSERTION);
        if (methodName != null) {
            testEvidence.setMethodName(methodName);
        }
        if (elapsedTime != null) {
            testEvidence.setElapsedTime(elapsedTime);
        }
        this.testEvidenceList.add(testEvidence);
    }

    public synchronized void addUnsuccessfulCondition(Integer profileId, Integer requirementId, String testCaseId, String testCaseName, String testCaseDocumentationURL, String assertionId, String methodName, Long elapsedTime) {
        OpenMetadataConformanceTestEvidence testEvidence = new OpenMetadataConformanceTestEvidence();
        testEvidence.setProfileId(profileId);
        testEvidence.setRequirementId(requirementId);
        testEvidence.setTestCaseId(testCaseId);
        testEvidence.setTestCaseName(testCaseName);
        testEvidence.setTestCaseDescriptionURL(testCaseDocumentationURL);
        testEvidence.setAssertionId(assertionId);
        testEvidence.setTestEvidenceType(OpenMetadataConformanceTestEvidenceType.UNSUCCESSFUL_ASSERTION);
        if (methodName != null) {
            testEvidence.setMethodName(methodName);
        }
        if (elapsedTime != null) {
            testEvidence.setElapsedTime(elapsedTime);
        }
        this.testEvidenceList.add(testEvidence);
    }

    public synchronized void addNotSupportedCondition(Integer profileId, Integer requirementId, String testCaseId, String testCaseName, String testCaseDocumentationURL, String assertionId) {
        OpenMetadataConformanceTestEvidence testEvidence = new OpenMetadataConformanceTestEvidence();
        testEvidence.setProfileId(profileId);
        testEvidence.setRequirementId(requirementId);
        testEvidence.setTestCaseId(testCaseId);
        testEvidence.setTestCaseName(testCaseName);
        testEvidence.setTestCaseDescriptionURL(testCaseDocumentationURL);
        testEvidence.setAssertionId(assertionId);
        testEvidence.setTestEvidenceType(OpenMetadataConformanceTestEvidenceType.NOT_SUPPORTED_FUNCTION);
        this.testEvidenceList.add(testEvidence);
    }

    public synchronized void addDiscoveredProperty(Integer profileId, Integer requirementId, String testCaseId, String testCaseName, String testCaseDocumentationURL, String propertyName, Object propertyValue) {
        OpenMetadataConformanceTestEvidence testEvidence = new OpenMetadataConformanceTestEvidence();
        testEvidence.setProfileId(profileId);
        testEvidence.setRequirementId(requirementId);
        testEvidence.setTestCaseId(testCaseId);
        testEvidence.setTestCaseName(testCaseName);
        testEvidence.setTestCaseDescriptionURL(testCaseDocumentationURL);
        testEvidence.setPropertyName(propertyName);
        testEvidence.setPropertyValue(propertyValue);
        testEvidence.setTestEvidenceType(OpenMetadataConformanceTestEvidenceType.DISCOVERED_PROPERTY);
        this.testEvidenceList.add(testEvidence);
    }

    synchronized void addUnexpectedException(Integer profileId, Integer requirementId, String testCaseId, String testCaseName, String testCaseDocumentationURL, String assertionId, ExceptionBean exception) {
        OpenMetadataConformanceTestEvidence testEvidence = new OpenMetadataConformanceTestEvidence();
        testEvidence.setProfileId(profileId);
        testEvidence.setRequirementId(requirementId);
        testEvidence.setTestCaseId(testCaseId);
        testEvidence.setTestCaseName(testCaseName);
        testEvidence.setTestCaseDescriptionURL(testCaseDocumentationURL);
        testEvidence.setAssertionId(assertionId);
        testEvidence.setConformanceException(exception);
        testEvidence.setTestEvidenceType(OpenMetadataConformanceTestEvidenceType.UNEXPECTED_EXCEPTION);
        this.testEvidenceList.add(testEvidence);
    }

    synchronized OpenMetadataTestCaseResult getTestCaseResult(String testCaseId) throws InvalidParameterException {
        String methodName = "getTestCaseReport";
        String parameterName = "testCaseId";
        OpenMetadataTestCase testCase = this.testCaseMap.get(testCaseId);
        if (testCase != null) {
            return testCase.getResult();
        }
        throw new InvalidParameterException(ConformanceSuiteErrorCode.UNKNOWN_TEST_CASE_ID.getMessageDefinition(testCaseId), this.getClass().getName(), "getTestCaseReport", "testCaseId");
    }

    synchronized List<OpenMetadataTestCaseResult> getFailedTestCases() {
        ArrayList<OpenMetadataTestCaseResult> failedTestCases = new ArrayList<OpenMetadataTestCaseResult>();
        Collection<OpenMetadataTestCase> allTestCases = this.testCaseMap.values();
        for (OpenMetadataTestCase testCase : allTestCases) {
            if (testCase == null || !testCase.isTestRan() || testCase.isTestPassed()) continue;
            failedTestCases.add(testCase.getResult());
        }
        if (failedTestCases.isEmpty()) {
            return null;
        }
        return failedTestCases;
    }

    synchronized OpenMetadataConformanceWorkbenchResults getWorkbenchResults() {
        OpenMetadataConformanceWorkbenchResults workbenchResults = new OpenMetadataConformanceWorkbenchResults();
        workbenchResults.setWorkbenchId(this.workbenchId);
        workbenchResults.setWorkbenchName(this.workbenchName);
        workbenchResults.setVersionNumber(this.workbenchVersionNumber);
        workbenchResults.setTutName(this.tutName);
        workbenchResults.setTutType(this.tutType);
        workbenchResults.setProfileResults(this.getProfileResults());
        ArrayList<OpenMetadataTestCaseResult> passedTestCases = new ArrayList<OpenMetadataTestCaseResult>();
        ArrayList<OpenMetadataTestCaseResult> failedTestCases = new ArrayList<OpenMetadataTestCaseResult>();
        ArrayList<OpenMetadataTestCaseSummary> skippedTestCases = new ArrayList<OpenMetadataTestCaseSummary>();
        for (OpenMetadataTestCase testCase : this.testCaseMap.values()) {
            if (testCase.isTestRan()) {
                if (testCase.isTestPassed()) {
                    passedTestCases.add(testCase.getResult());
                    continue;
                }
                failedTestCases.add(testCase.getResult());
                continue;
            }
            skippedTestCases.add(testCase.getSummary());
        }
        if (!passedTestCases.isEmpty()) {
            workbenchResults.setPassedTestCases(passedTestCases);
        }
        if (!failedTestCases.isEmpty()) {
            workbenchResults.setFailedTestCases(failedTestCases);
        }
        if (!skippedTestCases.isEmpty()) {
            workbenchResults.setSkippedTestCases(skippedTestCases);
        }
        return workbenchResults;
    }

    synchronized OpenMetadataConformanceWorkbenchSummary getWorkbenchSummary() {
        OpenMetadataConformanceWorkbenchSummary workbenchSummary = new OpenMetadataConformanceWorkbenchSummary();
        workbenchSummary.setWorkbenchId(this.workbenchId);
        workbenchSummary.setWorkbenchName(this.workbenchName);
        workbenchSummary.setVersionNumber(this.workbenchVersionNumber);
        workbenchSummary.setTutName(this.tutName);
        workbenchSummary.setTutType(this.tutType);
        workbenchSummary.setProfileSummaries(this.getProfileSummaries());
        return workbenchSummary;
    }

    public void registerActivity() {
        this.lastActive = new Date();
    }

    public String toString() {
        return "OpenMetadataConformanceWorkbenchWorkPad{workbenchId='" + this.workbenchId + "', workbenchName='" + this.workbenchName + "', workbenchVersionNumber='" + this.workbenchVersionNumber + "', workbenchDocURL='" + this.workbenchDocURL + "', localServerUserId='" + this.localServerUserId + "', localServerPassword='" + this.localServerPassword + "', tutName='" + this.tutName + "', tutType='" + this.tutType + "', maxPageSize=" + this.maxPageSize + ", testEvidenceList=" + String.valueOf(this.testEvidenceList) + ", testCaseMap=" + String.valueOf(this.testCaseMap) + ", failedTestCases=" + String.valueOf(this.getFailedTestCases()) + ", workbenchResults=" + String.valueOf(this.getWorkbenchResults()) + "}";
    }
}

