/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.conformance.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageSet;

public enum ConformanceSuiteErrorCode implements ExceptionMessageSet
{
    NULL_LOCAL_SERVER_NAME(400, "CONFORMANCE-SUITE-400-001", "OMAG server has been called with a null local server name", "The system is unable to configure the local server.", "The local server name is supplied by the caller to the OMAG server. This call needs to be corrected before the server can operate correctly."),
    NULL_USER_ID(400, "CONFORMANCE-SUITE-400-002", "OMAG server {0} has been called with a null username (userId)", "The system is unable to configure the local server.", "The user name is supplied by the caller to the OMAG server. This call needs to be corrected before the server can operate correctly."),
    UNKNOWN_TEST_CASE_ID(400, "CONFORMANCE-SUITE-400-003", "Unable to create a report for a test case with unknown identifier {0}", "The system is unable to create the report.", "Validate the test case identifier with the messages being produced by the audit log  and the conformance suite documentation."),
    UNKNOWN_WORKBENCH_ID(400, "CONFORMANCE-SUITE-400-004", "Unable to create a report for a workbench with unknown identifier {0}", "The system is unable to create the report.", "Validate the workbench identifier with the messages being produced by the audit log and the conformance suite documentation."),
    NO_ENTERPRISE_ACCESS(400, "CONFORMANCE-SUITE-400-022", "The Egeria Conformance Suite located in OMAG server {0} has been configured with no access to the enterprise repository services", "The system is unable to access the connectors to issue metadata requests to the technologies under test.", "Change the setting of the enterprise access service to ensure it is enabled."),
    UNKNOWN_PROFILE_NAME(400, "CONFORMANCE-SUITE-400-023", "Unable to create a report for a profile with unknown name {0}", "The system is unable to create the report.", "Validate the profile name with the messages being produced by the audit log and the conformance suite documentation."),
    NO_ENTERPRISE_TOPIC(500, "CONFORMANCE-SUITE-500-001", "The Egeria Conformance Suite located in OMAG server {0} has not been passed an enterprise topic connector", "The conformance suite is unable to receive and evaluate events from technologies under test.", "This is an internal logic error.  Create a git issue at https://github.com/odpi/egeria/issues to get this resolved."),
    NO_ENTERPRISE_CONNECTOR_MANAGER(500, "CONFORMANCE-SUITE-500-002", "The Egeria Conformance Suite located in OMAG server {0} has not been passed an enterprise connector manager", "The conformance suite is unable to issue metadata requests to the technologies under test.", "This is an internal logic error.  Create a git issue at https://github.com/odpi/egeria/issues to get this resolved."),
    DUPLICATE_TEST_CASE(500, "CONFORMANCE-SUITE-500-003", "The Egeria Conformance Suite testing technology {0} of type {1} has created two test cases with the same id of {2}", "The conformance suite is unable to process one of the test cases.", "This is an internal logic error.  Create a git issue at https://github.com/odpi/egeria/issues to get this resolved."),
    SERVICE_NOT_INITIALIZED(503, "CONFORMANCE-SUITE-503-003", "The conformance suite service has not been initialized for server {0} and can not support REST API call {1}", "The server has received a call to one of its open metadata conformance suite operations but is unable to process it because the conformance suite service is not active.", "If the server is supposed to have the conformance suite service activated, correct the server configuration and restart the server.");

    private final int httpErrorCode;
    private final String errorMessageId;
    private final String errorMessage;
    private final String systemAction;
    private final String userAction;

    private ConformanceSuiteErrorCode(int httpErrorCode, String errorMessageId, String errorMessage, String systemAction, String userAction) {
        this.httpErrorCode = httpErrorCode;
        this.errorMessageId = errorMessageId;
        this.errorMessage = errorMessage;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public ExceptionMessageDefinition getMessageDefinition() {
        return new ExceptionMessageDefinition(this.httpErrorCode, this.errorMessageId, this.errorMessage, this.systemAction, this.userAction);
    }

    public ExceptionMessageDefinition getMessageDefinition(String ... params) {
        ExceptionMessageDefinition messageDefinition = new ExceptionMessageDefinition(this.httpErrorCode, this.errorMessageId, this.errorMessage, this.systemAction, this.userAction);
        messageDefinition.setMessageParameters(params);
        return messageDefinition;
    }

    public String toString() {
        return "ErrorCode{httpErrorCode=" + this.httpErrorCode + ", errorMessageId='" + this.errorMessageId + "', errorMessage='" + this.errorMessage + "', systemAction='" + this.systemAction + "', userAction='" + this.userAction + "'}";
    }
}

