/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.conformance.ffdc.exception;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.auditlog.MessageFormatter;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.MessageDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConformanceSuiteRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(ConformanceSuiteRuntimeException.class);
    private static final MessageFormatter messageFormatter = new MessageFormatter();
    private final int reportedHTTPCode;
    private final String reportingClassName;
    private final String reportingActionDescription;
    private final String reportedErrorMessage;
    private String reportedErrorMessageId;
    private String[] reportedErrorMessageParameters;
    private final String reportedSystemAction;
    private final String reportedUserAction;
    private Throwable reportedCaughtException = null;
    private String reportedCaughtExceptionClassName = null;
    private Map<String, Object> relatedProperties = null;

    public ConformanceSuiteRuntimeException(ExceptionMessageDefinition messageDefinition, String className, String actionDescription) {
        this(messageDefinition, className, actionDescription, (Map<String, Object>)null);
    }

    public ConformanceSuiteRuntimeException(ExceptionMessageDefinition messageDefinition, String className, String actionDescription, Map<String, Object> relatedProperties) {
        super(messageFormatter.getFormattedMessage((MessageDefinition)messageDefinition));
        this.reportedHTTPCode = messageDefinition.getHttpErrorCode();
        this.reportingClassName = className;
        this.reportingActionDescription = actionDescription;
        this.reportedErrorMessage = messageFormatter.getFormattedMessage((MessageDefinition)messageDefinition);
        this.reportedErrorMessageId = messageDefinition.getMessageId();
        this.reportedErrorMessageParameters = messageDefinition.getMessageParams();
        this.reportedSystemAction = messageDefinition.getSystemAction();
        this.reportedUserAction = messageDefinition.getUserAction();
        this.relatedProperties = relatedProperties;
        this.validateCoreProperties();
        log.debug("{}, {}, {}", new Object[]{messageDefinition, className, actionDescription});
    }

    public ConformanceSuiteRuntimeException(ExceptionMessageDefinition messageDefinition, String className, String actionDescription, Throwable caughtError) {
        this(messageDefinition, className, actionDescription, caughtError, null);
    }

    public ConformanceSuiteRuntimeException(ExceptionMessageDefinition messageDefinition, String className, String actionDescription, Throwable caughtError, Map<String, Object> relatedProperties) {
        super(messageFormatter.getFormattedMessage((MessageDefinition)messageDefinition), caughtError);
        this.reportedHTTPCode = messageDefinition.getHttpErrorCode();
        this.reportingClassName = className;
        this.reportingActionDescription = actionDescription;
        this.reportedErrorMessage = messageFormatter.getFormattedMessage((MessageDefinition)messageDefinition);
        this.reportedErrorMessageId = messageDefinition.getMessageId();
        this.reportedErrorMessageParameters = messageDefinition.getMessageParams();
        this.reportedSystemAction = messageDefinition.getSystemAction();
        this.reportedUserAction = messageDefinition.getUserAction();
        this.reportedCaughtException = caughtError;
        this.reportedCaughtExceptionClassName = caughtError.getClass().getName();
        this.relatedProperties = relatedProperties;
        this.validateCoreProperties();
        log.debug("{}, {}, {}, {}", new Object[]{messageDefinition, className, actionDescription, caughtError});
    }

    public ConformanceSuiteRuntimeException(int httpCode, String className, String actionDescription, String errorMessage, String systemAction, String userAction, Map<String, Object> relatedProperties) {
        super(errorMessage);
        this.reportedHTTPCode = httpCode;
        this.reportingClassName = className;
        this.reportingActionDescription = actionDescription;
        this.reportedErrorMessage = errorMessage;
        this.reportedSystemAction = systemAction;
        this.reportedUserAction = userAction;
        this.relatedProperties = relatedProperties;
    }

    public ConformanceSuiteRuntimeException(int httpCode, String className, String actionDescription, String errorMessage, String systemAction, String userAction, Exception caughtError, Map<String, Object> relatedProperties) {
        super(errorMessage, caughtError);
        this.reportedHTTPCode = httpCode;
        this.reportingClassName = className;
        this.reportingActionDescription = actionDescription;
        this.reportedErrorMessage = errorMessage;
        this.reportedSystemAction = systemAction;
        this.reportedUserAction = userAction;
        this.reportedCaughtException = caughtError;
        this.relatedProperties = relatedProperties;
    }

    private void validateCoreProperties() {
        if (this.reportedHTTPCode == 0) {
            log.error("Zero HTTP code passed to an exception");
        }
        if (this.reportedErrorMessage == null) {
            log.error("Null error message passed to an exception");
        }
        if (this.reportedErrorMessageId == null) {
            log.error("Null error message Identifier passed to an exception");
        }
        if (this.reportedSystemAction == null) {
            log.error("Null system action passed to an exception");
        }
        if (this.reportedUserAction == null) {
            log.error("Null user action passed to an exception");
        }
        if (this.reportingActionDescription == null) {
            log.error("Null action description passed to an exception");
        }
        if (this.reportingClassName == null) {
            log.error("Null class name passed to an exception");
        }
    }

    public int getReportedHTTPCode() {
        return this.reportedHTTPCode;
    }

    public String getReportingClassName() {
        return this.reportingClassName;
    }

    public String getReportingActionDescription() {
        return this.reportingActionDescription;
    }

    @Deprecated
    public String getErrorMessage() {
        return this.reportedErrorMessage;
    }

    public String getReportedErrorMessage() {
        return this.reportedErrorMessage;
    }

    public String getReportedErrorMessageId() {
        return this.reportedErrorMessageId;
    }

    public String[] getReportedErrorMessageParameters() {
        return this.reportedErrorMessageParameters;
    }

    public String getReportedSystemAction() {
        return this.reportedSystemAction;
    }

    public String getReportedUserAction() {
        return this.reportedUserAction;
    }

    public Throwable getReportedCaughtException() {
        return this.reportedCaughtException;
    }

    public String getReportedCaughtExceptionClassName() {
        return this.reportedCaughtExceptionClassName;
    }

    public Map<String, Object> getRelatedProperties() {
        if (this.relatedProperties == null) {
            return null;
        }
        if (this.relatedProperties.isEmpty()) {
            return null;
        }
        return new HashMap<String, Object>(this.relatedProperties);
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        ConformanceSuiteRuntimeException that = (ConformanceSuiteRuntimeException)objectToCompare;
        return this.reportedHTTPCode == that.reportedHTTPCode && Objects.equals(this.reportingClassName, that.reportingClassName) && Objects.equals(this.reportingActionDescription, that.reportingActionDescription) && Objects.equals(this.reportedErrorMessage, that.reportedErrorMessage) && Objects.equals(this.reportedErrorMessageId, that.reportedErrorMessageId) && Arrays.equals(this.reportedErrorMessageParameters, that.reportedErrorMessageParameters) && Objects.equals(this.reportedSystemAction, that.reportedSystemAction) && Objects.equals(this.reportedUserAction, that.reportedUserAction) && Objects.equals(this.reportedCaughtException, that.reportedCaughtException) && Objects.equals(this.relatedProperties, that.relatedProperties);
    }

    public int hashCode() {
        int result = Objects.hash(this.reportedHTTPCode, this.reportingClassName, this.reportingActionDescription, this.reportedErrorMessage, this.reportedErrorMessageId, this.reportedSystemAction, this.reportedUserAction, this.reportedCaughtException, this.relatedProperties);
        result = 31 * result + Arrays.hashCode(this.reportedErrorMessageParameters);
        return result;
    }

    @Override
    public String toString() {
        return "ConformanceSuiteRuntimeException{reportedHTTPCode=" + this.reportedHTTPCode + ", reportingClassName='" + this.reportingClassName + "', reportingActionDescription='" + this.reportingActionDescription + "', reportedErrorMessage='" + this.reportedErrorMessage + "', reportedErrorMessageId='" + this.reportedErrorMessageId + "', reportedErrorMessageParameters=" + Arrays.toString(this.reportedErrorMessageParameters) + ", reportedSystemAction='" + this.reportedSystemAction + "', reportedUserAction='" + this.reportedUserAction + "', reportedCaughtException=" + String.valueOf(this.reportedCaughtException) + ", reportedCaughtExceptionClassName='" + this.reportedCaughtExceptionClassName + "', relatedProperties=" + String.valueOf(this.relatedProperties) + "}";
    }
}

