/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.conformance;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.conformance.beans.ExceptionBean;
import org.odpi.openmetadata.conformance.beans.OpenMetadataTestCaseResult;
import org.odpi.openmetadata.conformance.beans.OpenMetadataTestCaseSummary;
import org.odpi.openmetadata.conformance.ffdc.AssertionFailureException;

public abstract class OpenMetadataTestCase {
    private static final String documentationRootURL = "https://odpi.github.io/egeria/open-metadata-conformance-suite/docs/";
    protected String testCaseId;
    protected String testCaseName;
    protected String testCaseDescriptionURL;
    protected List<String> successfulAssertions = new ArrayList<String>();
    protected List<String> unsuccessfulAssertions = new ArrayList<String>();
    protected OpenMetadataTestCaseResult result = null;

    public OpenMetadataTestCase() {
    }

    public OpenMetadataTestCase(String workbenchId, String testCaseId, String testCaseName) {
        this.testCaseId = testCaseId;
        this.testCaseName = testCaseName;
        this.testCaseDescriptionURL = documentationRootURL + workbenchId + "/" + testCaseId + "-test-case.md";
    }

    protected void setTestCaseIds(String workbenchId, String testCaseId, String testCaseName) {
        this.testCaseId = testCaseId;
        this.testCaseName = testCaseName;
        this.testCaseDescriptionURL = documentationRootURL + workbenchId + "/" + testCaseId + "-test-case.md";
    }

    public String getTestCaseId() {
        return this.testCaseId;
    }

    public String getTestCaseName() {
        return this.testCaseName;
    }

    public String getTestCaseDescriptionURL() {
        return this.testCaseDescriptionURL;
    }

    public boolean isTestRan() {
        return !this.successfulAssertions.isEmpty() || !this.unsuccessfulAssertions.isEmpty();
    }

    public boolean isTestPassed() {
        return this.isTestRan() && this.unsuccessfulAssertions.isEmpty();
    }

    public OpenMetadataTestCaseResult getResult() {
        return this.result;
    }

    public OpenMetadataTestCaseSummary getSummary() {
        return new OpenMetadataTestCaseSummary(this);
    }

    protected void assertCondition(boolean condition, String assertionId, String assertionMessage) throws AssertionFailureException {
        if (condition) {
            this.successfulAssertions.add(assertionMessage);
            return;
        }
        this.unsuccessfulAssertions.add(assertionId + ": " + assertionMessage);
        throw new AssertionFailureException(assertionId, assertionMessage);
    }

    public void executeTest() {
        this.result = new OpenMetadataTestCaseResult(this);
        try {
            this.run();
        }
        catch (AssertionFailureException assertionFailureException) {
        }
        catch (Throwable exception) {
            this.unsuccessfulAssertions.add("test-case-base-01: Unexpected Exception " + exception.getClass().getSimpleName());
            ExceptionBean exceptionBean = new ExceptionBean();
            exceptionBean.setErrorMessage(exception.getMessage());
            exceptionBean.setExceptionClassName(exception.getClass().getName());
            this.result.setConformanceException(exceptionBean);
        }
        this.result.setSuccessfulAssertions(this.successfulAssertions);
        this.result.setUnsuccessfulAssertions(this.unsuccessfulAssertions);
    }

    protected abstract void run() throws Exception;
}

