/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.conformance;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.varia.NullAppender;
import org.odpi.openmetadata.conformance.OpenMetadataTestWorkbench;
import org.odpi.openmetadata.conformance.beans.OpenMetadataTestLabResults;
import org.odpi.openmetadata.conformance.beans.OpenMetadataTestWorkbenchResults;
import org.odpi.openmetadata.conformance.tests.origin.OpenMetadataOriginTestWorkbench;
import org.odpi.openmetadata.conformance.tests.repository.OpenMetadataRepositoryTestWorkbench;

public class OpenMetadataTestLab {
    private static String resultsFileNameLeaf = ".openmetadata.functional.testlab.results";
    private List<OpenMetadataTestWorkbench> registeredWorkbenches;
    private String serverName;
    private String serverURLRoot;

    private List<OpenMetadataTestWorkbench> getRegisteredWorkbenches(String serverName, String serverURLRoot) {
        ArrayList<OpenMetadataTestWorkbench> registeredTestWorkbenches = new ArrayList<OpenMetadataTestWorkbench>();
        registeredTestWorkbenches.add(new OpenMetadataOriginTestWorkbench(serverName, serverURLRoot));
        registeredTestWorkbenches.add(new OpenMetadataRepositoryTestWorkbench(serverName, serverURLRoot));
        return registeredTestWorkbenches;
    }

    private OpenMetadataTestLab(String serverName, String serverURLRoot) {
        this.registeredWorkbenches = this.getRegisteredWorkbenches(serverName, serverURLRoot);
        this.serverName = serverName;
        this.serverURLRoot = serverURLRoot;
    }

    private OpenMetadataTestLabResults runTests() {
        OpenMetadataTestLabResults results = new OpenMetadataTestLabResults();
        results.setServerName(this.serverName);
        results.setServerRootURL(this.serverURLRoot);
        if (this.registeredWorkbenches != null) {
            ArrayList<OpenMetadataTestWorkbenchResults> workbenchResultsList = new ArrayList<OpenMetadataTestWorkbenchResults>();
            for (OpenMetadataTestWorkbench testWorkbench : this.registeredWorkbenches) {
                workbenchResultsList.add(testWorkbench.runTests());
            }
            if (!workbenchResultsList.isEmpty()) {
                results.setTestResultsFromWorkbenches(workbenchResultsList);
            }
        }
        return results;
    }

    public static void main(String[] args) {
        BasicConfigurator.configure((Appender)new NullAppender());
        if (args == null || args.length < 2) {
            System.out.println("Please specify the server's name in the first parameter and the server URL root in the second");
            System.exit(-1);
        }
        String serverName = args[0];
        String serverURLRoot = args[1];
        String resultsFileName = serverName + resultsFileNameLeaf;
        System.out.println("===============================");
        System.out.println("Open Metadata Conformance Test  ");
        System.out.println("===============================");
        System.out.println("Conformance Report for server: " + serverName + " (" + serverURLRoot + ")");
        OpenMetadataTestLab testLab = new OpenMetadataTestLab(serverName, serverURLRoot);
        OpenMetadataTestLabResults testLabResults = testLab.runTests();
        if (testLabResults == null) {
            System.out.println("The OpenMetadataTestLab failed to create any results");
            System.exit(-1);
        }
        try {
            File resultsStoreFile = new File(resultsFileName);
            ObjectMapper objectMapper = new ObjectMapper();
            String jsonString = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)testLabResults);
            FileUtils.writeStringToFile((File)resultsStoreFile, (String)jsonString, (boolean)false);
        }
        catch (Throwable exc) {
            System.out.println("The OpenMetadataTestLab failed to process results " + exc.getMessage());
            System.exit(-1);
        }
        System.out.println();
        System.out.println("Number of tests: " + testLabResults.getTestCaseCount());
        System.out.println("Number of tests passed: " + testLabResults.getTestPassCount());
        System.out.println("Number of tests failed: " + testLabResults.getTestFailedCount());
        System.out.println("Number of tests skipped: " + testLabResults.getTestSkippedCount());
        System.out.println();
        if (testLabResults.getTestCaseCount() == testLabResults.getTestPassCount()) {
            System.out.println("Congratulations, " + serverName + " server at " + serverURLRoot + " is an open metadata repository");
            System.exit(0);
        } else {
            System.out.println(serverName + " server at " + serverURLRoot + " is not yet an open metadata repository");
            System.exit(1);
        }
    }
}

