/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.conformance.beans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import org.odpi.openmetadata.conformance.OpenMetadataTestWorkbench;
import org.odpi.openmetadata.conformance.beans.OpenMetadataTestCaseResult;
import org.odpi.openmetadata.conformance.beans.OpenMetadataTestCaseSummary;
import org.odpi.openmetadata.conformance.beans.OpenMetadataTestResults;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class OpenMetadataTestWorkbenchResults
extends OpenMetadataTestResults {
    private String workbenchName = null;
    private String versionNumber = null;
    private String workbenchDocumentationURL = null;
    private List<OpenMetadataTestCaseResult> passedTestCases = null;
    private List<OpenMetadataTestCaseResult> failedTestCases = null;
    private List<OpenMetadataTestCaseSummary> skippedTestCases = null;

    private int countTestCaseSummaries(List<OpenMetadataTestCaseSummary> testCaseResults) {
        if (testCaseResults == null) {
            return 0;
        }
        return testCaseResults.size();
    }

    private int countTestCaseResults(List<OpenMetadataTestCaseResult> testCaseResults) {
        if (testCaseResults == null) {
            return 0;
        }
        return testCaseResults.size();
    }

    public OpenMetadataTestWorkbenchResults() {
    }

    public OpenMetadataTestWorkbenchResults(OpenMetadataTestWorkbench workbench) {
        this.workbenchName = workbench.getWorkbenchName();
        this.versionNumber = workbench.getVersionNumber();
        this.workbenchDocumentationURL = workbench.getWorkbenchDocumentationURL();
    }

    public String getWorkbenchName() {
        return this.workbenchName;
    }

    public void setWorkbenchName(String workbenchName) {
        this.workbenchName = workbenchName;
    }

    public String getVersionNumber() {
        return this.versionNumber;
    }

    public void setVersionNumber(String versionNumber) {
        this.versionNumber = versionNumber;
    }

    public String getWorkbenchDocumentationURL() {
        return this.workbenchDocumentationURL;
    }

    public void setWorkbenchDocumentationURL(String workbenchDocumentationURL) {
        this.workbenchDocumentationURL = workbenchDocumentationURL;
    }

    @Override
    public int getTestCaseCount() {
        return this.countTestCaseResults(this.passedTestCases) + this.countTestCaseResults(this.failedTestCases) + this.countTestCaseSummaries(this.skippedTestCases);
    }

    @Override
    public int getTestPassCount() {
        return this.countTestCaseResults(this.passedTestCases);
    }

    @Override
    public int getTestFailedCount() {
        return this.countTestCaseResults(this.failedTestCases);
    }

    @Override
    public int getTestSkippedCount() {
        return this.countTestCaseSummaries(this.skippedTestCases);
    }

    public List<OpenMetadataTestCaseResult> getPassedTestCases() {
        return this.passedTestCases;
    }

    public void setPassedTestCases(List<OpenMetadataTestCaseResult> passedTestCases) {
        this.passedTestCases = passedTestCases;
    }

    public List<OpenMetadataTestCaseResult> getFailedTestCases() {
        return this.failedTestCases;
    }

    public void setFailedTestCases(List<OpenMetadataTestCaseResult> failedTestCases) {
        this.failedTestCases = failedTestCases;
    }

    public List<OpenMetadataTestCaseSummary> getSkippedTestCases() {
        return this.skippedTestCases;
    }

    public void setSkippedTestCases(List<OpenMetadataTestCaseSummary> skippedTestCases) {
        this.skippedTestCases = skippedTestCases;
    }
}

