/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.conformance.tests.repository;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.conformance.OpenMetadataTestCase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public abstract class OpenMetadataRepositoryTestCase
extends OpenMetadataTestCase {
    private static final String assertion1 = "repository-test-case-base-01";
    private static final String assertionMsg1 = "Connector supplied to test case.";
    private static final String assertion2 = "repository-test-case-base-02";
    private static final String assertionMsg2 = "Metadata collection for connector supplied to test case.";
    protected OMRSRepositoryConnector connector = null;

    protected OpenMetadataRepositoryTestCase(String workbenchId, String testCaseId, String testCaseName) {
        super(workbenchId, testCaseId, testCaseName);
    }

    public void setConnector(OMRSRepositoryConnector connector) {
        this.connector = connector;
    }

    protected OMRSMetadataCollection getMetadataCollection() throws Exception {
        OMRSMetadataCollection metadataCollection = null;
        if (this.connector != null) {
            metadataCollection = this.connector.getMetadataCollection();
        }
        if (metadataCollection == null) {
            this.assertCondition(this.connector != null, assertion1, assertionMsg1);
            this.assertCondition(false, assertion2, assertionMsg2);
        }
        return metadataCollection;
    }

    private PrimitivePropertyValue getPrimitivePropertyValue(String propertyName, PrimitiveDef propertyType) {
        PrimitivePropertyValue propertyValue = new PrimitivePropertyValue();
        propertyValue.setPrimitiveDefCategory(propertyType.getPrimitiveDefCategory());
        switch (propertyType.getPrimitiveDefCategory()) {
            case OM_PRIMITIVE_TYPE_STRING: {
                propertyValue.setPrimitiveValue((Object)("Test" + propertyName + "Value"));
                break;
            }
            case OM_PRIMITIVE_TYPE_DATE: {
                propertyValue.setPrimitiveValue((Object)new Date());
                break;
            }
            case OM_PRIMITIVE_TYPE_INT: {
                propertyValue.setPrimitiveValue((Object)42);
                break;
            }
            case OM_PRIMITIVE_TYPE_BOOLEAN: {
                propertyValue.setPrimitiveValue((Object)true);
                break;
            }
            case OM_PRIMITIVE_TYPE_SHORT: {
                propertyValue.setPrimitiveValue((Object)new Short("34"));
                break;
            }
            case OM_PRIMITIVE_TYPE_BYTE: {
                propertyValue.setPrimitiveValue((Object)new Byte("7"));
                break;
            }
            case OM_PRIMITIVE_TYPE_CHAR: {
                propertyValue.setPrimitiveValue((Object)new Character('o'));
                break;
            }
            case OM_PRIMITIVE_TYPE_LONG: {
                propertyValue.setPrimitiveValue((Object)new Long(2452L));
                break;
            }
            case OM_PRIMITIVE_TYPE_FLOAT: {
                propertyValue.setPrimitiveValue((Object)new Float(245332.0f));
                break;
            }
            case OM_PRIMITIVE_TYPE_DOUBLE: {
                propertyValue.setPrimitiveValue((Object)new Double(2459992.0));
                break;
            }
            case OM_PRIMITIVE_TYPE_BIGDECIMAL: {
                propertyValue.setPrimitiveValue((Object)new Double(2.45339992E8));
                break;
            }
            case OM_PRIMITIVE_TYPE_BIGINTEGER: {
                propertyValue.setPrimitiveValue((Object)new Double(2.45559992E8));
                break;
            }
        }
        return propertyValue;
    }

    protected InstanceProperties getPropertiesForInstance(List<TypeDefAttribute> typeDefAttributes) {
        InstanceProperties properties = null;
        if (typeDefAttributes != null) {
            HashMap<String, PrimitivePropertyValue> propertyMap = new HashMap<String, PrimitivePropertyValue>();
            for (TypeDefAttribute typeDefAttribute : typeDefAttributes) {
                String attributeName = typeDefAttribute.getAttributeName();
                AttributeTypeDef attributeType = typeDefAttribute.getAttributeType();
                AttributeTypeDefCategory category = attributeType.getCategory();
                switch (category) {
                    case PRIMITIVE: {
                        PrimitiveDef primitiveDef = (PrimitiveDef)attributeType;
                        propertyMap.put(attributeName, this.getPrimitivePropertyValue(attributeName, primitiveDef));
                    }
                }
            }
            if (!propertyMap.isEmpty()) {
                properties = new InstanceProperties();
                properties.setInstanceProperties(propertyMap);
            }
        }
        return properties;
    }

    protected InstanceProperties getAllPropertiesForInstance(String userId, TypeDef typeDef) throws Exception {
        InstanceProperties properties = null;
        List<TypeDefAttribute> allTypeDefAttributes = this.getPropertiesForTypeDef(userId, typeDef);
        if (allTypeDefAttributes != null) {
            HashMap<String, PrimitivePropertyValue> propertyMap = new HashMap<String, PrimitivePropertyValue>();
            for (TypeDefAttribute typeDefAttribute : allTypeDefAttributes) {
                String attributeName = typeDefAttribute.getAttributeName();
                AttributeTypeDef attributeType = typeDefAttribute.getAttributeType();
                AttributeTypeDefCategory category = attributeType.getCategory();
                switch (category) {
                    case PRIMITIVE: {
                        PrimitiveDef primitiveDef = (PrimitiveDef)attributeType;
                        propertyMap.put(attributeName, this.getPrimitivePropertyValue(attributeName, primitiveDef));
                    }
                }
            }
            if (!propertyMap.isEmpty()) {
                properties = new InstanceProperties();
                properties.setInstanceProperties(propertyMap);
            }
        }
        return properties;
    }

    protected InstanceProperties getMinPropertiesForInstance(String userId, TypeDef typeDef) throws Exception {
        List<TypeDefAttribute> allTypeDefAttributes = this.getPropertiesForTypeDef(userId, typeDef);
        HashMap<String, PrimitivePropertyValue> propertyMap = new HashMap<String, PrimitivePropertyValue>();
        if (allTypeDefAttributes != null) {
            for (TypeDefAttribute typeDefAttribute : allTypeDefAttributes) {
                String attributeName = typeDefAttribute.getAttributeName();
                AttributeTypeDef attributeType = typeDefAttribute.getAttributeType();
                AttributeTypeDefCategory category = attributeType.getCategory();
                AttributeCardinality attributeCardinality = typeDefAttribute.getAttributeCardinality();
                if (attributeCardinality != AttributeCardinality.AT_LEAST_ONE_ORDERED && attributeCardinality != AttributeCardinality.AT_LEAST_ONE_UNORDERED) continue;
                switch (category) {
                    case PRIMITIVE: {
                        PrimitiveDef primitiveDef = (PrimitiveDef)attributeType;
                        propertyMap.put(attributeName, this.getPrimitivePropertyValue(attributeName, primitiveDef));
                    }
                }
            }
        }
        InstanceProperties properties = new InstanceProperties();
        properties.setInstanceProperties(propertyMap);
        return properties;
    }

    protected List<TypeDefAttribute> getPropertiesForTypeDef(String userId, TypeDef typeDef) throws Exception {
        List currentTypePropDefs;
        TypeDefLink superTypeDefLink;
        String superTypeName;
        TypeDef superTypeDef;
        List<TypeDefAttribute> inheritedProps;
        OMRSMetadataCollection metadataCollection = this.getMetadataCollection();
        ArrayList<TypeDefAttribute> propDefs = new ArrayList<TypeDefAttribute>();
        if (typeDef.getSuperType() != null && (inheritedProps = this.getPropertiesForTypeDef(userId, superTypeDef = metadataCollection.getTypeDefByName(userId, superTypeName = (superTypeDefLink = typeDef.getSuperType()).getName()))) != null && !inheritedProps.isEmpty()) {
            propDefs.addAll(inheritedProps);
        }
        if ((currentTypePropDefs = typeDef.getPropertiesDefinition()) != null && !currentTypePropDefs.isEmpty()) {
            propDefs.addAll(currentTypePropDefs);
        }
        return propDefs;
    }

    EntityDef getEntityDef(Map<String, EntityDef> supportedEntityDefs, TypeDefLink entityIdentifiers) {
        EntityDef entityDef = null;
        ArrayList<String> possibleEntityNameMatch = new ArrayList<String>();
        possibleEntityNameMatch.add(entityIdentifiers.getName());
        while (entityDef == null && !possibleEntityNameMatch.isEmpty()) {
            ArrayList<String> possibleEntitySubtypeNameMatch = new ArrayList<String>();
            for (String entityTypeName : possibleEntityNameMatch) {
                entityDef = supportedEntityDefs.get(entityTypeName);
                if (entityDef != null) continue;
                for (EntityDef supportedEntityDef : supportedEntityDefs.values()) {
                    TypeDefLink superType = supportedEntityDef.getSuperType();
                    if (superType == null || !entityTypeName.equals(superType.getName())) continue;
                    possibleEntitySubtypeNameMatch.add(supportedEntityDef.getName());
                }
            }
            possibleEntityNameMatch = possibleEntitySubtypeNameMatch;
        }
        return entityDef;
    }

    EntityDetail addEntityToRepository(String userId, OMRSMetadataCollection metadataCollection, EntityDef entityDef) throws Exception {
        InstanceProperties properties = this.getAllPropertiesForInstance(userId, (TypeDef)entityDef);
        return metadataCollection.addEntity(userId, entityDef.getGUID(), properties, null, null);
    }
}

