/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.conformance.tests.repository;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.repositoryservices.ConnectorConfigurationFactory;
import org.odpi.openmetadata.conformance.OpenMetadataTestCase;
import org.odpi.openmetadata.conformance.OpenMetadataTestWorkbench;
import org.odpi.openmetadata.conformance.beans.OpenMetadataTestCaseResult;
import org.odpi.openmetadata.conformance.beans.OpenMetadataTestCaseSummary;
import org.odpi.openmetadata.conformance.beans.OpenMetadataTestWorkbenchResults;
import org.odpi.openmetadata.conformance.tests.repository.OpenMetadataRepositoryTestCase;
import org.odpi.openmetadata.conformance.tests.repository.TestFindAttributeTypeDefsByCategory;
import org.odpi.openmetadata.conformance.tests.repository.TestFindTypeDefByExternalId;
import org.odpi.openmetadata.conformance.tests.repository.TestFindTypeDefsByCategory;
import org.odpi.openmetadata.conformance.tests.repository.TestGetTypeDefGallery;
import org.odpi.openmetadata.conformance.tests.repository.TestMetadataCollectionId;
import org.odpi.openmetadata.conformance.tests.repository.TestSupportedAttributeTypeDef;
import org.odpi.openmetadata.conformance.tests.repository.TestSupportedClassificationLifecycle;
import org.odpi.openmetadata.conformance.tests.repository.TestSupportedEntityLifecycle;
import org.odpi.openmetadata.conformance.tests.repository.TestSupportedRelationshipLifecycle;
import org.odpi.openmetadata.conformance.tests.repository.TestSupportedTypeDef;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class OpenMetadataRepositoryTestWorkbench
extends OpenMetadataTestWorkbench {
    private static final String workbenchId = "repository-workbench";
    private static final String workbenchName = "Open Metadata Repository Test Workbench";
    private static final String workbenchVersionNumber = "V0.1 SNAPSHOT";
    private static final String workbenchDocURL = "https://odpi.github.io/egeria/open-metadata-conformance-suite/docs/repository-workbench";
    private static final String dummyMetadataCollectionId = "dummyMetadataCollectionId-workbench";
    private String metadataCollectionId = null;

    public OpenMetadataRepositoryTestWorkbench(String serverName, String serverURLRoot) {
        super(workbenchName, workbenchVersionNumber, workbenchDocURL, serverName, serverURLRoot);
    }

    private OMRSRepositoryConnector getRepositoryConnector(String metadataCollectionId) {
        try {
            ConnectorConfigurationFactory factory = new ConnectorConfigurationFactory();
            Connection connection = factory.getDefaultLocalRepositoryRemoteConnection(this.serverName, this.serverURLRoot);
            ConnectorBroker connectorBroker = new ConnectorBroker();
            Connector connector = connectorBroker.getConnector(connection);
            OMRSRepositoryConnector repositoryConnector = (OMRSRepositoryConnector)connector;
            repositoryConnector.setMetadataCollectionId(metadataCollectionId);
            repositoryConnector.start();
            return repositoryConnector;
        }
        catch (Throwable exc) {
            System.out.println("Unable to create connector " + exc.getMessage());
            return null;
        }
    }

    @Override
    public OpenMetadataTestWorkbenchResults runTests() {
        ArrayList<OpenMetadataRepositoryTestCase> testCases = new ArrayList<OpenMetadataRepositoryTestCase>();
        OpenMetadataTestWorkbenchResults workbenchResults = new OpenMetadataTestWorkbenchResults(this);
        OMRSRepositoryConnector repositoryConnector = this.getRepositoryConnector(dummyMetadataCollectionId);
        if (repositoryConnector != null) {
            TestMetadataCollectionId testCase = new TestMetadataCollectionId(workbenchId);
            testCases.add(testCase);
            testCase.setConnector(repositoryConnector);
            testCase.executeTest();
            this.metadataCollectionId = testCase.getMetadataCollectionId();
        }
        if (this.metadataCollectionId != null) {
            repositoryConnector = this.getRepositoryConnector(this.metadataCollectionId);
            TestGetTypeDefGallery typeDefGalleryTestCase = new TestGetTypeDefGallery(workbenchId);
            testCases.add(typeDefGalleryTestCase);
            typeDefGalleryTestCase.setConnector(repositoryConnector);
            typeDefGalleryTestCase.executeTest();
            ArrayList<TestSupportedAttributeTypeDef> attributeTypeDefTestCases = new ArrayList<TestSupportedAttributeTypeDef>();
            ArrayList<TestSupportedTypeDef> typeDefTestCases = new ArrayList<TestSupportedTypeDef>();
            List<AttributeTypeDef> attributeTypeDefs = typeDefGalleryTestCase.getAttributeTypeDefs();
            List<TypeDef> list = typeDefGalleryTestCase.getTypeDefs();
            if (attributeTypeDefs != null) {
                for (AttributeTypeDef attributeTypeDef : attributeTypeDefs) {
                    TestSupportedAttributeTypeDef testAttributeTypeDef = new TestSupportedAttributeTypeDef(workbenchId, attributeTypeDef);
                    testCases.add(testAttributeTypeDef);
                    attributeTypeDefTestCases.add(testAttributeTypeDef);
                }
            }
            if (list != null) {
                for (TypeDef typeDef : list) {
                    TestSupportedTypeDef testTypeDef = new TestSupportedTypeDef(workbenchId, typeDef);
                    testCases.add(testTypeDef);
                    typeDefTestCases.add(testTypeDef);
                }
            }
            for (TestSupportedAttributeTypeDef testSupportedAttributeTypeDef : attributeTypeDefTestCases) {
                testSupportedAttributeTypeDef.setConnector(repositoryConnector);
                testSupportedAttributeTypeDef.executeTest();
            }
            for (TestSupportedTypeDef testSupportedTypeDef : typeDefTestCases) {
                testSupportedTypeDef.setConnector(repositoryConnector);
                testSupportedTypeDef.executeTest();
            }
            TestFindAttributeTypeDefsByCategory testFindAttributeTypeDefsByCategory = new TestFindAttributeTypeDefsByCategory(workbenchId, attributeTypeDefs);
            testCases.add(testFindAttributeTypeDefsByCategory);
            testFindAttributeTypeDefsByCategory.setConnector(repositoryConnector);
            testFindAttributeTypeDefsByCategory.executeTest();
            TestFindTypeDefsByCategory testFindTypeDefsByCategory = new TestFindTypeDefsByCategory(workbenchId, list);
            testCases.add(testFindTypeDefsByCategory);
            testFindTypeDefsByCategory.setConnector(repositoryConnector);
            testFindTypeDefsByCategory.executeTest();
            ArrayList<TestSupportedEntityLifecycle> entityTestCases = new ArrayList<TestSupportedEntityLifecycle>();
            ArrayList<TestSupportedRelationshipLifecycle> relationshipTestCases = new ArrayList<TestSupportedRelationshipLifecycle>();
            ArrayList<TestSupportedClassificationLifecycle> classificationTestCases = new ArrayList<TestSupportedClassificationLifecycle>();
            Map<String, EntityDef> entityDefs = testFindTypeDefsByCategory.getEntityDefs();
            List<RelationshipDef> relationshipDefs = testFindTypeDefsByCategory.getRelationshipDefs();
            List<ClassificationDef> classificationDefs = testFindTypeDefsByCategory.getClassificationDefs();
            if (entityDefs != null) {
                for (EntityDef entityDef : entityDefs.values()) {
                    TestSupportedEntityLifecycle testEntityLifecycle = new TestSupportedEntityLifecycle(workbenchId, this.metadataCollectionId, entityDef);
                    testCases.add(testEntityLifecycle);
                    entityTestCases.add(testEntityLifecycle);
                }
            }
            if (relationshipDefs != null) {
                for (RelationshipDef relationshipDef : relationshipDefs) {
                    TestSupportedRelationshipLifecycle testRelationshipLifecycle = new TestSupportedRelationshipLifecycle(workbenchId, this.metadataCollectionId, entityDefs, relationshipDef);
                    testCases.add(testRelationshipLifecycle);
                    relationshipTestCases.add(testRelationshipLifecycle);
                }
            }
            if (classificationDefs != null) {
                for (ClassificationDef classificationDef : classificationDefs) {
                    TestSupportedClassificationLifecycle testClassificationLifecycle = new TestSupportedClassificationLifecycle(workbenchId, this.metadataCollectionId, entityDefs, classificationDef);
                    testCases.add(testClassificationLifecycle);
                    classificationTestCases.add(testClassificationLifecycle);
                }
            }
            for (TestSupportedEntityLifecycle testSupportedEntityLifecycle : entityTestCases) {
                testSupportedEntityLifecycle.setConnector(repositoryConnector);
                testSupportedEntityLifecycle.executeTest();
            }
            for (TestSupportedRelationshipLifecycle testSupportedRelationshipLifecycle : relationshipTestCases) {
                testSupportedRelationshipLifecycle.setConnector(repositoryConnector);
                testSupportedRelationshipLifecycle.executeTest();
            }
            for (TestSupportedClassificationLifecycle testSupportedClassificationLifecycle : classificationTestCases) {
                testSupportedClassificationLifecycle.setConnector(repositoryConnector);
                testSupportedClassificationLifecycle.executeTest();
            }
            TestFindTypeDefByExternalId testFindTypeDefByExternalId = new TestFindTypeDefByExternalId(workbenchId, list);
            testCases.add(testFindTypeDefByExternalId);
            testFindTypeDefByExternalId.setConnector(repositoryConnector);
            testFindTypeDefByExternalId.executeTest();
        }
        ArrayList<OpenMetadataTestCaseResult> passedTestCases = new ArrayList<OpenMetadataTestCaseResult>();
        ArrayList<OpenMetadataTestCaseResult> failedTestCases = new ArrayList<OpenMetadataTestCaseResult>();
        ArrayList<OpenMetadataTestCaseSummary> skippedTestCases = new ArrayList<OpenMetadataTestCaseSummary>();
        for (OpenMetadataTestCase openMetadataTestCase : testCases) {
            if (openMetadataTestCase.isTestRan()) {
                if (openMetadataTestCase.isTestPassed()) {
                    passedTestCases.add(openMetadataTestCase.getResult());
                    continue;
                }
                failedTestCases.add(openMetadataTestCase.getResult());
                continue;
            }
            skippedTestCases.add(openMetadataTestCase.getSummary());
        }
        if (!passedTestCases.isEmpty()) {
            workbenchResults.setPassedTestCases(passedTestCases);
        }
        if (!failedTestCases.isEmpty()) {
            workbenchResults.setFailedTestCases(failedTestCases);
        }
        if (!skippedTestCases.isEmpty()) {
            workbenchResults.setSkippedTestCases(skippedTestCases);
        }
        return workbenchResults;
    }
}

