/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.conformance.tests.repository;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.conformance.tests.repository.OpenMetadataRepositoryTestCase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.CollectionDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDef;

public class TestFindAttributeTypeDefsByCategory
extends OpenMetadataRepositoryTestCase {
    private static final String testUserId = "ConformanceTestUser";
    private static final String testCaseId = "repository-find-attribute-typedefs-by-category";
    private static final String testCaseName = "Repository find attribute type definitions by category test case";
    private static final String assertion1 = "repository-find-attribute-typedefs-by-category-01";
    private static final String assertionMsg1 = "All attribute type definitions returned by category.";
    private static final String discoveredProperty_numberOfPrimitiveDefs = "Number of supported PrimitiveDefs";
    private static final String discoveredProperty_primitiveDefs = "Supported PrimitiveDefs";
    private static final String discoveredProperty_numberOfCollectionDefs = "Number of supported CollectionDefs";
    private static final String discoveredProperty_collectionDefs = "Supported CollectionDefs";
    private static final String discoveredProperty_numberOfEnumDefs = "Number of supported EnumDefs";
    private static final String discoveredProperty_enumDefs = "Supported EnumDefs";
    private List<AttributeTypeDef> allAttributeTypeDefs;
    private Map<String, PrimitiveDef> primitiveDefs = new HashMap<String, PrimitiveDef>();
    private List<CollectionDef> collectionDefs = new ArrayList<CollectionDef>();
    private List<EnumDef> enumDefs = new ArrayList<EnumDef>();

    TestFindAttributeTypeDefsByCategory(String workbenchId, List<AttributeTypeDef> allAttributeTypeDefs) {
        super(workbenchId, testCaseId, testCaseName);
        this.allAttributeTypeDefs = allAttributeTypeDefs;
    }

    public Map<String, PrimitiveDef> getPrimitiveDefs() {
        if (this.primitiveDefs.isEmpty()) {
            return null;
        }
        return this.primitiveDefs;
    }

    public List<CollectionDef> getCollectionDefs() {
        if (this.collectionDefs.isEmpty()) {
            return null;
        }
        return this.collectionDefs;
    }

    public List<EnumDef> getEnumDefs() {
        if (this.enumDefs.isEmpty()) {
            return null;
        }
        return this.enumDefs;
    }

    @Override
    protected void run() throws Exception {
        ArrayList<String> supportedTypes;
        HashMap<String, Object> discoveredProperties = new HashMap<String, Object>();
        OMRSMetadataCollection metadataCollection = super.getMetadataCollection();
        List typeDefGallery = metadataCollection.findAttributeTypeDefsByCategory(testUserId, AttributeTypeDefCategory.PRIMITIVE);
        if (typeDefGallery == null) {
            discoveredProperties.put(discoveredProperty_numberOfPrimitiveDefs, 0);
        } else {
            discoveredProperties.put(discoveredProperty_numberOfPrimitiveDefs, typeDefGallery.size());
            supportedTypes = new ArrayList<String>();
            for (AttributeTypeDef attributeTypeDef : typeDefGallery) {
                this.primitiveDefs.put(attributeTypeDef.getName(), (PrimitiveDef)attributeTypeDef);
                supportedTypes.add(attributeTypeDef.getName());
            }
            discoveredProperties.put(discoveredProperty_primitiveDefs, supportedTypes);
        }
        typeDefGallery = metadataCollection.findAttributeTypeDefsByCategory(testUserId, AttributeTypeDefCategory.COLLECTION);
        if (typeDefGallery == null) {
            discoveredProperties.put(discoveredProperty_numberOfCollectionDefs, 0);
        } else {
            discoveredProperties.put(discoveredProperty_numberOfCollectionDefs, typeDefGallery.size());
            supportedTypes = new ArrayList();
            for (AttributeTypeDef attributeTypeDef : typeDefGallery) {
                this.collectionDefs.add((CollectionDef)attributeTypeDef);
                supportedTypes.add(attributeTypeDef.getName());
            }
            discoveredProperties.put(discoveredProperty_collectionDefs, supportedTypes);
        }
        typeDefGallery = metadataCollection.findAttributeTypeDefsByCategory(testUserId, AttributeTypeDefCategory.ENUM_DEF);
        if (typeDefGallery == null) {
            discoveredProperties.put(discoveredProperty_numberOfEnumDefs, 0);
        } else {
            discoveredProperties.put(discoveredProperty_numberOfEnumDefs, typeDefGallery.size());
            supportedTypes = new ArrayList();
            for (AttributeTypeDef attributeTypeDef : typeDefGallery) {
                this.enumDefs.add((EnumDef)attributeTypeDef);
                supportedTypes.add(attributeTypeDef.getName());
            }
            discoveredProperties.put(discoveredProperty_enumDefs, supportedTypes);
        }
        this.assertCondition(this.primitiveDefs.size() + this.collectionDefs.size() + this.enumDefs.size() == this.allAttributeTypeDefs.size(), assertion1, assertionMsg1);
        this.result.setSuccessMessage("Attribute type definitions can be extracted by category");
        this.result.setDiscoveredProperties(discoveredProperties);
    }
}

