/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.conformance.tests.repository;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.conformance.tests.repository.OpenMetadataRepositoryTestCase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ExternalStandardMapping;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;

public class TestFindTypeDefByExternalId
extends OpenMetadataRepositoryTestCase {
    private static final String testUserId = "ConformanceTestUser";
    private static final String testCaseId = "repository-find-types-by-external-standard-identifiers";
    private static final String testCaseName = "Repository find type definitions by external standard identifiers test case";
    private static final String assertion1 = "repository-find-types-by-external-standard-identifiers-01";
    private static final String assertionMsg1 = "All type definitions returned for external standard name ";
    private static final String assertion2 = "repository-find-types-by-external-standard-identifiers-02";
    private static final String assertionMsg2 = "All type definitions returned for external standard organization name ";
    private static final String assertion3 = "repository-find-types-by-external-standard-identifiers-03";
    private static final String assertionMsg3 = "All type definitions returned for external standard type name ";
    private static final String assertion4 = "repository-find-types-by-external-standard-identifiers-04";
    private static final String assertionMsg4 = "All type definitions returned for external standard mappings.";
    private static final String discoveredProperty_numberOfMappedTypeDefs = "Number of type definitions mapped to external standard identifiers";
    private List<TypeDef> allTypeDefs;
    private Map<String, List<TypeDef>> standardsToTypeDefs = new HashMap<String, List<TypeDef>>();
    private Map<String, List<TypeDef>> orgToTypeDefs = new HashMap<String, List<TypeDef>>();
    private Map<String, List<TypeDef>> idToTypeDefs = new HashMap<String, List<TypeDef>>();

    TestFindTypeDefByExternalId(String workbenchId, List<TypeDef> allTypeDefs) {
        super(workbenchId, testCaseId, testCaseName);
        this.allTypeDefs = allTypeDefs;
    }

    @Override
    protected void run() throws Exception {
        HashMap<String, Object> discoveredProperties = new HashMap<String, Object>();
        OMRSMetadataCollection metadataCollection = super.getMetadataCollection();
        if (this.allTypeDefs == null || this.allTypeDefs.isEmpty()) {
            discoveredProperties.put(discoveredProperty_numberOfMappedTypeDefs, 0);
        } else {
            List<TypeDef> expectedTypeDefs;
            List returnedTypeDefs;
            int mappedTypeDefs = 0;
            for (TypeDef activeTypeDef : this.allTypeDefs) {
                List typeDefAttributes;
                ArrayList externalStandardMappings = new ArrayList();
                if (activeTypeDef.getExternalStandardMappings() != null) {
                    externalStandardMappings.addAll(activeTypeDef.getExternalStandardMappings());
                }
                if ((typeDefAttributes = activeTypeDef.getPropertiesDefinition()) != null) {
                    for (TypeDefAttribute typeDefAttribute : typeDefAttributes) {
                        if (typeDefAttribute == null || typeDefAttribute.getExternalStandardMappings() == null) continue;
                        externalStandardMappings.addAll(activeTypeDef.getExternalStandardMappings());
                    }
                }
                if (!externalStandardMappings.isEmpty()) {
                    ++mappedTypeDefs;
                }
                for (ExternalStandardMapping externalStandardMapping : externalStandardMappings) {
                    List<TypeDef> currentTypeDefList;
                    if (externalStandardMapping == null) continue;
                    String activeTypeDefStandardName = externalStandardMapping.getStandardName();
                    String activeTypeDefStandardOrgName = externalStandardMapping.getStandardOrganization();
                    String activeTypeDefStandardIdentifier = externalStandardMapping.getStandardTypeName();
                    if (activeTypeDefStandardName != null) {
                        currentTypeDefList = this.standardsToTypeDefs.get(activeTypeDefStandardName);
                        if (currentTypeDefList == null) {
                            currentTypeDefList = new ArrayList<TypeDef>();
                        }
                        currentTypeDefList.add(activeTypeDef);
                        this.standardsToTypeDefs.put(activeTypeDefStandardName, currentTypeDefList);
                        continue;
                    }
                    if (activeTypeDefStandardOrgName != null) {
                        currentTypeDefList = this.orgToTypeDefs.get(activeTypeDefStandardOrgName);
                        if (currentTypeDefList == null) {
                            currentTypeDefList = new ArrayList<TypeDef>();
                        }
                        currentTypeDefList.add(activeTypeDef);
                        this.orgToTypeDefs.put(activeTypeDefStandardOrgName, currentTypeDefList);
                        continue;
                    }
                    if (activeTypeDefStandardIdentifier == null) continue;
                    currentTypeDefList = this.idToTypeDefs.get(activeTypeDefStandardIdentifier);
                    if (currentTypeDefList == null) {
                        currentTypeDefList = new ArrayList<TypeDef>();
                    }
                    currentTypeDefList.add(activeTypeDef);
                    this.idToTypeDefs.put(activeTypeDefStandardIdentifier, currentTypeDefList);
                }
            }
            discoveredProperties.put(discoveredProperty_numberOfMappedTypeDefs, mappedTypeDefs);
            for (String standard : this.standardsToTypeDefs.keySet()) {
                returnedTypeDefs = metadataCollection.findTypesByExternalID(testUserId, standard, null, null);
                expectedTypeDefs = this.standardsToTypeDefs.get(standard);
                this.assertCondition(returnedTypeDefs != null && returnedTypeDefs.size() == expectedTypeDefs.size(), assertion1, assertionMsg1 + standard);
            }
            for (String organization : this.orgToTypeDefs.keySet()) {
                returnedTypeDefs = metadataCollection.findTypesByExternalID(testUserId, null, organization, null);
                expectedTypeDefs = this.standardsToTypeDefs.get(organization);
                this.assertCondition(returnedTypeDefs != null && returnedTypeDefs.size() == expectedTypeDefs.size(), assertion2, assertionMsg2 + organization);
            }
            for (String identifier : this.idToTypeDefs.keySet()) {
                returnedTypeDefs = metadataCollection.findTypesByExternalID(testUserId, null, null, identifier);
                expectedTypeDefs = this.standardsToTypeDefs.get(identifier);
                this.assertCondition(returnedTypeDefs != null && returnedTypeDefs.size() == expectedTypeDefs.size(), assertion3, assertionMsg3 + identifier);
            }
        }
        this.assertCondition(true, assertion4, assertionMsg4);
        this.result.setSuccessMessage("Type definitions can be extracted by external standard identifiers");
        this.result.setDiscoveredProperties(discoveredProperties);
    }
}

