/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.conformance.tests.repository;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.conformance.tests.repository.OpenMetadataRepositoryTestCase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;

public class TestFindTypeDefsByCategory
extends OpenMetadataRepositoryTestCase {
    private static final String testUserId = "ConformanceTestUser";
    private static final String testCaseId = "repository-find-typedefs-by-category";
    private static final String testCaseName = "Repository find type definitions by category test case";
    private static final String assertion1 = "repository-find-typedefs-by-category-01";
    private static final String assertionMsg1 = "All type definitions returned by category.";
    private static final String discoveredProperty_numberOfEntityDefs = "Number of supported EntityDefs";
    private static final String discoveredProperty_entityDefs = "Supported EntityDefs";
    private static final String discoveredProperty_numberOfRelationshipDefs = "Number of supported RelationshipDefs";
    private static final String discoveredProperty_relationshipDefs = "Supported RelationshipDefs";
    private static final String discoveredProperty_numberOfClassificationDefs = "Number of supported ClassificationDefs";
    private static final String discoveredProperty_classificationDefs = "Supported ClassificationDefs";
    private List<TypeDef> allTypeDefs;
    private Map<String, EntityDef> entityDefs = new HashMap<String, EntityDef>();
    private List<RelationshipDef> relationshipDefs = new ArrayList<RelationshipDef>();
    private List<ClassificationDef> classificationDefs = new ArrayList<ClassificationDef>();

    TestFindTypeDefsByCategory(String workbenchId, List<TypeDef> allTypeDefs) {
        super(workbenchId, testCaseId, testCaseName);
        this.allTypeDefs = allTypeDefs;
    }

    public Map<String, EntityDef> getEntityDefs() {
        if (this.entityDefs.isEmpty()) {
            return null;
        }
        return this.entityDefs;
    }

    public List<RelationshipDef> getRelationshipDefs() {
        if (this.relationshipDefs.isEmpty()) {
            return null;
        }
        return this.relationshipDefs;
    }

    public List<ClassificationDef> getClassificationDefs() {
        if (this.classificationDefs.isEmpty()) {
            return null;
        }
        return this.classificationDefs;
    }

    @Override
    protected void run() throws Exception {
        ArrayList<String> supportedTypes;
        HashMap<String, Object> discoveredProperties = new HashMap<String, Object>();
        OMRSMetadataCollection metadataCollection = super.getMetadataCollection();
        List typeDefGallery = metadataCollection.findTypeDefsByCategory(testUserId, TypeDefCategory.ENTITY_DEF);
        if (typeDefGallery == null) {
            discoveredProperties.put(discoveredProperty_numberOfEntityDefs, 0);
        } else {
            discoveredProperties.put(discoveredProperty_numberOfEntityDefs, typeDefGallery.size());
            supportedTypes = new ArrayList<String>();
            for (TypeDef typeDef : typeDefGallery) {
                this.entityDefs.put(typeDef.getName(), (EntityDef)typeDef);
                supportedTypes.add(typeDef.getName());
            }
            discoveredProperties.put(discoveredProperty_entityDefs, supportedTypes);
        }
        typeDefGallery = metadataCollection.findTypeDefsByCategory(testUserId, TypeDefCategory.RELATIONSHIP_DEF);
        if (typeDefGallery == null) {
            discoveredProperties.put(discoveredProperty_numberOfRelationshipDefs, 0);
        } else {
            discoveredProperties.put(discoveredProperty_numberOfRelationshipDefs, typeDefGallery.size());
            supportedTypes = new ArrayList();
            for (TypeDef typeDef : typeDefGallery) {
                this.relationshipDefs.add((RelationshipDef)typeDef);
                supportedTypes.add(typeDef.getName());
            }
            discoveredProperties.put(discoveredProperty_relationshipDefs, supportedTypes);
        }
        typeDefGallery = metadataCollection.findTypeDefsByCategory(testUserId, TypeDefCategory.CLASSIFICATION_DEF);
        if (typeDefGallery == null) {
            discoveredProperties.put(discoveredProperty_numberOfClassificationDefs, 0);
        } else {
            discoveredProperties.put(discoveredProperty_numberOfClassificationDefs, typeDefGallery.size());
            supportedTypes = new ArrayList();
            for (TypeDef typeDef : typeDefGallery) {
                this.classificationDefs.add((ClassificationDef)typeDef);
                supportedTypes.add(typeDef.getName());
            }
            discoveredProperties.put(discoveredProperty_classificationDefs, supportedTypes);
        }
        this.assertCondition(this.entityDefs.size() + this.relationshipDefs.size() + this.classificationDefs.size() == this.allTypeDefs.size(), assertion1, assertionMsg1);
        this.result.setSuccessMessage("Type definitions can be extracted by category");
        this.result.setDiscoveredProperties(discoveredProperties);
    }
}

