/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.conformance.tests.repository;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.conformance.tests.repository.OpenMetadataRepositoryTestCase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefGallery;

public class TestGetTypeDefGallery
extends OpenMetadataRepositoryTestCase {
    private static final String testUserId = "ConformanceTestUser";
    private static final String testCaseId = "repository-get-typedef-gallery";
    private static final String testCaseName = "Repository get type definition gallery test case";
    private static final String testCaseSuccessMessage = "Repository type definition gallery retrieved";
    private static final String assertion1 = "repository-get-typedef-gallery-01";
    private static final String assertionMsg1 = "TypeDefGallery retrieved.";
    private static final String discoveredProperty_numberOfAttributeTypeDefs = "Number of supported AttributeTypeDefs";
    private static final String discoveredProperty_attributeTypeDefs = "Supported AttributeTypeDefs";
    private static final String discoveredProperty_numberOfTypeDefs = "Number of supported TypeDefs";
    private static final String discoveredProperty_typeDefs = "Supported TypeDefs";
    List<AttributeTypeDef> attributeTypeDefs = null;
    List<TypeDef> typeDefs = null;

    public List<AttributeTypeDef> getAttributeTypeDefs() {
        return this.attributeTypeDefs;
    }

    public List<TypeDef> getTypeDefs() {
        return this.typeDefs;
    }

    TestGetTypeDefGallery(String workbenchId) {
        super(workbenchId, testCaseId, testCaseName);
    }

    @Override
    protected void run() throws Exception {
        HashMap<String, Object> discoveredProperties = new HashMap<String, Object>();
        OMRSMetadataCollection metadataCollection = super.getMetadataCollection();
        TypeDefGallery typeDefGallery = metadataCollection.getAllTypes(testUserId);
        this.assertCondition(true, assertion1, assertionMsg1);
        if (typeDefGallery == null) {
            discoveredProperties.put(discoveredProperty_numberOfAttributeTypeDefs, 0);
            discoveredProperties.put(discoveredProperty_numberOfTypeDefs, 0);
        } else {
            ArrayList<String> supportedTypes;
            this.attributeTypeDefs = typeDefGallery.getAttributeTypeDefs();
            this.typeDefs = typeDefGallery.getTypeDefs();
            if (this.attributeTypeDefs == null) {
                discoveredProperties.put(discoveredProperty_numberOfAttributeTypeDefs, 0);
            } else {
                discoveredProperties.put(discoveredProperty_numberOfAttributeTypeDefs, this.attributeTypeDefs.size());
                supportedTypes = new ArrayList<String>();
                for (AttributeTypeDef attributeTypeDef : this.attributeTypeDefs) {
                    supportedTypes.add(attributeTypeDef.getName());
                }
                discoveredProperties.put(discoveredProperty_attributeTypeDefs, supportedTypes);
            }
            if (this.typeDefs == null) {
                discoveredProperties.put(discoveredProperty_numberOfTypeDefs, 0);
            } else {
                discoveredProperties.put(discoveredProperty_numberOfTypeDefs, this.typeDefs.size());
                supportedTypes = new ArrayList();
                for (TypeDef typeDef : this.typeDefs) {
                    supportedTypes.add(typeDef.getName());
                }
                discoveredProperties.put(discoveredProperty_typeDefs, supportedTypes);
            }
        }
        this.result.setSuccessMessage(testCaseSuccessMessage);
        this.result.setDiscoveredProperties(discoveredProperties);
    }
}

