/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.conformance.tests.repository;

import java.util.HashMap;
import org.odpi.openmetadata.conformance.tests.repository.OpenMetadataRepositoryTestCase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;

public class TestMetadataCollectionId
extends OpenMetadataRepositoryTestCase {
    private static final String testCaseId = "repository-metadata-collection";
    private static final String testCaseName = "Repository metadata collection id test case";
    private static final String assertion1 = "repository-metadata-collection-01";
    private static final String assertionMsg1 = "Metadata collection id retrieved from repository.";
    private static final String assertion2 = "repository-metadata-collection-02";
    private static final String assertionMsg2 = "Consistent metadata collection id retrieved from repository.";
    private String metadataCollectionId = null;

    public TestMetadataCollectionId(String workbenchId) {
        super(workbenchId, testCaseId, testCaseName);
    }

    public String getMetadataCollectionId() {
        return this.metadataCollectionId;
    }

    @Override
    protected void run() throws Exception {
        OMRSMetadataCollection metadataCollection;
        block2: {
            metadataCollection = super.getMetadataCollection();
            try {
                this.metadataCollectionId = metadataCollection.getMetadataCollectionId();
            }
            catch (RepositoryErrorException exception) {
                String[] frontOfMessageTokens;
                String[] tokens = exception.getErrorMessage().split(" on its REST API after it registered with the cohort");
                if (tokens.length <= 0 || (frontOfMessageTokens = tokens[0].split("returned a metadata collection identifier of ")).length <= 1) break block2;
                this.metadataCollectionId = frontOfMessageTokens[1];
                this.connector.setMetadataCollectionId(this.metadataCollectionId);
                metadataCollection = this.connector.getMetadataCollection();
            }
        }
        this.assertCondition(this.metadataCollectionId != null, assertion1, assertionMsg1);
        this.assertCondition(this.metadataCollectionId.equals(metadataCollection.getMetadataCollectionId()), assertion2, assertionMsg2);
        this.result.setSuccessMessage("Metadata collection id working consistently");
        HashMap<String, Object> discoveredProperties = new HashMap<String, Object>();
        discoveredProperties.put("metadata collection id", this.metadataCollectionId);
        this.result.setDiscoveredProperties(discoveredProperties);
    }
}

