/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.conformance.tests.repository;

import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.conformance.tests.repository.OpenMetadataRepositoryTestCase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.CollectionDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.CollectionDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;

public class TestSupportedAttributeTypeDef
extends OpenMetadataRepositoryTestCase {
    private static final String testUserId = "ConformanceTestUser";
    private static final String testCaseId = "repository-attribute-typedef";
    private static final String testCaseName = "Repository attribute type definition test case";
    private static final String testCaseSuccessMessage = " attribute type definition is compliant";
    private static final String discoveredProperty_attributeTypeDefGUID = " unique identifier (GUID)";
    private static final String discoveredProperty_attributeTypeDefDescription = " description";
    private static final String discoveredProperty_attributeTypeDefCategory = " category";
    private static final String discoveredProperty_attributeTypeDefVersion = " version";
    private static final String discoveredProperty_attributeTypeDefDescriptionGUID = " description GUID";
    private static final String assertion1 = "-01";
    private static final String assertionMsg1 = " type definition has a name.";
    private static final String assertion2 = "-02";
    private static final String assertionMsg2 = " type definition has a guid.";
    private static final String assertion3 = "-03";
    private static final String assertionMsg3 = " type definition has a version number.";
    private static final String assertion4 = "-04";
    private static final String assertionMsg4 = " type definition has a version name.";
    private static final String assertion5 = "-05";
    private static final String assertionMsg5 = " type definition has a valid category.";
    private static final String assertion6 = "-06";
    private static final String assertionMsg6 = " primitive type definition has a valid category.";
    private static final String assertion7 = "-07";
    private static final String assertionMsg7 = " collection type definition has a valid category.";
    private static final String assertion8 = "-08";
    private static final String assertionMsg8 = " collection type definition has a valid argument count and element types.";
    private static final String assertion9 = "-09";
    private static final String assertionMsg9 = " enum type definition has elements.";
    private static final String assertion10 = "-10";
    private static final String assertionMsg10 = " type verified by repository.";
    private static final String assertion11 = "-11";
    private static final String assertionMsg11 = " type retrieved from repository by name.";
    private static final String assertion12 = "-12";
    private static final String assertionMsg12 = " same type retrieved from repository by name.";
    private static final String assertion13 = "-13";
    private static final String assertionMsg13 = " type retrieved from repository by guid.";
    private static final String assertion14 = "-14";
    private static final String assertionMsg14 = " same type retrieved from repository by guid.";
    private AttributeTypeDef attributeTypeDef;

    TestSupportedAttributeTypeDef(String workbenchId, AttributeTypeDef attributeTypeDef) {
        super(workbenchId, testCaseId, testCaseName);
        this.attributeTypeDef = attributeTypeDef;
    }

    private String getAssertionName(String assertionId, String testTypeName) {
        return "repository-attribute-typedef-" + testTypeName + assertionId;
    }

    @Override
    protected void run() throws Exception {
        HashMap<String, Object> discoveredProperties = new HashMap<String, Object>();
        OMRSMetadataCollection metadataCollection = super.getMetadataCollection();
        String testTypeName = this.attributeTypeDef.getName();
        if (testTypeName == null) {
            testTypeName = "<null>";
            ((OpenMetadataRepositoryTestCase)this).testCaseId = "repository-attribute-typedef-" + testTypeName;
            this.result.setTestCaseId(((OpenMetadataRepositoryTestCase)this).testCaseId);
            this.assertCondition(false, this.getAssertionName(assertion1, testTypeName), testTypeName + assertionMsg1);
        } else {
            ((OpenMetadataRepositoryTestCase)this).testCaseId = "repository-attribute-typedef-" + testTypeName;
            this.result.setTestCaseId(((OpenMetadataRepositoryTestCase)this).testCaseId);
            this.assertCondition(true, this.getAssertionName(assertion1, testTypeName), testTypeName + assertionMsg1);
        }
        String guid = this.attributeTypeDef.getGUID();
        this.assertCondition(guid != null, this.getAssertionName(assertion2, testTypeName), testTypeName + assertionMsg2);
        long versionNumber = this.attributeTypeDef.getVersion();
        this.assertCondition(versionNumber != 0L, this.getAssertionName(assertion3, testTypeName), testTypeName + assertionMsg3);
        String versionName = this.attributeTypeDef.getVersionName();
        this.assertCondition(versionName != null, this.getAssertionName(assertion4, testTypeName), testTypeName + assertionMsg4);
        AttributeTypeDefCategory category = this.attributeTypeDef.getCategory();
        this.assertCondition(category != null && category != AttributeTypeDefCategory.UNKNOWN_DEF, this.getAssertionName(assertion5, testTypeName), testTypeName + assertionMsg5);
        String categoryName = category.getName();
        switch (category) {
            case PRIMITIVE: {
                PrimitiveDef primitiveDef = (PrimitiveDef)this.attributeTypeDef;
                PrimitiveDefCategory primitiveDefCategory = primitiveDef.getPrimitiveDefCategory();
                this.assertCondition(primitiveDefCategory != null, this.getAssertionName(assertion6, testTypeName), testTypeName + assertionMsg6);
                categoryName = categoryName + "<" + primitiveDefCategory.getName() + ">";
                break;
            }
            case COLLECTION: {
                CollectionDef collectionDef = (CollectionDef)this.attributeTypeDef;
                CollectionDefCategory collectionDefCategory = collectionDef.getCollectionDefCategory();
                this.assertCondition(collectionDefCategory != null && collectionDefCategory != CollectionDefCategory.OM_COLLECTION_UNKNOWN, this.getAssertionName(assertion7, testTypeName), testTypeName + assertionMsg7);
                int collectionArgCount = collectionDef.getArgumentCount();
                List collectionArgs = collectionDef.getArgumentTypes();
                this.assertCondition(collectionArgCount > 0 && collectionArgs != null && collectionArgCount == collectionArgs.size(), this.getAssertionName(assertion8, testTypeName), testTypeName + assertionMsg8);
                categoryName = categoryName + "<" + collectionDefCategory.getName() + ">";
                break;
            }
            case ENUM_DEF: {
                EnumDef enumDef = (EnumDef)this.attributeTypeDef;
                List enumElementDefs = enumDef.getElementDefs();
                this.assertCondition(enumElementDefs != null && !enumElementDefs.isEmpty(), this.getAssertionName(assertion9, testTypeName), testTypeName + assertionMsg9);
            }
        }
        this.assertCondition(metadataCollection.verifyAttributeTypeDef(testUserId, this.attributeTypeDef), this.getAssertionName(assertion10, testTypeName), testTypeName + assertionMsg10);
        AttributeTypeDef resultObject = metadataCollection.getAttributeTypeDefByName(testUserId, this.attributeTypeDef.getName());
        this.assertCondition(resultObject != null, this.getAssertionName(assertion11, testTypeName), testTypeName + assertionMsg11);
        this.assertCondition(this.attributeTypeDef.equals((Object)resultObject), this.getAssertionName(assertion12, testTypeName), testTypeName + assertionMsg12);
        resultObject = metadataCollection.getAttributeTypeDefByGUID(testUserId, this.attributeTypeDef.getGUID());
        this.assertCondition(resultObject != null, this.getAssertionName(assertion13, testTypeName), testTypeName + assertionMsg13);
        this.assertCondition(this.attributeTypeDef.equals((Object)resultObject), this.getAssertionName(assertion14, testTypeName), testTypeName + assertionMsg14);
        this.result.setSuccessMessage(testTypeName + testCaseSuccessMessage);
        discoveredProperties.put(testTypeName + discoveredProperty_attributeTypeDefGUID, guid);
        discoveredProperties.put(testTypeName + discoveredProperty_attributeTypeDefCategory, categoryName);
        discoveredProperties.put(testTypeName + discoveredProperty_attributeTypeDefVersion, versionName + "." + versionNumber);
        if (this.attributeTypeDef.getDescription() != null) {
            discoveredProperties.put(testTypeName + discoveredProperty_attributeTypeDefDescription, this.attributeTypeDef.getDescription());
        }
        if (this.attributeTypeDef.getDescriptionGUID() != null) {
            discoveredProperties.put(testTypeName + discoveredProperty_attributeTypeDefDescriptionGUID, this.attributeTypeDef.getDescriptionGUID());
        }
        this.result.setDiscoveredProperties(discoveredProperties);
    }
}

