/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.conformance.tests.repository;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.conformance.tests.repository.OpenMetadataRepositoryTestCase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;

public class TestSupportedClassificationLifecycle
extends OpenMetadataRepositoryTestCase {
    private static final String testUserId = "ConformanceTestUser";
    private static final String testCaseId = "repository-classification-lifecycle";
    private static final String testCaseName = "Repository classification lifecycle test case";
    private static final String assertion1 = "repository-classification-lifecycle-01";
    private static final String assertionMsg1 = " classification can attach to a supported entity.";
    private static final String assertion2 = "repository-classification-lifecycle-02";
    private static final String assertionMsg2 = " classification added to entity of type ";
    private static final String assertion3 = "repository-classification-lifecycle-03";
    private static final String assertionMsg3 = " classification properties added to entity of type ";
    private static final String assertion4 = "repository-classification-lifecycle-04";
    private static final String assertionMsg4 = " classification removed from entity of type ";
    private static final String assertion5 = "repository-classification-lifecycle-05";
    private static final String assertionMsg5 = " classification added to all identified entities";
    private String metadataCollectionId;
    private Map<String, EntityDef> entityDefs;
    private ClassificationDef classificationDef;

    TestSupportedClassificationLifecycle(String workbenchId, String metadataCollectionId, Map<String, EntityDef> entityDefs, ClassificationDef classificationDef) {
        super(workbenchId, testCaseId, testCaseName);
        this.metadataCollectionId = metadataCollectionId;
        this.classificationDef = classificationDef;
        this.entityDefs = entityDefs;
    }

    @Override
    protected void run() throws Exception {
        HashMap<String, Object> discoveredProperties = new HashMap<String, Object>();
        OMRSMetadataCollection metadataCollection = super.getMetadataCollection();
        ArrayList<EntityDef> testEntityDefs = new ArrayList<EntityDef>();
        String testTypeName = this.classificationDef.getName();
        List classifiableEntities = this.classificationDef.getValidEntityDefs();
        if (classifiableEntities != null) {
            for (TypeDefLink typeDefLink : classifiableEntities) {
                EntityDef testEntityDef = this.getEntityDef(this.entityDefs, typeDefLink);
                if (testEntityDef == null) continue;
                testEntityDefs.add(testEntityDef);
            }
        }
        this.assertCondition(!testEntityDefs.isEmpty(), assertion1, testTypeName + assertionMsg1);
        ArrayList<EntityDetail> classifiedEntities = new ArrayList<EntityDetail>();
        for (EntityDef testEntityDef : testEntityDefs) {
            EntityDetail declassifiedEntity;
            EntityDetail testEntity = this.addEntityToRepository(testTypeName, metadataCollection, testEntityDef);
            EntityDetail classifiedEntity = metadataCollection.classifyEntity(testUserId, testEntity.getGUID(), this.classificationDef.getName(), null);
            if (classifiedEntity != null) {
                classifiedEntities.add(classifiedEntity);
            }
            Classification initialClassification = null;
            List classifications = classifiedEntity.getClassifications();
            if (classifications != null && classifications.size() == 1) {
                initialClassification = (Classification)classifications.get(0);
            }
            this.assertCondition(initialClassification != null && this.classificationDef.getName().equals(initialClassification.getName()) && initialClassification.getProperties() == null, assertion2, testTypeName + assertionMsg2 + testEntityDef.getName());
            InstanceProperties classificationProperties = this.getPropertiesForInstance(this.classificationDef.getPropertiesDefinition());
            if (classificationProperties != null) {
                EntityDetail reclassifiedEntity = metadataCollection.updateEntityClassification(testUserId, testEntity.getGUID(), this.classificationDef.getName(), classificationProperties);
                Classification updatedClassification = null;
                classifications = reclassifiedEntity.getClassifications();
                if (classifications != null && classifications.size() == 1) {
                    updatedClassification = (Classification)classifications.get(0);
                }
                this.assertCondition(updatedClassification != null && this.classificationDef.getName().equals(initialClassification.getName()) && updatedClassification.getProperties() != null, assertion3, testTypeName + assertionMsg3 + testEntityDef.getName());
            }
            this.assertCondition((declassifiedEntity = metadataCollection.declassifyEntity(testUserId, testEntity.getGUID(), this.classificationDef.getName())) != null && declassifiedEntity.getClassifications() == null, assertion4, testTypeName + assertionMsg4 + testEntityDef.getName());
        }
        this.assertCondition(testEntityDefs.size() == classifiableEntities.size(), assertion5, testTypeName + assertionMsg5);
        this.result.setSuccessMessage("Classifications can be managed through their lifecycle");
        this.result.setDiscoveredProperties(discoveredProperties);
    }
}

