/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.conformance.tests.repository;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.odpi.openmetadata.conformance.tests.repository.OpenMetadataRepositoryTestCase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.StatusNotSupportedException;

public class TestSupportedEntityLifecycle
extends OpenMetadataRepositoryTestCase {
    private static final String testUserId = "ConformanceTestUser";
    private static final String testCaseId = "repository-entity-lifecycle";
    private static final String testCaseName = "Repository entity lifecycle test case";
    private static final String assertion1 = "repository-entity-lifecycle-01";
    private static final String assertionMsg1 = " new entity created.";
    private static final String assertion2 = "repository-entity-lifecycle-02";
    private static final String assertionMsg2 = " new entity has createdBy user.";
    private static final String assertion3 = "repository-entity-lifecycle-03";
    private static final String assertionMsg3 = " new entity has creation time.";
    private static final String assertion4 = "repository-entity-lifecycle-04";
    private static final String assertionMsg4 = " new entity has correct provenance type.";
    private static final String assertion5 = "repository-entity-lifecycle-05";
    private static final String assertionMsg5 = " new entity has correct initial status.";
    private static final String assertion6 = "repository-entity-lifecycle-06";
    private static final String assertionMsg6 = " new entity has correct type.";
    private static final String assertion7 = "repository-entity-lifecycle-07";
    private static final String assertionMsg7 = " new entity has local metadata collection.";
    private static final String assertion8 = "repository-entity-lifecycle-08";
    private static final String assertionMsg8 = " new entity has version greater than zero.";
    private static final String assertion9 = "repository-entity-lifecycle-09";
    private static final String assertionMsg9 = " new entity is known.";
    private static final String assertion10 = "repository-entity-lifecycle-10";
    private static final String assertionMsg10 = " new entity summarized.";
    private static final String assertion11 = "repository-entity-lifecycle-11";
    private static final String assertionMsg11 = " new entity retrieved.";
    private static final String assertion12 = "repository-entity-lifecycle-12";
    private static final String assertionMsg12 = " new entity is unattached.";
    private static final String assertion13 = "repository-entity-lifecycle-13";
    private static final String assertionMsg13 = " entity status updated.";
    private static final String assertion14 = "repository-entity-lifecycle-14";
    private static final String assertionMsg14 = " entity new status is ";
    private static final String assertion15 = "repository-entity-lifecycle-15";
    private static final String assertionMsg15 = " entity with new status version number is ";
    private static final String assertion16 = "repository-entity-lifecycle-16";
    private static final String assertionMsg16 = " entity can not be set to DELETED status.";
    private static final String assertion17 = "repository-entity-lifecycle-17";
    private static final String assertionMsg17 = " entity properties cleared to min.";
    private static final String assertion18 = "repository-entity-lifecycle-18";
    private static final String assertionMsg18 = " entity with min properties version number is ";
    private static final String assertion19 = "repository-entity-lifecycle-19";
    private static final String assertionMsg19 = " entity has properties restored.";
    private static final String assertion20 = "repository-entity-lifecycle-20";
    private static final String assertionMsg20 = " entity after undo version number is ";
    private static final String assertion21 = "repository-entity-lifecycle-21";
    private static final String assertionMsg21 = " entity deleted version number is ";
    private static final String assertion22 = "repository-entity-lifecycle-22";
    private static final String assertionMsg22 = " entity no longer retrievable after delete.";
    private static final String assertion23 = "repository-entity-lifecycle-23";
    private static final String assertionMsg23 = " entity restored version number is ";
    private static final String assertion24 = "repository-entity-lifecycle-24";
    private static final String assertionMsg24 = " entity purged.";
    private static final String discoveredProperty_undoSupport = " undo support";
    private static final String discoveredProperty_softDeleteSupport = " soft delete support";
    private String metadataCollectionId;
    private EntityDef entityDef;

    TestSupportedEntityLifecycle(String workbenchId, String metadataCollectionId, EntityDef entityDef) {
        super(workbenchId, testCaseId, testCaseName);
        this.metadataCollectionId = metadataCollectionId;
        this.entityDef = entityDef;
    }

    @Override
    protected void run() throws Exception {
        HashMap<String, Object> discoveredProperties = new HashMap<String, Object>();
        OMRSMetadataCollection metadataCollection = super.getMetadataCollection();
        String testTypeName = this.entityDef.getName();
        EntityDetail newEntity = metadataCollection.addEntity(testUserId, this.entityDef.getGUID(), super.getAllPropertiesForInstance(testUserId, (TypeDef)this.entityDef), null, null);
        this.assertCondition(newEntity != null, assertion1, testTypeName + assertionMsg1);
        this.assertCondition(testUserId.equals(newEntity.getCreatedBy()), assertion2, testTypeName + assertionMsg2);
        this.assertCondition(newEntity.getCreateTime() != null, assertion3, testTypeName + assertionMsg3);
        this.assertCondition(newEntity.getInstanceProvenanceType() == InstanceProvenanceType.LOCAL_COHORT, assertion4, testTypeName + assertionMsg4);
        this.assertCondition(newEntity.getStatus() == this.entityDef.getInitialStatus(), assertion5, testTypeName + assertionMsg5);
        InstanceType instanceType = newEntity.getType();
        if (instanceType != null) {
            this.assertCondition(instanceType.getTypeDefGUID().equals(this.entityDef.getGUID()) && instanceType.getTypeDefName().equals(testTypeName), assertion6, testTypeName + assertionMsg6);
        } else {
            this.assertCondition(false, assertion6, testTypeName + assertionMsg6);
        }
        this.assertCondition(newEntity.getMetadataCollectionId() != null && newEntity.getMetadataCollectionId().equals(this.metadataCollectionId), assertion7, testTypeName + assertionMsg7);
        this.assertCondition(newEntity.getVersion() > 0L, assertion8, testTypeName + assertionMsg8);
        this.assertCondition(newEntity.equals((Object)metadataCollection.isEntityKnown(testUserId, newEntity.getGUID())), assertion9, testTypeName + assertionMsg9);
        this.assertCondition(metadataCollection.getEntitySummary(testUserId, newEntity.getGUID()) != null, assertion10, testTypeName + assertionMsg10);
        this.assertCondition(newEntity.equals((Object)metadataCollection.getEntityDetail(testUserId, newEntity.getGUID())), assertion11, testTypeName + assertionMsg11);
        this.assertCondition(metadataCollection.getRelationshipsForEntity(testUserId, newEntity.getGUID(), null, 0, null, null, null, null, 0) == null, assertion12, testTypeName + assertionMsg12);
        long nextVersion = newEntity.getVersion() + 1L;
        for (InstanceStatus validInstanceStatus : this.entityDef.getValidInstanceStatusList()) {
            if (validInstanceStatus == InstanceStatus.DELETED) continue;
            EntityDetail updatedEntity = metadataCollection.updateEntityStatus(testUserId, newEntity.getGUID(), validInstanceStatus);
            this.assertCondition(updatedEntity != null, assertion13, testTypeName + assertionMsg13);
            this.assertCondition(updatedEntity.getStatus() == validInstanceStatus, assertion14, testTypeName + assertionMsg14 + validInstanceStatus.getName());
            this.assertCondition(updatedEntity.getVersion() >= nextVersion, assertion15, testTypeName + assertionMsg15 + nextVersion);
            nextVersion = updatedEntity.getVersion() + 1L;
        }
        try {
            metadataCollection.updateEntityStatus(testUserId, newEntity.getGUID(), InstanceStatus.DELETED);
            this.assertCondition(false, assertion16, testTypeName + assertionMsg16);
        }
        catch (StatusNotSupportedException exception) {
            this.assertCondition(true, assertion16, testTypeName + assertionMsg16);
        }
        if (newEntity.getProperties() != null && newEntity.getProperties().getInstanceProperties() != null && !newEntity.getProperties().getInstanceProperties().isEmpty()) {
            InstanceProperties minEntityProps = super.getMinPropertiesForInstance(testUserId, (TypeDef)this.entityDef);
            EntityDetail minPropertiesEntity = metadataCollection.updateEntityProperties(testUserId, newEntity.getGUID(), minEntityProps);
            this.assertCondition(minPropertiesEntity != null && this.doPropertiesMatch(minEntityProps, minPropertiesEntity.getProperties()), assertion17, testTypeName + assertionMsg17);
            this.assertCondition(minPropertiesEntity != null && minPropertiesEntity.getVersion() >= nextVersion, assertion18, testTypeName + assertionMsg18 + nextVersion);
            nextVersion = minPropertiesEntity.getVersion() + 1L;
            try {
                EntityDetail undoneEntity = metadataCollection.undoEntityUpdate(testUserId, newEntity.getGUID());
                discoveredProperties.put(testTypeName + discoveredProperty_undoSupport, "Enabled");
                this.result.setDiscoveredProperties(discoveredProperties);
                this.assertCondition(undoneEntity != null && undoneEntity.getProperties() != null, assertion19, testTypeName + assertionMsg19);
                this.assertCondition(undoneEntity != null && undoneEntity.getVersion() >= nextVersion, assertion20, testTypeName + assertionMsg20 + nextVersion);
                nextVersion = undoneEntity.getVersion() + 1L;
            }
            catch (FunctionNotSupportedException exception) {
                discoveredProperties.put(testTypeName + discoveredProperty_undoSupport, "Disabled");
                this.result.setDiscoveredProperties(discoveredProperties);
            }
        }
        try {
            EntityDetail deletedEntity = metadataCollection.deleteEntity(testUserId, newEntity.getType().getTypeDefGUID(), newEntity.getType().getTypeDefName(), newEntity.getGUID());
            discoveredProperties.put(testTypeName + discoveredProperty_softDeleteSupport, "Enabled");
            this.result.setDiscoveredProperties(discoveredProperties);
            this.assertCondition(deletedEntity != null && deletedEntity.getVersion() >= nextVersion, assertion21, testTypeName + assertionMsg21 + nextVersion);
            nextVersion = deletedEntity.getVersion() + 1L;
            try {
                metadataCollection.getEntityDetail(testUserId, newEntity.getGUID());
                this.assertCondition(false, assertion22, testTypeName + assertionMsg22);
            }
            catch (EntityNotKnownException exception) {
                this.assertCondition(true, assertion22, testTypeName + assertionMsg22);
            }
            EntityDetail restoredEntity = metadataCollection.restoreEntity(testUserId, newEntity.getGUID());
            this.assertCondition(restoredEntity != null && restoredEntity.getVersion() >= nextVersion, assertion23, testTypeName + assertionMsg23 + nextVersion);
            metadataCollection.deleteEntity(testUserId, newEntity.getType().getTypeDefGUID(), newEntity.getType().getTypeDefName(), newEntity.getGUID());
        }
        catch (FunctionNotSupportedException exception) {
            discoveredProperties.put(testTypeName + discoveredProperty_softDeleteSupport, "Disabled");
            this.result.setDiscoveredProperties(discoveredProperties);
        }
        metadataCollection.purgeEntity(testUserId, newEntity.getType().getTypeDefGUID(), newEntity.getType().getTypeDefName(), newEntity.getGUID());
        try {
            metadataCollection.getEntityDetail(testUserId, newEntity.getGUID());
            this.assertCondition(false, assertion24, testTypeName + assertionMsg24);
        }
        catch (EntityNotKnownException exception) {
            this.assertCondition(true, assertion24, testTypeName + assertionMsg24);
        }
        this.result.setSuccessMessage("Entities can be managed through their lifecycle");
        this.result.setDiscoveredProperties(discoveredProperties);
    }

    private boolean doPropertiesMatch(InstanceProperties firstInstanceProps, InstanceProperties secondInstanceProps) {
        boolean matchProperties = false;
        boolean noProperties = false;
        if (secondInstanceProps == null || secondInstanceProps.getInstanceProperties() == null || secondInstanceProps.getInstanceProperties().isEmpty()) {
            noProperties = true;
        }
        if (noProperties) {
            if (firstInstanceProps.getInstanceProperties() == null || firstInstanceProps.getInstanceProperties().isEmpty()) {
                matchProperties = true;
            }
        } else {
            boolean matchSizes;
            Map secondPropertiesMap = secondInstanceProps.getInstanceProperties();
            Map firstPropertiesMap = firstInstanceProps.getInstanceProperties();
            boolean bl = matchSizes = secondPropertiesMap.size() == firstPropertiesMap.size();
            if (matchSizes) {
                Set firstPropertiesKeySet;
                boolean matchKeys;
                Set secondPropertiesKeySet = secondPropertiesMap.keySet();
                boolean bl2 = matchKeys = secondPropertiesKeySet.containsAll(firstPropertiesKeySet = firstPropertiesMap.keySet()) && firstPropertiesKeySet.containsAll(secondPropertiesKeySet);
                if (matchKeys) {
                    boolean matchValues = true;
                    for (String key : secondPropertiesKeySet) {
                        if (((InstancePropertyValue)secondPropertiesMap.get(key)).equals(firstPropertiesMap.get(key))) continue;
                        matchValues = false;
                    }
                    if (matchValues) {
                        matchProperties = true;
                    }
                }
            }
        }
        return matchProperties;
    }
}

