/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.conformance.tests.repository;

import java.util.HashMap;
import java.util.Map;
import org.odpi.openmetadata.conformance.tests.repository.OpenMetadataRepositoryTestCase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;

public class TestSupportedRelationshipLifecycle
extends OpenMetadataRepositoryTestCase {
    private static final String testUserId = "ConformanceTestUser";
    private static final String testCaseId = "repository-relationship-lifecycle";
    private static final String testCaseName = "Repository relationship lifecycle test case";
    private static final String assertion1 = "repository-relationship-lifecycle-01";
    private static final String assertionMsg1 = " new relationship created.";
    private static final String assertion2 = "repository-relationship-lifecycle-02";
    private static final String assertionMsg2 = " new relationship has createdBy user.";
    private static final String assertion3 = "repository-relationship-lifecycle-03";
    private static final String assertionMsg3 = " new relationship has creation time.";
    private static final String assertion4 = "repository-relationship-lifecycle-04";
    private static final String assertionMsg4 = " new relationship has correct provenance type.";
    private static final String assertion5 = "repository-relationship-lifecycle-05";
    private static final String assertionMsg5 = " new relationship has correct initial status.";
    private static final String assertion6 = "repository-relationship-lifecycle-06";
    private static final String assertionMsg6 = " new relationship has correct type.";
    private static final String assertion7 = "repository-relationship-lifecycle-07";
    private static final String assertionMsg7 = " new relationship has local metadata collection.";
    private static final String assertion8 = "repository-relationship-lifecycle-08";
    private static final String assertionMsg8 = " new relationship has version greater than zero.";
    private static final String assertion9 = "repository-relationship-lifecycle-09";
    private static final String assertionMsg9 = " new relationship is known.";
    private static final String assertion10 = "repository-relationship-lifecycle-10";
    private static final String assertionMsg10 = " new relationship retrieved.";
    private static final String assertion11 = "repository-relationship-lifecycle-11";
    private static final String assertionMsg11 = " relationship deleted version number is ";
    private static final String assertion12 = "repository-relationship-lifecycle-12";
    private static final String assertionMsg12 = " relationship no longer retrievable after delete.";
    private static final String assertion13 = "repository-relationship-lifecycle-13";
    private static final String assertionMsg13 = " relationship restored version number is ";
    private static final String assertion14 = "repository-relationship-lifecycle-14";
    private static final String assertionMsg14 = " relationship purged.";
    private static final String discoveredProperty_softDeleteSupport = " soft delete support";
    private String metadataCollectionId;
    private Map<String, EntityDef> entityDefs;
    private RelationshipDef relationshipDef;

    TestSupportedRelationshipLifecycle(String workbenchId, String metadataCollectionId, Map<String, EntityDef> entityDefs, RelationshipDef relationshipDef) {
        super(workbenchId, testCaseId, testCaseName);
        this.metadataCollectionId = metadataCollectionId;
        this.relationshipDef = relationshipDef;
        this.entityDefs = entityDefs;
    }

    @Override
    protected void run() throws Exception {
        HashMap<String, Object> discoveredProperties = new HashMap<String, Object>();
        OMRSMetadataCollection metadataCollection = super.getMetadataCollection();
        String testTypeName = this.relationshipDef.getName();
        EntityDef end1Type = this.entityDefs.get(this.relationshipDef.getEndDef1().getEntityType().getName());
        EntityDetail end1 = this.addEntityToRepository(testUserId, metadataCollection, end1Type);
        EntityDef end2Type = this.entityDefs.get(this.relationshipDef.getEndDef2().getEntityType().getName());
        EntityDetail end2 = this.addEntityToRepository(testUserId, metadataCollection, end2Type);
        Relationship newRelationship = metadataCollection.addRelationship(testUserId, this.relationshipDef.getGUID(), super.getPropertiesForInstance(this.relationshipDef.getPropertiesDefinition()), end1.getGUID(), end2.getGUID(), null);
        this.assertCondition(newRelationship != null, assertion1, testTypeName + assertionMsg1);
        this.assertCondition(testUserId.equals(newRelationship.getCreatedBy()), assertion2, testTypeName + assertionMsg2);
        this.assertCondition(newRelationship.getCreateTime() != null, assertion3, testTypeName + assertionMsg3);
        this.assertCondition(newRelationship.getInstanceProvenanceType() == InstanceProvenanceType.LOCAL_COHORT, assertion4, testTypeName + assertionMsg4);
        this.assertCondition(newRelationship.getStatus() == this.relationshipDef.getInitialStatus(), assertion5, testTypeName + assertionMsg5);
        InstanceType instanceType = newRelationship.getType();
        if (instanceType != null) {
            this.assertCondition(instanceType.getTypeDefGUID().equals(this.relationshipDef.getGUID()) && instanceType.getTypeDefName().equals(testTypeName), assertion6, testTypeName + assertionMsg6);
        } else {
            this.assertCondition(false, assertion6, testTypeName + assertionMsg6);
        }
        this.assertCondition(newRelationship.getMetadataCollectionId() != null && newRelationship.getMetadataCollectionId().equals(this.metadataCollectionId), assertion7, testTypeName + assertionMsg7);
        this.assertCondition(newRelationship.getVersion() > 0L, assertion8, testTypeName + assertionMsg8);
        this.assertCondition(newRelationship.equals((Object)metadataCollection.isRelationshipKnown(testUserId, newRelationship.getGUID())), assertion9, testTypeName + assertionMsg9);
        this.assertCondition(newRelationship.equals((Object)metadataCollection.getRelationship(testUserId, newRelationship.getGUID())), assertion10, testTypeName + assertionMsg10);
        long nextVersion = newRelationship.getVersion() + 1L;
        try {
            Relationship deletedRelationship = metadataCollection.deleteRelationship(testUserId, newRelationship.getType().getTypeDefGUID(), newRelationship.getType().getTypeDefName(), newRelationship.getGUID());
            discoveredProperties.put(testTypeName + discoveredProperty_softDeleteSupport, "Enabled");
            this.result.setDiscoveredProperties(discoveredProperties);
            this.assertCondition(deletedRelationship != null && deletedRelationship.getVersion() >= nextVersion, assertion11, testTypeName + assertionMsg11 + nextVersion);
            nextVersion = deletedRelationship.getVersion() + 1L;
            try {
                metadataCollection.getRelationship(testUserId, newRelationship.getGUID());
                this.assertCondition(false, assertion12, testTypeName + assertionMsg12);
            }
            catch (RelationshipNotKnownException exception) {
                this.assertCondition(true, assertion12, testTypeName + assertionMsg12);
            }
            Relationship restoredRelationship = metadataCollection.restoreRelationship(testUserId, newRelationship.getGUID());
            this.assertCondition(restoredRelationship != null && restoredRelationship.getVersion() >= nextVersion, assertion13, testTypeName + assertionMsg13 + nextVersion);
            metadataCollection.deleteRelationship(testUserId, newRelationship.getType().getTypeDefGUID(), newRelationship.getType().getTypeDefName(), newRelationship.getGUID());
        }
        catch (FunctionNotSupportedException exception) {
            discoveredProperties.put(testTypeName + discoveredProperty_softDeleteSupport, "Disabled");
            this.result.setDiscoveredProperties(discoveredProperties);
        }
        metadataCollection.purgeRelationship(testUserId, newRelationship.getType().getTypeDefGUID(), newRelationship.getType().getTypeDefName(), newRelationship.getGUID());
        try {
            metadataCollection.getRelationship(testUserId, newRelationship.getGUID());
            this.assertCondition(false, assertion14, testTypeName + assertionMsg14);
        }
        catch (RelationshipNotKnownException exception) {
            this.assertCondition(true, assertion14, testTypeName + assertionMsg14);
        }
        this.result.setSuccessMessage("Relationships can be managed through their lifecycle");
        this.result.setDiscoveredProperties(discoveredProperties);
    }
}

