/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.conformance.tests.repository;

import java.util.ArrayList;
import java.util.HashMap;
import org.odpi.openmetadata.conformance.tests.repository.OpenMetadataRepositoryTestCase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefGallery;

public class TestSupportedTypeDef
extends OpenMetadataRepositoryTestCase {
    private static final String testUserId = "ConformanceTestUser";
    private static final String testCaseId = "repository-typedef";
    private static final String testCaseName = "Repository type definition test case";
    private static final String testCaseSuccessMessage = " type definition is compliant";
    private static final String discoveredProperty_typeDefGUID = " unique identifier (GUID)";
    private static final String discoveredProperty_typeDefDescription = " description";
    private static final String discoveredProperty_typeDefCategory = " category";
    private static final String discoveredProperty_typeDefVersion = " version";
    private static final String discoveredProperty_typeDefDescriptionGUID = " description GUID";
    private static final String discoveredProperty_externalIdentifiers = " external identifier mapping";
    private static final String assertion1 = "-01";
    private static final String assertionMsg1 = " type definition has a name.";
    private static final String assertion2 = "-02";
    private static final String assertionMsg2 = " type definition has a guid.";
    private static final String assertion3 = "-03";
    private static final String assertionMsg3 = " type definition has a version number.";
    private static final String assertion4 = "-04";
    private static final String assertionMsg4 = " type definition has a version name.";
    private static final String assertion5 = "-05";
    private static final String assertionMsg5 = " type definition has a valid category.";
    private static final String assertion6 = "-06";
    private static final String assertionMsg6 = " type definition has a valid origin.";
    private static final String assertion7 = "-07";
    private static final String assertionMsg7 = " type definition has a creator.";
    private static final String assertion8 = "-08";
    private static final String assertionMsg8 = " type definition has a creation date.";
    private static final String assertion9 = "-09";
    private static final String assertionMsg9 = " type definition has a valid initial status.";
    private static final String assertion10 = "-10";
    private static final String assertionMsg10 = " type definition has a list of valid statuses.";
    private static final String assertion11 = "-11";
    private static final String assertionMsg11 = " classification can be added to at least one entity.";
    private static final String assertion12 = "-12";
    private static final String assertionMsg12 = " relationship type definition has two ends.";
    private static final String assertion13 = "-13";
    private static final String assertionMsg13 = " type verified by repository.";
    private static final String assertion14 = "-14";
    private static final String assertionMsg14 = " type retrieved from repository by name.";
    private static final String assertion15 = "-15";
    private static final String assertionMsg15 = " same type retrieved from repository by name.";
    private static final String assertion16 = "-16";
    private static final String assertionMsg16 = " type retrieved from repository by guid.";
    private static final String assertion17 = "-17";
    private static final String assertionMsg17 = " same type retrieved from repository by guid.";
    private static final String assertion18 = "-18";
    private static final String assertionMsg18 = " type found by repository by name.";
    private static final String assertion19 = "-19";
    private static final String assertionMsg19 = " same type found by repository by name.";
    private static final String assertion20 = "-20";
    private static final String assertionMsg20 = " type name is unique.";
    private TypeDef typeDef;

    TestSupportedTypeDef(String workbenchId, TypeDef typeDef) {
        super(workbenchId, testCaseId, testCaseName);
        this.typeDef = typeDef;
    }

    private String getAssertionName(String assertionId, String testTypeName) {
        return "repository-typedef-" + testTypeName + assertionId;
    }

    @Override
    protected void run() throws Exception {
        HashMap<String, Object> discoveredProperties = new HashMap<String, Object>();
        OMRSMetadataCollection metadataCollection = super.getMetadataCollection();
        String testTypeName = this.typeDef.getName();
        if (testTypeName == null) {
            testTypeName = "<null>";
            ((OpenMetadataRepositoryTestCase)this).testCaseId = "repository-typedef-" + testTypeName;
            this.result.setTestCaseId(((OpenMetadataRepositoryTestCase)this).testCaseId);
            this.assertCondition(false, this.getAssertionName(assertion1, testTypeName), testTypeName + assertionMsg1);
        } else {
            ((OpenMetadataRepositoryTestCase)this).testCaseId = "repository-typedef-" + testTypeName;
            this.result.setTestCaseId(((OpenMetadataRepositoryTestCase)this).testCaseId);
            this.assertCondition(true, this.getAssertionName(assertion1, testTypeName), testTypeName + assertionMsg1);
        }
        String guid = this.typeDef.getGUID();
        this.assertCondition(guid != null, this.getAssertionName(assertion2, testTypeName), testTypeName + assertionMsg2);
        long versionNumber = this.typeDef.getVersion();
        this.assertCondition(versionNumber != 0L, this.getAssertionName(assertion3, testTypeName), testTypeName + assertionMsg3);
        String versionName = this.typeDef.getVersionName();
        this.assertCondition(versionName != null, this.getAssertionName(assertion4, testTypeName), testTypeName + assertionMsg4);
        TypeDefCategory category = this.typeDef.getCategory();
        this.assertCondition(category != null && category != TypeDefCategory.UNKNOWN_DEF, this.getAssertionName(assertion5, testTypeName), testTypeName + assertionMsg5);
        String categoryName = category.getName();
        String origin = this.typeDef.getOrigin();
        this.assertCondition(origin != null, this.getAssertionName(assertion6, testTypeName), testTypeName + assertionMsg6);
        this.assertCondition(this.typeDef.getCreatedBy() != null && (this.typeDef.getVersion() == 1L || this.typeDef.getUpdatedBy() != null), this.getAssertionName(assertion7, testTypeName), testTypeName + assertionMsg7);
        this.assertCondition(this.typeDef.getCreateTime() != null && (this.typeDef.getVersion() == 1L || this.typeDef.getUpdateTime() != null), this.getAssertionName(assertion8, testTypeName), testTypeName + assertionMsg8);
        this.assertCondition(this.typeDef.getValidInstanceStatusList() != null, this.getAssertionName(assertion10, testTypeName), testTypeName + assertionMsg10);
        this.assertCondition(this.typeDef.getInitialStatus() != null && this.typeDef.getValidInstanceStatusList().contains(this.typeDef.getInitialStatus()), this.getAssertionName(assertion9, testTypeName), testTypeName + assertionMsg9);
        switch (category) {
            case ENTITY_DEF: {
                break;
            }
            case CLASSIFICATION_DEF: {
                ClassificationDef classificationDef = (ClassificationDef)this.typeDef;
                this.assertCondition(classificationDef.getValidEntityDefs() != null, this.getAssertionName(assertion11, testTypeName), testTypeName + assertionMsg11);
                break;
            }
            case RELATIONSHIP_DEF: {
                RelationshipDef relationshipDef = (RelationshipDef)this.typeDef;
                this.assertCondition(relationshipDef.getEndDef1() != null && relationshipDef.getEndDef2() != null, this.getAssertionName(assertion12, testTypeName), testTypeName + assertionMsg12);
            }
        }
        this.assertCondition(metadataCollection.verifyTypeDef(testUserId, this.typeDef), this.getAssertionName(assertion13, testTypeName), testTypeName + assertionMsg13);
        TypeDef resultObject = metadataCollection.getTypeDefByName(testUserId, this.typeDef.getName());
        this.assertCondition(resultObject != null, this.getAssertionName(assertion14, testTypeName), testTypeName + assertionMsg14);
        this.assertCondition(this.typeDef.equals((Object)resultObject), this.getAssertionName(assertion15, testTypeName), testTypeName + assertionMsg15);
        resultObject = metadataCollection.getTypeDefByGUID(testUserId, this.typeDef.getGUID());
        this.assertCondition(resultObject != null, this.getAssertionName(assertion16, testTypeName), testTypeName + assertionMsg16);
        this.assertCondition(this.typeDef.equals((Object)resultObject), this.getAssertionName(assertion17, testTypeName), testTypeName + assertionMsg17);
        TypeDefGallery resultGallery = metadataCollection.findTypesByName(testUserId, this.typeDef.getName());
        ArrayList resultList = resultGallery.getTypeDefs();
        this.assertCondition(resultList != null, this.getAssertionName(assertion18, testTypeName), testTypeName + assertionMsg18);
        this.assertCondition(resultList.contains(this.typeDef), this.getAssertionName(assertion19, testTypeName), testTypeName + assertionMsg19);
        this.assertCondition(resultGallery.getAttributeTypeDefs() == null && resultList.size() == 1, this.getAssertionName(assertion20, testTypeName), testTypeName + assertionMsg20);
        this.result.setSuccessMessage(testTypeName + testCaseSuccessMessage);
        discoveredProperties.put(testTypeName + discoveredProperty_typeDefGUID, guid);
        discoveredProperties.put(testTypeName + discoveredProperty_typeDefCategory, categoryName);
        discoveredProperties.put(testTypeName + discoveredProperty_typeDefVersion, versionName + "." + versionNumber);
        if (this.typeDef.getDescription() != null) {
            discoveredProperties.put(testTypeName + discoveredProperty_typeDefDescription, this.typeDef.getDescription());
        }
        if (this.typeDef.getDescriptionGUID() != null) {
            discoveredProperties.put(testTypeName + discoveredProperty_typeDefDescriptionGUID, this.typeDef.getDescriptionGUID());
        }
        if (this.typeDef.getExternalStandardMappings() != null) {
            discoveredProperties.put(testTypeName + discoveredProperty_externalIdentifiers, this.typeDef.getExternalStandardMappings());
        }
        this.result.setDiscoveredProperties(discoveredProperties);
    }
}

