/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.enums;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.odpi.openmetadata.frameworks.openmetadata.enums.OpenMetadataEnum;
import org.odpi.openmetadata.frameworks.openmetadata.mapper.OpenMetadataValidValues;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum CollectionMemberStatus implements OpenMetadataEnum
{
    UNKNOWN(0, "c278c32d-52c3-44b3-aa3c-5a755a454af9", "Unknown", "The status of the member is not known or not specified. This is the default value.", true),
    DISCOVERED(1, "eca11907-5088-4536-a9ca-d0d4e82b4040", "Discovered", "The member was added by an automated process.", false),
    PROPOSED(2, "24b1c123-21b9-4754-b95b-4641d02672b1", "Proposed", "The member was proposed by a consumer.", false),
    IMPORTED(3, "76410870-bf5c-4594-84ea-c4ce809f8ffd", "Imported", "The member was imported from another system.", false),
    VALIDATED(4, "e6351cfb-d48d-413b-97db-89be80c2fcb2", "Validated", "The member has been validated by a custodian/steward/approver and can be trusted.", false),
    DEPRECATED(5, "9736b9fb-250e-48ed-9b9a-2ed6e0e76743", "Deprecated", "The membership has been deprecated. Consider stopping using it.", false),
    OBSOLETE(6, "1e1a8f3a-2962-4b1d-8cf5-255a4569ea27", "Obsolete", "The membership is obsolete and should not be used.", false),
    OTHER(99, "d1867eca-f908-4c79-b548-cb86482a8e2a", "Other", "The membership has a different status not covered by the open metadata types.", false);

    private static final String ENUM_TYPE_GUID = "a3bdb2ac-c28e-4e5a-8ab7-76aa01038832";
    private static final String ENUM_TYPE_NAME = "MembershipStatus";
    private static final String ENUM_DESCRIPTION = "Defines the provenance and confidence that a member belongs in a collection.";
    private static final String ENUM_DESCRIPTION_GUID = "bd00ab69-de86-4461-8062-6aceabf8ef99";
    private static final String ENUM_DESCRIPTION_WIKI = "https://egeria-project.org/types/0/0021-Collections/";
    private final String descriptionGUID;
    private final int ordinal;
    private final String name;
    private final String description;
    private final boolean isDefault;

    private CollectionMemberStatus(int ordinal, String descriptionGUID, String name, String description, boolean isDefault) {
        this.ordinal = ordinal;
        this.descriptionGUID = descriptionGUID;
        this.name = name;
        this.description = description;
        this.isDefault = isDefault;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDescriptionGUID() {
        return this.descriptionGUID;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    public static String getOpenTypeGUID() {
        return ENUM_TYPE_GUID;
    }

    public static String getOpenTypeName() {
        return ENUM_TYPE_NAME;
    }

    public static String getOpenTypeDescription() {
        return ENUM_DESCRIPTION;
    }

    public static String getOpenTypeDescriptionGUID() {
        return ENUM_DESCRIPTION_GUID;
    }

    public static String getOpenTypeDescriptionWiki() {
        return ENUM_DESCRIPTION_WIKI;
    }

    public String getQualifiedName() {
        return OpenMetadataValidValues.constructValidValueQualifiedName(ENUM_TYPE_NAME, OpenMetadataProperty.MEMBERSHIP_STATUS.name, null, this.name);
    }

    public String getCategory() {
        return OpenMetadataValidValues.constructValidValueCategory(ENUM_TYPE_NAME, OpenMetadataProperty.MEMBERSHIP_STATUS.name, null);
    }

    public String toString() {
        return "CollectionMemberStatus : " + this.name;
    }
}

