/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.enums;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.odpi.openmetadata.frameworks.openmetadata.enums.OpenMetadataEnum;
import org.odpi.openmetadata.frameworks.openmetadata.mapper.OpenMetadataValidValues;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum GlossaryTermRelationshipStatus implements OpenMetadataEnum
{
    DRAFT("f9fc24e1-6e9c-4a18-a6b2-bf527e3b7666", 0, "Draft", "The term relationship is in development.", false),
    ACTIVE("de434072-dd43-4e9f-9859-edcd3c7e1dad", 1, "Active", "The term relationship is approved and in use.", false),
    DEPRECATED("cd7d701d-ecd5-461b-a741-df943c9db876", 2, "Deprecated", "The term relationship should no longer be used.", false),
    OBSOLETE("fbac0d79-e1c0-4e4f-8291-2e2b82aefa40", 3, "Obsolete", "The term relationship must no longer be used.", false),
    OTHER("f4ff2b0b-fe6c-4969-9633-7405fe685158", 99, "Other", "Another term relationship status.", false);

    private static final String ENUM_TYPE_GUID = "42282652-7d60-435e-ad3e-7cfe5291bcc7";
    private static final String ENUM_TYPE_NAME = "TermRelationshipStatus";
    private static final String ENUM_DESCRIPTION = "Defines the confidence in the assigned relationship.";
    private static final String ENUM_DESCRIPTION_GUID = "67bba236-b1c8-4ee4-baf3-33ce99a18373";
    private static final String ENUM_DESCRIPTION_WIKI = "https://egeria-project.org/types/3/0330-Terms/";
    private final String descriptionGUID;
    private final int ordinal;
    private final String name;
    private final String description;
    private final boolean isDefault;

    private GlossaryTermRelationshipStatus(String descriptionGUID, int ordinal, String name, String description, boolean isDefault) {
        this.ordinal = ordinal;
        this.name = name;
        this.descriptionGUID = descriptionGUID;
        this.description = description;
        this.isDefault = isDefault;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDescriptionGUID() {
        return this.descriptionGUID;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    public static String getOpenTypeGUID() {
        return ENUM_TYPE_GUID;
    }

    public static String getOpenTypeName() {
        return ENUM_TYPE_NAME;
    }

    public static String getOpenTypeDescription() {
        return ENUM_DESCRIPTION;
    }

    public static String getOpenTypeDescriptionGUID() {
        return ENUM_DESCRIPTION_GUID;
    }

    public static String getOpenTypeDescriptionWiki() {
        return ENUM_DESCRIPTION_WIKI;
    }

    public String getQualifiedName() {
        return OpenMetadataValidValues.constructValidValueQualifiedName(ENUM_TYPE_NAME, OpenMetadataProperty.TERM_RELATIONSHIP_STATUS.name, null, this.name);
    }

    public String getCategory() {
        return OpenMetadataValidValues.constructValidValueCategory(ENUM_TYPE_NAME, OpenMetadataProperty.TERM_RELATIONSHIP_STATUS.name, null);
    }

    public String toString() {
        return "GlossaryTermRelationshipStatus{name='" + this.name + "}";
    }
}

