/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.enums;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum PortType {
    INPUT_PORT(0, 0, "Input Port", "Data is passed into the process."),
    OUTPUT_PORT(1, 1, "Output Port", "Data is produced by the process."),
    INOUT_PORT(2, 2, "Input-Output Port", "A request response interface is provided by the process."),
    OUTIN_PORT(3, 3, "Output-Input Port", "A request response call is made by the process."),
    OTHER(99, 99, "Other", "None of the above.");

    private static final String ENUM_TYPE_GUID = "b57Fbce7-42ac-71D1-D6a6-9f62Cb7C6dc3";
    private static final String ENUM_TYPE_NAME = "PortType";
    private final int ordinal;
    private final int openTypeOrdinal;
    private final String name;
    private final String description;

    private PortType(int ordinal, int openTypeOrdinal, String name, String description) {
        this.ordinal = ordinal;
        this.openTypeOrdinal = openTypeOrdinal;
        this.name = name;
        this.description = description;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getOpenTypeOrdinal() {
        return this.openTypeOrdinal;
    }

    public String getOpenTypeGUID() {
        return ENUM_TYPE_GUID;
    }

    public String getOpenTypeName() {
        return ENUM_TYPE_NAME;
    }

    public String toString() {
        return "PortType{ordinal=" + this.ordinal + ", openTypeOrdinal=" + this.openTypeOrdinal + ", name='" + this.name + "', description='" + this.description + "', openTypeGUID='" + this.getOpenTypeGUID() + "', openTypeName='" + this.getOpenTypeName() + "'}";
    }
}

