/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.enums;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.odpi.openmetadata.frameworks.openmetadata.enums.OpenMetadataEnum;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum ToDoStatus implements OpenMetadataEnum
{
    OPEN(0, "1bbd26ec-d544-4989-aa9d-ef64651b8de4", "Open", "The to do has been documented but no action taken.", true),
    IN_PROGRESS(1, "99bf6fc9-dd52-4b8b-b971-cba871d5be2b", "In Progress", "The assigned person is working on the action defined in the to do.", false),
    WAITING(2, "4de31b2c-d01a-4109-9c20-e7a7621284b6", "Waiting", "The assigned person is unable to proceed because another action needs to complete first, or a needed resource is unavailable.", false),
    COMPLETE(3, "e8ce8601-4929-460e-9840-0ca74d797074", "Complete", "The requested action is complete.", false),
    ABANDONED(99, "1538ada4-cb2d-4f26-8bbc-bb9887289705", "Abandoned", "The requested action has been abandoned and will never complete.", false);

    private static final String ENUM_TYPE_GUID = "7197ea39-334d-403f-a70b-d40231092df7";
    private static final String ENUM_TYPE_NAME = "ToDoStatus";
    private static final String ENUM_DESCRIPTION = "Progress on completing an action (to do).";
    private static final String ENUM_DESCRIPTION_GUID = "ceaecca1-6489-4ab7-b0d3-cc1c69ccfaa5";
    private static final String ENUM_DESCRIPTION_WIKI = "https://egeria-project.org/types/1/0137-Actions/";
    private final String descriptionGUID;
    private final int ordinal;
    private final String name;
    private final String description;
    private final boolean isDefault;

    private ToDoStatus(int ordinal, String descriptionGUID, String name, String description, boolean isDefault) {
        this.ordinal = ordinal;
        this.name = name;
        this.descriptionGUID = descriptionGUID;
        this.description = description;
        this.isDefault = isDefault;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDescriptionGUID() {
        return this.descriptionGUID;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    public static String getOpenTypeGUID() {
        return ENUM_TYPE_GUID;
    }

    public static String getOpenTypeName() {
        return ENUM_TYPE_NAME;
    }

    public static String getOpenTypeDescription() {
        return ENUM_DESCRIPTION;
    }

    public static String getOpenTypeDescriptionGUID() {
        return ENUM_DESCRIPTION_GUID;
    }

    public static String getOpenTypeDescriptionWiki() {
        return ENUM_DESCRIPTION_WIKI;
    }

    public String toString() {
        return "ToDoStatus : " + this.name;
    }
}

