/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.metadataelements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ContactMethodElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementHeader;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementStub;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.MetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ProfileIdentityElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.actors.ITProfileProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ITProfileElement
implements MetadataElement {
    private ElementHeader elementHeader = null;
    private ITProfileProperties profileProperties = null;
    private List<ContactMethodElement> contactMethods = null;
    private List<ProfileIdentityElement> userIdentities = null;
    private List<ElementStub> linkedInfrastructure = null;

    public ITProfileElement() {
    }

    public ITProfileElement(ITProfileElement template) {
        if (template != null) {
            this.elementHeader = template.getElementHeader();
            this.profileProperties = template.getProfileProperties();
            this.contactMethods = template.getContactMethods();
            this.userIdentities = template.getUserIdentities();
            this.linkedInfrastructure = template.getLinkedInfrastructure();
        }
    }

    @Override
    public ElementHeader getElementHeader() {
        return this.elementHeader;
    }

    @Override
    public void setElementHeader(ElementHeader elementHeader) {
        this.elementHeader = elementHeader;
    }

    public ITProfileProperties getProfileProperties() {
        return this.profileProperties;
    }

    public void setProfileProperties(ITProfileProperties profileProperties) {
        this.profileProperties = profileProperties;
    }

    public List<ContactMethodElement> getContactMethods() {
        return this.contactMethods;
    }

    public void setContactMethods(List<ContactMethodElement> contactMethods) {
        this.contactMethods = contactMethods;
    }

    public List<ProfileIdentityElement> getUserIdentities() {
        return this.userIdentities;
    }

    public void setUserIdentities(List<ProfileIdentityElement> userIdentities) {
        this.userIdentities = userIdentities;
    }

    public List<ElementStub> getLinkedInfrastructure() {
        return this.linkedInfrastructure;
    }

    public void setLinkedInfrastructure(List<ElementStub> linkedInfrastructure) {
        this.linkedInfrastructure = linkedInfrastructure;
    }

    public String toString() {
        return "ITProfileElement{elementHeader=" + this.elementHeader + ", profileProperties=" + this.profileProperties + ", contactMethods=" + this.contactMethods + ", userIdentities=" + this.userIdentities + ", linkedInfrastructure=" + this.linkedInfrastructure + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        ITProfileElement that = (ITProfileElement)objectToCompare;
        return Objects.equals(this.elementHeader, that.elementHeader) && Objects.equals(this.profileProperties, that.profileProperties) && Objects.equals(this.contactMethods, that.contactMethods) && Objects.equals(this.userIdentities, that.userIdentities) && Objects.equals(this.linkedInfrastructure, that.linkedInfrastructure);
    }

    public int hashCode() {
        return Objects.hash(this.elementHeader, this.profileProperties, this.contactMethods, this.userIdentities, this.linkedInfrastructure);
    }
}

