/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.metadataelements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ContactMethodElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementHeader;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.MetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.UserIdentityElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.actors.ActorProfileProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ProfileElement
implements MetadataElement {
    private ElementHeader elementHeader = null;
    private ActorProfileProperties profileProperties = null;
    private List<UserIdentityElement> userIdentities = null;
    private List<ContactMethodElement> contactMethods = null;

    public ProfileElement() {
    }

    public ProfileElement(ProfileElement template) {
        if (template != null) {
            this.elementHeader = template.getElementHeader();
            this.profileProperties = template.getProfileProperties();
            this.userIdentities = template.getUserIdentities();
            this.contactMethods = template.getContactMethods();
        }
    }

    @Override
    public ElementHeader getElementHeader() {
        return this.elementHeader;
    }

    @Override
    public void setElementHeader(ElementHeader elementHeader) {
        this.elementHeader = elementHeader;
    }

    public ActorProfileProperties getProfileProperties() {
        return this.profileProperties;
    }

    public void setProfileProperties(ActorProfileProperties profileProperties) {
        this.profileProperties = profileProperties;
    }

    public List<UserIdentityElement> getUserIdentities() {
        if (this.userIdentities == null) {
            return null;
        }
        if (this.userIdentities.isEmpty()) {
            return null;
        }
        return this.userIdentities;
    }

    public void setUserIdentities(List<UserIdentityElement> userIdentities) {
        this.userIdentities = userIdentities;
    }

    public List<ContactMethodElement> getContactMethods() {
        if (this.contactMethods == null) {
            return null;
        }
        if (this.contactMethods.isEmpty()) {
            return null;
        }
        return this.contactMethods;
    }

    public void setContactMethods(List<ContactMethodElement> contactMethods) {
        this.contactMethods = contactMethods;
    }

    public String toString() {
        return "ProfileElement{elementHeader=" + this.elementHeader + ", profileProperties=" + this.profileProperties + ", userIdentities=" + this.userIdentities + ", contactMethods=" + this.contactMethods + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        ProfileElement that = (ProfileElement)objectToCompare;
        return Objects.equals(this.elementHeader, that.elementHeader) && Objects.equals(this.profileProperties, that.profileProperties) && Objects.equals(this.userIdentities, that.userIdentities) && Objects.equals(this.contactMethods, that.contactMethods);
    }

    public int hashCode() {
        return Objects.hash(this.elementHeader, this.profileProperties, this.userIdentities, this.contactMethods);
    }
}

