/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.refdata;

import java.util.List;
import org.odpi.openmetadata.frameworks.openmetadata.mapper.OpenMetadataValidValues;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.ResourceUseProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;

public enum ResourceUse {
    SURVEY_RESOURCE("Survey Resource", "Create a survey report that details the content of the real-world resource that is attached to an asset.", null),
    VALIDATE_RESOURCE("Validate Resource", "Creates a certification relationship between a certification type and a resource (asset, person, project, ...) that has passed the appropriate quality checks.", null),
    CERTIFY_RESOURCE("Certify Resource", "Creates a certification relationship between a certification type and a resource (asset, person, project, ...) that has passed the appropriate quality checks.", null),
    CATALOG_RESOURCE("Catalog Resource", "Extract metadata from the real-world resource and add it to the open metadata repositories.  Ongoing monitoring means that any changes to the resource are reflected in the open metadata repositories.", null),
    PROVISION_RESOURCE("Provision Resource", "Make a change to the real-world resource such as add or copy data.", null),
    IMPROVE_METADATA("Improve Metadata Element", "Improve the information about an element in the open metadata repositories.", null),
    INFORM_STEWARD("Inform Steward", "Send notification to a steward.", null),
    CHOOSE_PATH("Choose Path", "Choose the appropriate path to take.", null),
    WATCH_DOG("Watch Metadata Element", "Monitor for changes to a metadata element and its related elements and take action if required.", null),
    SUPPORTING_PEOPLE("Supporting Team", "A team assigned to support the work associated with the element.", null),
    SUPPORTING_PERSON("Supporting Person", "A person assigned to support the work associated with the element.", null),
    SUPPORTING_TEMPLATE("Supporting Template", "A template that can be used in conjunction with a governance action or connector.", null),
    SUPPORTING_PROCESS("Supporting Process", "A process that automates some of the work associated with the element.", null),
    HOSTED_SERVICE("Hosted Service", "A type of service that can be hosted on this type of server.", null),
    HOSTED_CONNECTOR("Hosted Connector", "A type of connector that can be hosted by this type of service/engine.", null),
    HOSTED_GOVERNANCE_ENGINE("Hosted Governance Engine", "A type of governance engine that can be hosted by this type of service.", null),
    CALLED_SERVICE("Called Service", "A type of service that may be called by this service.", null),
    CONFIGURE_CONNECTOR("Configure Connector", "A connector type that can be used in a connection used to create a connector instance.", null),
    ACTIVITY_FOLDER("Activity Folder", "A collection of guided activities either suggested, or taken, to complete a project.", new ResourceUseProperties[]{ResourceUseProperties.PARENT_RELATIONSHIP_TYPE_NAME}),
    MEMBER_TEMPLATE("Member Template", "A template to create a member of the linked collection.", new ResourceUseProperties[]{ResourceUseProperties.PARENT_RELATIONSHIP_TYPE_NAME}),
    DERIVED_ELEMENT_TEMPLATE("Derived Element Template", "A template to create an element from the values in the linked element.  The placeholder properties match the attribute names of the linked element.", new ResourceUseProperties[]{ResourceUseProperties.PARENT_RELATIONSHIP_TYPE_NAME});

    private final String resourceUse;
    private final String description;
    private final ResourceUseProperties[] resourceUseProperties;

    private ResourceUse(String resourceUse, String description, ResourceUseProperties[] resourceUseProperties) {
        this.resourceUse = resourceUse;
        this.description = description;
        this.resourceUseProperties = resourceUseProperties;
    }

    public String getResourceUse() {
        return this.resourceUse;
    }

    public String getDescription() {
        return this.description;
    }

    public String getQualifiedName() {
        return OpenMetadataValidValues.constructValidValueQualifiedName(null, OpenMetadataProperty.RESOURCE_USE.name, null, this.resourceUse);
    }

    public String getCategory() {
        return OpenMetadataValidValues.constructValidValueCategory(null, OpenMetadataProperty.RESOURCE_USE.name, null);
    }

    public List<ResourceUseProperties> getResourceUseProperties() {
        if (this.resourceUseProperties != null) {
            return List.of(this.resourceUseProperties);
        }
        return null;
    }

    public String toString() {
        return "ResourceUse{" + this.resourceUse + "}";
    }
}

