/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.refdata;

import org.odpi.openmetadata.frameworks.openmetadata.mapper.OpenMetadataValidValues;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;

public enum ResourceUseProperties {
    PARENT_RELATIONSHIP_TYPE_NAME("parentRelationshipTypeName", "The open metadata type name of a relationship to connect the linked element with a new element generated from the linked to template.");

    private final String name;
    private final String description;

    private ResourceUseProperties(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getQualifiedName() {
        return OpenMetadataValidValues.constructValidValueQualifiedName(null, OpenMetadataProperty.RESOURCE_USE_PROPERTIES.name, null, this.name);
    }

    public String getCategory() {
        return OpenMetadataValidValues.constructValidValueCategory(null, OpenMetadataProperty.RESOURCE_USE_PROPERTIES.name, null);
    }

    public String toString() {
        return "ResourceUseProperties{" + this.name + "}";
    }
}

