/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.enums;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.odpi.openmetadata.frameworks.openmetadata.enums.OpenMetadataEnum;
import org.odpi.openmetadata.frameworks.openmetadata.mapper.OpenMetadataValidValues;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum ConfidentialityLevel implements OpenMetadataEnum
{
    UNCLASSIFIED("472d15fa-5713-40dd-892b-9bf91313957e", 0, "Unclassified", "The data is public information.", false),
    INTERNAL("e7813b82-8447-43ce-8a67-c941c265257f", 1, "Internal", "The data should not be exposed outside of this organization.", false),
    CONFIDENTIAL("b326cfae-1579-4669-b614-e33e5a7e3b18", 2, "Confidential", "The data should be protected and only shared with people with a need to see it.", false),
    SENSITIVE("18011377-8dd0-4211-abdf-039da2415f1c", 3, "Sensitive", "The data is sensitive and inappropriate use may adversely impact the data subject.", false),
    RESTRICTED("b0d939c5-6c06-4bb3-ade3-cc5957182ff4", 4, "Restricted", "The data is very valuable and must be restricted to a very small number of people.", false),
    OTHER("3f052d7e-de9d-4b94-a7d4-01ae0242fab6", 99, "Other", "Another confidentially level.", false);

    private static final String ENUM_TYPE_GUID = "0efe1125-a8c7-452a-a635-47c4466b0cc2";
    private static final String ENUM_TYPE_NAME = "ConfidentialityLevel";
    private static final String ENUM_DESCRIPTION = "Defines how confidential the data associated with this element is.";
    private static final String ENUM_DESCRIPTION_GUID = "98e92fcb-175c-485b-97f6-75dcd777078b";
    private static final String ENUM_DESCRIPTION_WIKI = "https://egeria-project.org/types/4/0421-Governance-Classification-Levels/";
    private final String descriptionGUID;
    private final int ordinal;
    private final String name;
    private final String description;
    private final boolean isDefault;

    private ConfidentialityLevel(String descriptionGUID, int ordinal, String name, String description, boolean isDefault) {
        this.ordinal = ordinal;
        this.name = name;
        this.descriptionGUID = descriptionGUID;
        this.description = description;
        this.isDefault = isDefault;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDescriptionGUID() {
        return this.descriptionGUID;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    public static String getOpenTypeGUID() {
        return ENUM_TYPE_GUID;
    }

    public static String getOpenTypeName() {
        return ENUM_TYPE_NAME;
    }

    public static String getOpenTypeDescription() {
        return ENUM_DESCRIPTION;
    }

    public static String getOpenTypeDescriptionGUID() {
        return ENUM_DESCRIPTION_GUID;
    }

    public static String getOpenTypeDescriptionWiki() {
        return ENUM_DESCRIPTION_WIKI;
    }

    public String getQualifiedName() {
        return OpenMetadataValidValues.constructValidValueQualifiedName(ENUM_TYPE_NAME, OpenMetadataProperty.CONFIDENTIALITY_LEVEL_IDENTIFIER.name, null, this.name);
    }

    public String getCategory() {
        return OpenMetadataValidValues.constructValidValueCategory(ENUM_TYPE_NAME, OpenMetadataProperty.CONFIDENTIALITY_LEVEL_IDENTIFIER.name, null);
    }

    public String toString() {
        return "ConfidentialityLevel{" + this.name + "}";
    }
}

