/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.enums;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.odpi.openmetadata.frameworks.openmetadata.enums.OpenMetadataEnum;
import org.odpi.openmetadata.frameworks.openmetadata.mapper.OpenMetadataValidValues;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum GovernanceDomain implements OpenMetadataEnum
{
    UNCLASSIFIED(0, "8aace3ca-1db4-4927-ad45-9766770a92c4", "Unclassified", "The governance domain is not specified.", true),
    DATA(1, "9c465654-ad9d-4c84-bbcb-b65eaf6b9c27", "Data", "The data (information) governance domain.", false),
    PRIVACY(2, "dc502370-2bcf-470c-b8d3-d523f7b4bbc1", "Privacy", "The data privacy governance domain.", false),
    SECURITY(3, "27c1fa77-9ee7-4611-8bb5-b1aa7f0a03bd", "Security", "The security governance domain.", false),
    IT_INFRASTRUCTURE(4, "032ccb98-88af-4b60-87c2-46c95cc3ab71", "IT Infrastructure", "The IT infrastructure management governance domain.", false),
    SOFTWARE_DEVELOPMENT(5, "463fec3c-95c7-47ba-bb50-c89ea52023cc", "Software Development", "The software development lifecycle (SDLC) governance domain.", false),
    CORPORATE(6, "7d5a47a6-008c-409d-bcc9-de55d39ea778", "Corporate", "The corporate governance domain.", false),
    ASSET_MANAGEMENT(7, "831e21d5-8e7c-448d-aa38-f977437f2a9e", "Asset Management", "The physical asset management governance domain.", false),
    OTHER(99, "c34e17d6-b924-4a7d-a5fd-13425a1de422", "Other", "The governance domain is locally defined.", false);

    private static final String ENUM_TYPE_GUID = "baa31998-f3cb-47b0-9123-674a701e87bc";
    private static final String ENUM_TYPE_NAME = "GovernanceDomain";
    private static final String ENUM_DESCRIPTION = "Defines the governance domains that open metadata seeks to unite.";
    private static final String ENUM_DESCRIPTION_GUID = "e07492d8-b4d9-4a52-900c-2641ffa36d64";
    private static final String ENUM_DESCRIPTION_WIKI = "https://egeria-project.org/types/4/0401-Governance-Definitions/";
    private final String descriptionGUID;
    private final int ordinal;
    private final String name;
    private final String description;
    private final boolean isDefault;

    private GovernanceDomain(int ordinal, String descriptionGUID, String name, String description, boolean isDefault) {
        this.ordinal = ordinal;
        this.name = name;
        this.descriptionGUID = descriptionGUID;
        this.description = description;
        this.isDefault = isDefault;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDescriptionGUID() {
        return this.descriptionGUID;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    public static String getOpenTypeGUID() {
        return ENUM_TYPE_GUID;
    }

    public static String getOpenTypeName() {
        return ENUM_TYPE_NAME;
    }

    public static String getOpenTypeDescription() {
        return ENUM_DESCRIPTION;
    }

    public static String getOpenTypeDescriptionGUID() {
        return ENUM_DESCRIPTION_GUID;
    }

    public static String getOpenTypeDescriptionWiki() {
        return ENUM_DESCRIPTION_WIKI;
    }

    public String getQualifiedName() {
        return OpenMetadataValidValues.constructValidValueQualifiedName(ENUM_TYPE_NAME, OpenMetadataProperty.SORT_ORDER.name, null, this.name);
    }

    public String getCategory() {
        return OpenMetadataValidValues.constructValidValueCategory(ENUM_TYPE_NAME, OpenMetadataProperty.SORT_ORDER.name, null);
    }

    public String toString() {
        return "GovernanceDomain : " + this.name;
    }
}

