/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.enums;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.odpi.openmetadata.frameworks.openmetadata.enums.OpenMetadataEnum;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum MediaType implements OpenMetadataEnum
{
    IMAGE("9f7d9fff-1b66-4461-b9c1-32b84ab6f8b70", 0, "Image", "The media is an image."),
    AUDIO("53dad430-81c0-422e-a265-8ef49748ab1a", 1, "Audio", "The media is an audio recording."),
    DOCUMENT("9e1447cd-a053-4c55-9a99-b6771697fcfb", 2, "Document", "The media is a text document - probably rich text."),
    VIDEO("3e351708-b5ae-46c9-890e-83892cd96bb6", 3, "Video", "The media is a video recording."),
    OTHER("340ffbeb-3076-4038-ae07-417b685c4825", 99, "Other", "The media type is not supported.");

    private static final String ENUM_TYPE_GUID = "9548390c-69f5-4dc6-950d-6fdffb257b56";
    private static final String ENUM_TYPE_NAME = "MediaType";
    private static final String ENUM_DESCRIPTION = "Defines the type of media.";
    private static final String ENUM_DESCRIPTION_GUID = "7d2d2830-d95b-4d9e-8f46-26f5eace592b";
    private static final String ENUM_DESCRIPTION_WIKI = "https://egeria-project.org/types/0/0015-Linked-Media-Types/";
    private final String descriptionGUID;
    private final int ordinal;
    private final String name;
    private final String description;

    private MediaType(String descriptionGUID, int ordinal, String name, String description) {
        this.ordinal = ordinal;
        this.name = name;
        this.descriptionGUID = descriptionGUID;
        this.description = description;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDescriptionGUID() {
        return this.descriptionGUID;
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    public static String getOpenTypeGUID() {
        return ENUM_TYPE_GUID;
    }

    public static String getOpenTypeName() {
        return ENUM_TYPE_NAME;
    }

    public static String getOpenTypeDescriptionGUID() {
        return ENUM_DESCRIPTION_GUID;
    }

    public static String getOpenTypeDescriptionWiki() {
        return ENUM_DESCRIPTION_WIKI;
    }

    public static String getOpenTypeDescription() {
        return ENUM_DESCRIPTION;
    }

    public String toString() {
        return "MediaType{mediaTypeName='" + this.name + "'}";
    }
}

