/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.properties.assets.infrastructure;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.AssetProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.infrastructure.ITInfrastructureProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class SoftwareServerPlatformProperties
extends ITInfrastructureProperties {
    private static final String versionProperty = OpenMetadataProperty.PLATFORM_VERSION.name;
    private static final String sourceProperty = OpenMetadataProperty.SOURCE.name;
    private static final String userIdProperty = OpenMetadataProperty.USER_ID.name;
    private String platformVersion = null;
    private String platformSource = null;
    private String platformUserId = null;

    public SoftwareServerPlatformProperties() {
    }

    public SoftwareServerPlatformProperties(SoftwareServerPlatformProperties template) {
        super(template);
        if (template != null) {
            this.platformVersion = template.getSoftwareServerPlatformVersion();
            this.platformSource = template.getSoftwareServerPlatformSource();
            this.platformUserId = template.getSoftwareServerPlatformUserId();
        }
    }

    public SoftwareServerPlatformProperties(AssetProperties template) {
        super(template);
        Map<String, Object> assetExtendedProperties;
        if (template != null && (assetExtendedProperties = template.getExtendedProperties()) != null) {
            if (assetExtendedProperties.get(versionProperty) != null) {
                this.platformVersion = assetExtendedProperties.get(versionProperty).toString();
                assetExtendedProperties.remove(versionProperty);
            }
            if (assetExtendedProperties.get(sourceProperty) != null) {
                this.platformSource = assetExtendedProperties.get(sourceProperty).toString();
                assetExtendedProperties.remove(sourceProperty);
            }
            if (assetExtendedProperties.get(userIdProperty) != null) {
                this.platformUserId = assetExtendedProperties.get(userIdProperty).toString();
                assetExtendedProperties.remove(userIdProperty);
            }
            super.setExtendedProperties(assetExtendedProperties);
        }
    }

    public AssetProperties cloneToAsset() {
        return this.cloneToAsset(OpenMetadataType.SOFTWARE_SERVER_PLATFORM.typeName);
    }

    @Override
    public AssetProperties cloneToAsset(String subTypeName) {
        AssetProperties assetProperties = super.cloneToAsset(subTypeName);
        Map<String, Object> assetExtendedProperties = assetProperties.getExtendedProperties();
        if (assetExtendedProperties == null) {
            assetExtendedProperties = new HashMap<String, Object>();
        }
        if (this.platformVersion != null) {
            assetExtendedProperties.put(versionProperty, this.platformVersion);
        }
        if (this.platformSource != null) {
            assetExtendedProperties.put(sourceProperty, this.platformSource);
        }
        if (this.platformUserId != null) {
            assetExtendedProperties.put(userIdProperty, this.platformUserId);
        }
        if (!assetExtendedProperties.isEmpty()) {
            assetProperties.setExtendedProperties(assetExtendedProperties);
        }
        return assetProperties;
    }

    public String getSoftwareServerPlatformVersion() {
        return this.platformVersion;
    }

    public void setSoftwareServerPlatformVersion(String platformVersion) {
        this.platformVersion = platformVersion;
    }

    public String getSoftwareServerPlatformSource() {
        return this.platformSource;
    }

    public void setSoftwareServerPlatformSource(String platformSource) {
        this.platformSource = platformSource;
    }

    public String getSoftwareServerPlatformUserId() {
        return this.platformUserId;
    }

    public void setSoftwareServerPlatformUserId(String platformUserId) {
        this.platformUserId = platformUserId;
    }

    @Override
    public String toString() {
        return "SoftwareServerPlatformProperties{platformVersion='" + this.platformVersion + "', platformSource='" + this.platformSource + "', platformUserId='" + this.platformUserId + "'} " + super.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        SoftwareServerPlatformProperties that = (SoftwareServerPlatformProperties)objectToCompare;
        return Objects.equals(this.platformVersion, that.platformVersion) && Objects.equals(this.platformSource, that.platformSource) && Objects.equals(this.platformUserId, that.platformUserId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.platformVersion, this.platformSource, this.platformUserId);
    }
}

