/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.properties.softwarecapabilities;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.enums.OperationalStatus;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelationshipProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class CapabilityDeploymentProperties
extends RelationshipProperties {
    private static final String deploymentTimeProperty = "deploymentTime";
    private static final String deployerProperty = "deployer";
    private static final String deployerTypeNameProperty = "deployerTypeName";
    private static final String deployerPropertyNameProperty = "deployerPropertyName";
    private static final String deploymentStatusProperty = "serverCapabilityStatus";
    private Date deploymentTime = null;
    private String deployer = null;
    private String deployerTypeName = null;
    private String deployerPropertyName = null;
    private OperationalStatus softwareCapabilityStatus = null;

    public CapabilityDeploymentProperties() {
    }

    public CapabilityDeploymentProperties(CapabilityDeploymentProperties template) {
        super(template);
        if (template != null) {
            this.deploymentTime = template.getDeploymentTime();
            this.deployer = template.getDeployer();
            this.deployerTypeName = template.getDeployerTypeName();
            this.deployerPropertyName = template.getDeployerPropertyName();
            this.softwareCapabilityStatus = template.getSoftwareCapabilityStatus();
        }
    }

    public Map<String, Object> cloneToMap() {
        HashMap<String, Object> propertyMap = new HashMap<String, Object>();
        if (this.deploymentTime != null) {
            propertyMap.put(deploymentTimeProperty, this.deploymentTime);
        }
        if (this.deployer != null) {
            propertyMap.put(deployerProperty, this.deployer);
        }
        if (this.deployerTypeName != null) {
            propertyMap.put(deployerTypeNameProperty, this.deployerTypeName);
        }
        if (this.deployerPropertyName != null) {
            propertyMap.put(deployerPropertyNameProperty, this.deployerPropertyName);
        }
        if (this.softwareCapabilityStatus != null) {
            propertyMap.put(deploymentStatusProperty, this.softwareCapabilityStatus.getOrdinal());
        }
        if (!propertyMap.isEmpty()) {
            propertyMap = null;
        }
        return propertyMap;
    }

    public Date getDeploymentTime() {
        return this.deploymentTime;
    }

    public void setDeploymentTime(Date deploymentTime) {
        this.deploymentTime = deploymentTime;
    }

    public String getDeployer() {
        return this.deployer;
    }

    public void setDeployer(String deployer) {
        this.deployer = deployer;
    }

    public String getDeployerTypeName() {
        return this.deployerTypeName;
    }

    public void setDeployerTypeName(String deployerTypeName) {
        this.deployerTypeName = deployerTypeName;
    }

    public String getDeployerPropertyName() {
        return this.deployerPropertyName;
    }

    public void setDeployerPropertyName(String deployerPropertyName) {
        this.deployerPropertyName = deployerPropertyName;
    }

    public OperationalStatus getSoftwareCapabilityStatus() {
        return this.softwareCapabilityStatus;
    }

    public void setSoftwareCapabilityStatus(OperationalStatus softwareCapabilityStatus) {
        this.softwareCapabilityStatus = softwareCapabilityStatus;
    }

    @Override
    public String toString() {
        return "CapabilityDeploymentProperties{deploymentTime=" + this.deploymentTime + ", deployer='" + this.deployer + "', deployerTypeName='" + this.deployerTypeName + "', deployerPropertyName='" + this.deployerPropertyName + "', softwareCapabilityStatus=" + this.softwareCapabilityStatus + ", effectiveFrom=" + this.getEffectiveFrom() + ", effectiveTo=" + this.getEffectiveTo() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        CapabilityDeploymentProperties that = (CapabilityDeploymentProperties)objectToCompare;
        return Objects.equals(this.deploymentTime, that.deploymentTime) && Objects.equals(this.deployer, that.deployer) && Objects.equals(this.deployerTypeName, that.deployerTypeName) && Objects.equals(this.deployerPropertyName, that.deployerPropertyName) && this.softwareCapabilityStatus == that.softwareCapabilityStatus;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.deploymentTime, this.deployer, this.deployerTypeName, this.deployerPropertyName, this.softwareCapabilityStatus);
    }
}

