/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.refdata;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.odpi.openmetadata.frameworks.openmetadata.mapper.OpenMetadataValidValues;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum AssociationType {
    CONTAINMENT(0, "404f75cf-0c0f-4ed2-85cd-6bc7c29efd5a", "containment", "The end2 element is a part of the end1 element.", false),
    AGGREGATION(1, "be9ba3d7-b058-42b7-876f-65d90a19b1ba", "aggregation", "The end1 element holds a link to the end2 element.", false),
    INHERITANCE(2, "c80d0e84-6443-4430-9b44-512518606a86", "inheritance", "The end1 element is a subtype of the end2 element.", false),
    DEPENDENCY(3, "6b8244e4-ddf8-45a6-a3c8-08d4ed4cdac1", "dependency", "The end1 element is dependent on the end2 element.", false),
    USES(4, "1cc2fd5f-a882-44dc-8ee8-0dec5721bfce", "uses", "The end1 element uses the end2 element.", false);

    private final String descriptionGUID;
    private final int ordinal;
    private final String name;
    private final String description;
    private final boolean isDefault;

    private AssociationType(int ordinal, String descriptionGUID, String name, String description, boolean isDefault) {
        this.ordinal = ordinal;
        this.name = name;
        this.descriptionGUID = descriptionGUID;
        this.description = description;
        this.isDefault = isDefault;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDescriptionGUID() {
        return this.descriptionGUID;
    }

    public String getQualifiedName() {
        return OpenMetadataValidValues.constructValidValueQualifiedName(null, OpenMetadataProperty.ASSOCIATION_TYPE.name, null, this.name);
    }

    public String getCategory() {
        return OpenMetadataValidValues.constructValidValueCategory(null, OpenMetadataProperty.ASSOCIATION_TYPE.name, null);
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public String toString() {
        return "AssociationType : " + this.name;
    }
}

