/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.refdata;

import org.odpi.openmetadata.frameworks.openmetadata.mapper.OpenMetadataValidValues;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;

public enum CollectionType {
    GOVERNANCE_DOMAIN_SET("Governance Domain Set", "List of governance domain identifiers."),
    DATA_JOURNEY("Data Journey", "A set of guided tasks to enable a new data-oriented use case."),
    ACTIVITY_FOLDER("Activity Folder", "A collection of guided activities either suggested, or taken, to complete a project."),
    DATA_SPEC("Data Spec", "A collection of data field descriptions that characterize a data asset needed by the project."),
    DIGITAL_PRODUCT_CONTENT("Digital Product Content", "The assets and related material that make up a digital product offering."),
    DIGITAL_PRODUCT_MARKETPLACE("Digital Product Marketplace", "The root of a folder hierarchy that organizes a product catalog."),
    DIGITAL_PRODUCT_CATEGORY("Digital Product Category", "A folder in the digital product catalog used to group similar products together."),
    ASSET_CATALOG_ROOT("Asset Catalog Root", "The root of a folder hierarchy that organizes an asset catalog."),
    ASSET_CATALOG_CATEGORY("Asset Catalog Category", "A folder in the asset catalog used to group similar assets together.");

    private final String name;
    private final String description;

    private CollectionType(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getQualifiedName() {
        return OpenMetadataValidValues.constructValidValueQualifiedName(null, OpenMetadataProperty.COLLECTION_TYPE.name, null, this.name);
    }

    public String getCategory() {
        return OpenMetadataValidValues.constructValidValueCategory(null, OpenMetadataProperty.COLLECTION_TYPE.name, null);
    }

    public String toString() {
        return "CollectionType{" + this.name + "}";
    }
}

