/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.metadatasecurity.samples;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.OpenMetadataAssetSecurity;
import org.odpi.openmetadata.metadatasecurity.OpenMetadataConnectionSecurity;
import org.odpi.openmetadata.metadatasecurity.OpenMetadataServerSecurity;
import org.odpi.openmetadata.metadatasecurity.OpenMetadataServiceSecurity;
import org.odpi.openmetadata.metadatasecurity.connectors.OpenMetadataServerSecurityConnector;
import org.odpi.openmetadata.metadatasecurity.properties.Asset;
import org.odpi.openmetadata.metadatasecurity.properties.AssetAuditHeader;
import org.odpi.openmetadata.metadatasecurity.properties.Connection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OpenMetadataRepositorySecurity;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;

public class CocoPharmaServerSecurityConnector
extends OpenMetadataServerSecurityConnector
implements OpenMetadataRepositorySecurity,
OpenMetadataServerSecurity,
OpenMetadataServiceSecurity,
OpenMetadataConnectionSecurity,
OpenMetadataAssetSecurity {
    private List<String> allUsers = new ArrayList<String>();
    private List<String> assetOnboardingExit = new ArrayList<String>();
    private List<String> serverAdmins = new ArrayList<String>();
    private List<String> serverOperators = new ArrayList<String>();
    private List<String> serverInvestigators = new ArrayList<String>();
    private List<String> metadataArchitects = new ArrayList<String>();
    private List<String> npaAccounts = new ArrayList<String>();
    private List<String> externalUsers = new ArrayList<String>();
    private List<String> defaultZoneMembership = new ArrayList<String>();
    private List<String> zonesForExternals = new ArrayList<String>();
    private Map<String, List<String>> zoneAccess = new HashMap<String, List<String>>();
    private Map<String, String> ownerZones = new HashMap<String, String>();
    private final String personalFilesZoneName = "personal-files";
    private final String quarantineZoneName = "quarantine";
    private final String dataLakeZoneName = "data-lake";
    private final String externalAccessZoneName = "external-access";

    public CocoPharmaServerSecurityConnector() {
        ArrayList<String> allEmployees = new ArrayList<String>();
        ArrayList<String> assetOnboarding = new ArrayList<String>();
        String researchZoneName = "research";
        String hrZoneName = "human-resources";
        String financeZoneName = "finance";
        String clinicalTrialsZoneName = "clinical-trials";
        String infrastructureZoneName = "infrastructure";
        String developmentZoneName = "development";
        String manufacturingZoneName = "manufacturing";
        String governanceZoneName = "governance";
        String trashCanZoneName = "trash-can";
        String zachNowUserId = "zach";
        String steveStarterUserId = "steves";
        String terriDaringUserId = "terri";
        String tanyaTidieUserId = "tanyatidie";
        String pollyTaskerUserId = "pollytasker";
        String tessaTubeUserId = "tessatube";
        String callieQuartileUserId = "calliequartile";
        String ivorPadlockUserId = "ivorpadlock";
        String bobNitterUserId = "bobnitter";
        String faithBrokerUserId = "faithbroker";
        String sallyCounterUserId = "sallycounter";
        String lemmieStageUserId = "lemmiestage";
        String erinOverviewUserId = "erinoverview";
        String harryHopefulUserId = "harryhopeful";
        String garyGeekeUserId = "garygeeke";
        String grantAbleUserId = "grantable";
        String robbieRecordsUserId = "robbierecords";
        String reggieMintUserId = "reggiemint";
        String peterProfileUserId = "peterprofile";
        String nancyNoahUserId = "nancynoah";
        String sidneySeekerUserId = "sidneyseeker";
        String tomTallyUserId = "tomtally";
        String julieStitchedUserId = "juliestitched";
        String desSignaUserId = "dessigna";
        String angelaCummingUserId = "angelacummings";
        String julesKeeperUserId = "jukeskeeper";
        String stewFasterUserId = "stewFaster";
        String cocoMDS1UserId = "cocoMDS1npa";
        String cocoMDS2UserId = "cocoMDS2npa";
        String cocoMDS3UserId = "cocoMDS3npa";
        String cocoMDS4UserId = "cocoMDS4npa";
        String cocoMDS5UserId = "cocoMDS5npa";
        String cocoMDS6UserId = "cocoMDS6npa";
        String cocoMDSxUserId = "cocoMDSxnpa";
        String archiverUserId = "archiver01";
        String etlEngineUserId = "dlETL";
        String governDL01UserId = "governDL01npa";
        String exchangeDL01UserId = "exchangeDL01npa";
        String findItDL01UserId = "findItDL01npa";
        String fixItDL01UserId = "fixItDL01npa";
        String onboardDL01UserId = "onboardDL01npa";
        String monitorDL01UserId = "monitorDL01npa";
        String cocoEngineUserId = "cocoETLnpa";
        String generalNPAUserId = "generalnpa";
        String serverStartUpUserId = "autoStart01npa";
        this.defaultZoneMembership.add("quarantine");
        this.allUsers.add("zach");
        this.allUsers.add("steves");
        this.allUsers.add("terri");
        this.allUsers.add("tanyatidie");
        this.allUsers.add("pollytasker");
        this.allUsers.add("tessatube");
        this.allUsers.add("calliequartile");
        this.allUsers.add("ivorpadlock");
        this.allUsers.add("bobnitter");
        this.allUsers.add("faithbroker");
        this.allUsers.add("sallycounter");
        this.allUsers.add("lemmiestage");
        this.allUsers.add("erinoverview");
        this.allUsers.add("harryhopeful");
        this.allUsers.add("garygeeke");
        this.allUsers.add("grantable");
        this.allUsers.add("robbierecords");
        this.allUsers.add("reggiemint");
        this.allUsers.add("peterprofile");
        this.allUsers.add("nancynoah");
        this.allUsers.add("sidneyseeker");
        this.allUsers.add("tomtally");
        this.allUsers.add("juliestitched");
        this.allUsers.add("dessigna");
        this.allUsers.add("angelacummings");
        this.allUsers.add("jukeskeeper");
        this.allUsers.add("stewFaster");
        this.allUsers.add("archiver01");
        this.allUsers.add("dlETL");
        this.allUsers.add("cocoMDS1npa");
        this.allUsers.add("cocoMDS2npa");
        this.allUsers.add("cocoMDS3npa");
        this.allUsers.add("cocoMDS4npa");
        this.allUsers.add("cocoMDS5npa");
        this.allUsers.add("cocoMDS6npa");
        this.allUsers.add("cocoMDSxnpa");
        this.allUsers.add("governDL01npa");
        this.allUsers.add("exchangeDL01npa");
        this.allUsers.add("findItDL01npa");
        this.allUsers.add("fixItDL01npa");
        this.allUsers.add("onboardDL01npa");
        this.allUsers.add("monitorDL01npa");
        this.allUsers.add("cocoETLnpa");
        this.allUsers.add("generalnpa");
        this.allUsers.add("autoStart01npa");
        allEmployees.add("zach");
        allEmployees.add("steves");
        allEmployees.add("terri");
        allEmployees.add("tanyatidie");
        allEmployees.add("pollytasker");
        allEmployees.add("tessatube");
        allEmployees.add("calliequartile");
        allEmployees.add("ivorpadlock");
        allEmployees.add("bobnitter");
        allEmployees.add("faithbroker");
        allEmployees.add("sallycounter");
        allEmployees.add("lemmiestage");
        allEmployees.add("erinoverview");
        allEmployees.add("harryhopeful");
        allEmployees.add("garygeeke");
        allEmployees.add("reggiemint");
        allEmployees.add("peterprofile");
        allEmployees.add("sidneyseeker");
        allEmployees.add("tomtally");
        allEmployees.add("jukeskeeper");
        allEmployees.add("stewFaster");
        assetOnboarding.add("peterprofile");
        assetOnboarding.add("erinoverview");
        assetOnboarding.add("findItDL01npa");
        assetOnboarding.add("fixItDL01npa");
        this.assetOnboardingExit.add("erinoverview");
        this.serverAdmins.add("garygeeke");
        this.serverOperators.add("garygeeke");
        this.serverOperators.add("autoStart01npa");
        this.serverInvestigators.add("garygeeke");
        this.metadataArchitects.add("erinoverview");
        this.metadataArchitects.add("peterprofile");
        this.externalUsers.add("grantable");
        this.externalUsers.add("juliestitched");
        this.externalUsers.add("angelacummings");
        this.externalUsers.add("robbierecords");
        this.zonesForExternals.add("external-access");
        this.npaAccounts.add("archiver01");
        this.npaAccounts.add("dlETL");
        this.npaAccounts.add("cocoMDS1npa");
        this.npaAccounts.add("cocoMDS2npa");
        this.npaAccounts.add("cocoMDS3npa");
        this.npaAccounts.add("cocoMDS4npa");
        this.npaAccounts.add("cocoMDS5npa");
        this.npaAccounts.add("cocoMDS6npa");
        this.npaAccounts.add("cocoMDSxnpa");
        this.npaAccounts.add("findItDL01npa");
        this.npaAccounts.add("fixItDL01npa");
        this.npaAccounts.add("governDL01npa");
        this.npaAccounts.add("exchangeDL01npa");
        this.npaAccounts.add("onboardDL01npa");
        this.npaAccounts.add("monitorDL01npa");
        this.npaAccounts.add("cocoETLnpa");
        this.npaAccounts.add("generalnpa");
        this.npaAccounts.add("autoStart01npa");
        assetOnboarding.addAll(this.npaAccounts);
        ArrayList<String> zoneSetUp = new ArrayList<String>();
        this.ownerZones.put("tanyatidie", "clinical-trials");
        this.zoneAccess.put("trash-can", this.npaAccounts);
        this.zoneAccess.put("personal-files", allEmployees);
        this.zoneAccess.put("quarantine", assetOnboarding);
        this.zoneAccess.put("data-lake", this.allUsers);
        this.zoneAccess.put("external-access", this.externalUsers);
        zoneSetUp.add("calliequartile");
        zoneSetUp.add("tessatube");
        this.zoneAccess.put("research", zoneSetUp);
        zoneSetUp.add("tanyatidie");
        this.zoneAccess.put("clinical-trials", zoneSetUp);
        zoneSetUp = new ArrayList();
        zoneSetUp.add("faithbroker");
        this.zoneAccess.put("human-resources", zoneSetUp);
        zoneSetUp = new ArrayList();
        zoneSetUp.add("reggiemint");
        zoneSetUp.add("tomtally");
        zoneSetUp.add("sallycounter");
        this.zoneAccess.put("finance", zoneSetUp);
        zoneSetUp = new ArrayList();
        zoneSetUp.add("garygeeke");
        this.zoneAccess.put("infrastructure", zoneSetUp);
        zoneSetUp = new ArrayList();
        zoneSetUp.add("pollytasker");
        zoneSetUp.add("bobnitter");
        zoneSetUp.add("lemmiestage");
        zoneSetUp.add("nancynoah");
        zoneSetUp.add("dessigna");
        this.zoneAccess.put("development", zoneSetUp);
        zoneSetUp = new ArrayList();
        zoneSetUp.add("stewFaster");
        this.zoneAccess.put("manufacturing", zoneSetUp);
        zoneSetUp = new ArrayList();
        zoneSetUp.add("garygeeke");
        zoneSetUp.add("erinoverview");
        zoneSetUp.add("ivorpadlock");
        zoneSetUp.add("jukeskeeper");
        zoneSetUp.add("pollytasker");
        zoneSetUp.add("faithbroker");
        zoneSetUp.add("reggiemint");
        this.zoneAccess.put("governance", zoneSetUp);
    }

    public void validateUserForServer(String userId) throws UserNotAuthorizedException {
        if (this.allUsers.contains(userId)) {
            return;
        }
        super.validateUserForServer(userId);
    }

    public void validateUserAsServerAdmin(String userId) throws UserNotAuthorizedException {
        if (this.serverAdmins.contains(userId)) {
            return;
        }
        super.validateUserAsServerAdmin(userId);
    }

    public void validateUserAsServerOperator(String userId) throws UserNotAuthorizedException {
        if (this.serverOperators.contains(userId)) {
            return;
        }
        super.validateUserAsServerOperator(userId);
    }

    public void validateUserAsServerInvestigator(String userId) throws UserNotAuthorizedException {
        if (this.serverInvestigators.contains(userId)) {
            return;
        }
        super.validateUserAsServerInvestigator(userId);
    }

    public void validateUserForService(String userId, String serviceName) throws UserNotAuthorizedException {
        if (this.allUsers.contains(userId)) {
            return;
        }
        super.validateUserForService(userId, serviceName);
    }

    public void validateUserForServiceOperation(String userId, String serviceName, String serviceOperationName) throws UserNotAuthorizedException {
        String assetOwnerServiceName = "Asset Owner OMAS";
        String deleteAssetOperationName = "deleteAsset";
        if ("Asset Owner OMAS".equals(serviceName) && "deleteAsset".equals(serviceOperationName) ? this.npaAccounts.contains(userId) : this.allUsers.contains(userId)) {
            return;
        }
        super.validateUserForServiceOperation(userId, serviceName, serviceOperationName);
    }

    public void validateUserForConnection(String userId, Connection connection) throws UserNotAuthorizedException {
        if (connection == null) {
            return;
        }
        if (connection.getClearPassword() == null && connection.getEncryptedPassword() == null && connection.getSecuredProperties() == null) {
            return;
        }
        if (this.npaAccounts.contains(userId)) {
            return;
        }
        super.validateUserForConnection(userId, connection);
    }

    public Connection validateUserForAssetConnectionList(String userId, Asset asset, List<Connection> connections) throws UserNotAuthorizedException {
        UserNotAuthorizedException caughtException = null;
        if (connections != null && !connections.isEmpty()) {
            ArrayList<Connection> unsecuredConnections = new ArrayList<Connection>();
            for (Connection connection : connections) {
                if (connection == null) continue;
                if (connection.getClearPassword() == null && connection.getEncryptedPassword() == null && connection.getSecuredProperties() == null) {
                    unsecuredConnections.add(connection);
                    continue;
                }
                try {
                    this.validateUserForConnection(userId, connection);
                    return connection;
                }
                catch (UserNotAuthorizedException error) {
                    caughtException = error;
                }
            }
            for (Connection connection : unsecuredConnections) {
                if (connection == null) continue;
                try {
                    this.validateUserForConnection(userId, connection);
                    return connection;
                }
                catch (UserNotAuthorizedException error) {
                    caughtException = error;
                }
            }
        }
        if (caughtException != null) {
            throw caughtException;
        }
        return null;
    }

    private boolean userHasAccessToAssetZones(String userId, List<String> assetZones, boolean updateRequested, boolean zoneMembershipChanged, boolean userIsAssetOwner) {
        List<String> testZones = assetZones == null || assetZones.isEmpty() ? this.defaultZoneMembership : assetZones;
        if (testZones.contains("quarantine")) {
            List<String> zoneAccounts = this.zoneAccess.get("quarantine");
            if (zoneAccounts != null && zoneAccounts.contains(userId)) {
                return true;
            }
        } else {
            for (String zoneName : testZones) {
                List<String> zoneAccounts;
                if (zoneName == null || !(zoneName.equals("data-lake") && updateRequested ? this.npaAccounts.contains(userId) : (zoneName.equals("personal-files") ? userIsAssetOwner : (zoneAccounts = this.zoneAccess.get(zoneName)) != null && zoneAccounts.contains(userId)))) continue;
                return true;
            }
        }
        return false;
    }

    private List<String> addZoneName(List<String> currentZones, String zoneToAdd) {
        List<String> resultingZones;
        if (zoneToAdd == null) {
            return currentZones;
        }
        if (currentZones == null) {
            resultingZones = new ArrayList<String>();
            resultingZones.add(zoneToAdd);
        } else {
            resultingZones = currentZones;
            if (!resultingZones.contains(zoneToAdd)) {
                resultingZones.add(zoneToAdd);
            }
        }
        return resultingZones;
    }

    private List<String> removeZoneName(List<String> currentZones, String zoneToRemove) {
        if (zoneToRemove == null || currentZones == null) {
            return currentZones;
        }
        ArrayList<String> resultingZones = new ArrayList<String>(currentZones);
        resultingZones.remove(zoneToRemove);
        return resultingZones;
    }

    private boolean isUserAssetOwner(String userId, Asset asset) {
        if (asset != null && userId != null) {
            return userId.equals(asset.getOwner());
        }
        return false;
    }

    private boolean hasZoneChanged(List<String> oldZoneMembership, List<String> newZoneMembership) {
        if (oldZoneMembership == newZoneMembership) {
            return false;
        }
        if (oldZoneMembership == null || newZoneMembership == null) {
            return true;
        }
        return !oldZoneMembership.containsAll(newZoneMembership) || !newZoneMembership.containsAll(oldZoneMembership);
    }

    private boolean zoneBeenRemoved(String zoneName, List<String> oldZoneMembership, List<String> newZoneMembership) {
        if (zoneName == null) {
            return false;
        }
        if (oldZoneMembership == newZoneMembership) {
            return false;
        }
        if (oldZoneMembership == null) {
            return false;
        }
        if (oldZoneMembership.contains(zoneName)) {
            if (newZoneMembership == null) {
                return true;
            }
            return !newZoneMembership.contains(zoneName);
        }
        return false;
    }

    public List<String> setSupportedZonesForUser(List<String> supportedZones, String serviceName, String user) throws InvalidParameterException, PropertyServerException {
        if (this.externalUsers.contains(user)) {
            return this.zonesForExternals;
        }
        return supportedZones;
    }

    public List<String> setAssetZonesToDefault(List<String> defaultZones, Asset asset) throws InvalidParameterException, PropertyServerException {
        if (defaultZones == null || defaultZones.isEmpty()) {
            return super.setAssetZonesToDefault(this.defaultZoneMembership, asset);
        }
        return super.setAssetZonesToDefault(defaultZones, asset);
    }

    @Deprecated
    public List<String> verifyAssetZones(List<String> defaultZones, List<String> supportedZones, Asset originalAsset, Asset updatedAsset) throws InvalidParameterException, PropertyServerException {
        if (updatedAsset != null) {
            if (updatedAsset.getOwner() != null) {
                return this.addZoneName(updatedAsset.getZoneMembership(), this.ownerZones.get(updatedAsset.getOwner()));
            }
            return updatedAsset.getZoneMembership();
        }
        return null;
    }

    public List<String> verifyAssetZones(List<String> defaultZones, List<String> supportedZones, List<String> publishZones, Asset originalAsset, Asset updatedAsset) throws InvalidParameterException, PropertyServerException {
        if (updatedAsset != null) {
            if (updatedAsset.getOwner() != null) {
                return this.addZoneName(updatedAsset.getZoneMembership(), this.ownerZones.get(updatedAsset.getOwner()));
            }
            return updatedAsset.getZoneMembership();
        }
        return null;
    }

    private boolean validateSeparationOfDuties(String userId, AssetAuditHeader auditHeader) {
        if (auditHeader != null) {
            return !userId.equals(auditHeader.getCreatedBy());
        }
        return false;
    }

    public void validateUserForAssetCreate(String userId, Asset asset) throws UserNotAuthorizedException {
        if (asset != null && this.userHasAccessToAssetZones(userId, asset.getZoneMembership(), true, false, this.isUserAssetOwner(userId, asset))) {
            return;
        }
        super.validateUserForAssetCreate(userId, asset);
    }

    public void validateUserForAssetRead(String userId, Asset asset) throws UserNotAuthorizedException {
        if (asset != null && this.userHasAccessToAssetZones(userId, asset.getZoneMembership(), false, false, this.isUserAssetOwner(userId, asset))) {
            return;
        }
        super.validateUserForAssetRead(userId, asset);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validateUserForAssetDetailUpdate(String userId, Asset originalAsset, AssetAuditHeader originalAssetAuditHeader, Asset newAsset) throws UserNotAuthorizedException {
        String methodName = "validateUserForAssetDetailUpdate";
        if (userId != null && originalAsset != null && newAsset != null && this.userHasAccessToAssetZones(userId, originalAsset.getZoneMembership(), true, this.hasZoneChanged(originalAsset.getZoneMembership(), newAsset.getZoneMembership()), this.isUserAssetOwner(userId, originalAsset))) {
            if (newAsset.getZoneMembership() != null) {
                if (!this.zoneBeenRemoved("quarantine", originalAsset.getZoneMembership(), newAsset.getZoneMembership())) return;
                if (newAsset.getOwner() != null) {
                    if (this.npaAccounts.contains(userId) || this.validateSeparationOfDuties(userId, originalAssetAuditHeader)) {
                        return;
                    }
                    super.throwUnauthorizedZoneChange(userId, newAsset, originalAsset.getZoneMembership(), newAsset.getZoneMembership(), "validateUserForAssetDetailUpdate");
                } else {
                    super.throwIncompleteAsset(userId, newAsset, "owner", "validateUserForAssetDetailUpdate");
                }
            } else {
                super.throwIncompleteAsset(userId, newAsset, "zoneMembership", "validateUserForAssetDetailUpdate");
            }
        }
        super.validateUserForAssetDetailUpdate(userId, originalAsset, originalAssetAuditHeader, newAsset);
    }

    public void validateUserForAssetAttachmentUpdate(String userId, Asset asset) throws UserNotAuthorizedException {
        if (asset != null && this.userHasAccessToAssetZones(userId, asset.getZoneMembership(), true, false, this.isUserAssetOwner(userId, asset))) {
            return;
        }
        super.validateUserForAssetAttachmentUpdate(userId, asset);
    }

    public void validateUserForAssetFeedback(String userId, Asset asset) throws UserNotAuthorizedException {
        if (asset != null && this.userHasAccessToAssetZones(userId, asset.getZoneMembership(), false, false, this.isUserAssetOwner(userId, asset))) {
            return;
        }
        super.validateUserForAssetAttachmentUpdate(userId, asset);
    }

    public void validateUserForAssetDelete(String userId, Asset asset) throws UserNotAuthorizedException {
        if (asset != null && this.userHasAccessToAssetZones(userId, asset.getZoneMembership(), true, false, this.isUserAssetOwner(userId, asset))) {
            return;
        }
        super.validateUserForAssetDelete(userId, asset);
    }

    public void validateUserForTypeCreate(String userId, String metadataCollectionName, TypeDef typeDef) throws UserNotAuthorizedException {
        if (this.metadataArchitects.contains(userId)) {
            return;
        }
        if (this.localServerUserId != null && this.localServerUserId.equals(userId)) {
            return;
        }
        super.validateUserForTypeCreate(userId, metadataCollectionName, typeDef);
    }

    public void validateUserForTypeCreate(String userId, String metadataCollectionName, AttributeTypeDef attributeTypeDef) throws UserNotAuthorizedException {
        if (this.metadataArchitects.contains(userId)) {
            return;
        }
        if (this.localServerUserId != null && this.localServerUserId.equals(userId)) {
            return;
        }
        super.validateUserForTypeCreate(userId, metadataCollectionName, attributeTypeDef);
    }

    public void validateUserForTypeRead(String userId, String metadataCollectionName, TypeDef typeDef) throws UserNotAuthorizedException {
        if (this.allUsers.contains(userId)) {
            return;
        }
        if (this.localServerUserId != null && this.localServerUserId.equals(userId)) {
            return;
        }
        super.validateUserForTypeRead(userId, metadataCollectionName, typeDef);
    }

    public void validateUserForTypeRead(String userId, String metadataCollectionName, AttributeTypeDef attributeTypeDef) throws UserNotAuthorizedException {
        if (this.allUsers.contains(userId)) {
            return;
        }
        if (this.localServerUserId != null && this.localServerUserId.equals(userId)) {
            return;
        }
        super.validateUserForTypeRead(userId, metadataCollectionName, attributeTypeDef);
    }

    public void validateUserForTypeUpdate(String userId, String metadataCollectionName, TypeDef typeDef, TypeDefPatch patch) throws UserNotAuthorizedException {
        if (this.metadataArchitects.contains(userId)) {
            return;
        }
        if (this.localServerUserId != null && this.localServerUserId.equals(userId)) {
            return;
        }
        super.validateUserForTypeUpdate(userId, metadataCollectionName, typeDef, patch);
    }

    public void validateUserForTypeDelete(String userId, String metadataCollectionName, TypeDef typeDef) throws UserNotAuthorizedException {
        if (this.metadataArchitects.contains(userId)) {
            return;
        }
        if (this.localServerUserId != null && this.localServerUserId.equals(userId)) {
            return;
        }
        super.validateUserForTypeDelete(userId, metadataCollectionName, typeDef);
    }

    public void validateUserForTypeDelete(String userId, String metadataCollectionName, AttributeTypeDef attributeTypeDef) throws UserNotAuthorizedException {
        if (this.metadataArchitects.contains(userId)) {
            return;
        }
        if (this.localServerUserId != null && this.localServerUserId.equals(userId)) {
            return;
        }
        super.validateUserForTypeDelete(userId, metadataCollectionName, attributeTypeDef);
    }

    public void validateUserForTypeReIdentify(String userId, String metadataCollectionName, TypeDef originalTypeDef, String newTypeDefGUID, String newTypeDefName) throws UserNotAuthorizedException {
        if (this.metadataArchitects.contains(userId)) {
            return;
        }
        if (this.localServerUserId != null && this.localServerUserId.equals(userId)) {
            return;
        }
        super.validateUserForTypeReIdentify(userId, metadataCollectionName, originalTypeDef, newTypeDefGUID, newTypeDefName);
    }

    public void validateUserForTypeReIdentify(String userId, String metadataCollectionName, AttributeTypeDef originalAttributeTypeDef, String newTypeDefGUID, String newTypeDefName) throws UserNotAuthorizedException {
        if (this.metadataArchitects.contains(userId)) {
            return;
        }
        if (this.localServerUserId != null && this.localServerUserId.equals(userId)) {
            return;
        }
        super.validateUserForTypeReIdentify(userId, metadataCollectionName, originalAttributeTypeDef, newTypeDefGUID, newTypeDefName);
    }

    public void validateUserForEntityCreate(String userId, String metadataCollectionName, String entityTypeGUID, InstanceProperties initialProperties, List<Classification> initialClassifications, InstanceStatus initialStatus) throws UserNotAuthorizedException {
    }

    public EntityDetail validateUserForEntityRead(String userId, String metadataCollectionName, EntityDetail instance) throws UserNotAuthorizedException {
        if ("cocoMDS2".equals(this.serverName)) {
            if (instance.getMetadataCollectionName() == null) {
                return super.validateUserForEntityRead(userId, metadataCollectionName, instance);
            }
            if (!instance.getMetadataCollectionName().equals(metadataCollectionName)) {
                return null;
            }
        }
        return instance;
    }

    public void validateUserForEntitySummaryRead(String userId, String metadataCollectionName, EntitySummary instance) throws UserNotAuthorizedException {
    }

    public void validateUserForEntityProxyRead(String userId, String metadataCollectionName, EntityProxy instance) throws UserNotAuthorizedException {
    }

    public void validateUserForEntityUpdate(String userId, String metadataCollectionName, EntityDetail instance) throws UserNotAuthorizedException {
    }

    public void validateUserForEntityClassificationAdd(String userId, String metadataCollectionName, EntitySummary instance, String classificationName, InstanceProperties properties) throws UserNotAuthorizedException {
    }

    public void validateUserForEntityClassificationUpdate(String userId, String metadataCollectionName, EntitySummary instance, String classificationName, InstanceProperties properties) throws UserNotAuthorizedException {
    }

    public void validateUserForEntityClassificationDelete(String userId, String metadataCollectionName, EntitySummary instance, String classificationName) throws UserNotAuthorizedException {
    }

    public void validateUserForEntityDelete(String userId, String metadataCollectionName, EntityDetail instance) throws UserNotAuthorizedException {
    }

    public void validateUserForEntityRestore(String userId, String metadataCollectionName, String deletedEntityGUID) throws UserNotAuthorizedException {
    }

    public void validateUserForEntityReIdentification(String userId, String metadataCollectionName, EntityDetail instance, String newGUID) throws UserNotAuthorizedException {
    }

    public void validateUserForEntityReTyping(String userId, String metadataCollectionName, EntityDetail instance, TypeDefSummary newTypeDefSummary) throws UserNotAuthorizedException {
    }

    public void validateUserForEntityReHoming(String userId, String metadataCollectionName, EntityDetail instance, String newHomeMetadataCollectionId, String newHomeMetadataCollectionName) throws UserNotAuthorizedException {
    }

    public void validateUserForRelationshipCreate(String userId, String metadataCollectionName, String relationshipTypeGUID, InstanceProperties initialProperties, EntitySummary entityOneSummary, EntitySummary entityTwoSummary, InstanceStatus initialStatus) throws UserNotAuthorizedException {
    }

    public Relationship validateUserForRelationshipRead(String userId, String metadataCollectionName, Relationship instance) throws UserNotAuthorizedException {
        return instance;
    }

    public void validateUserForRelationshipUpdate(String userId, String metadataCollectionName, Relationship instance) throws UserNotAuthorizedException {
    }

    public void validateUserForRelationshipDelete(String userId, String metadataCollectionName, Relationship instance) throws UserNotAuthorizedException {
    }

    public void validateUserForRelationshipRestore(String userId, String metadataCollectionName, String deletedRelationshipGUID) throws UserNotAuthorizedException {
    }

    public void validateUserForRelationshipReIdentification(String userId, String metadataCollectionName, Relationship instance, String newGUID) throws UserNotAuthorizedException {
    }

    public void validateUserForRelationshipReTyping(String userId, String metadataCollectionName, Relationship instance, TypeDefSummary newTypeDefSummary) throws UserNotAuthorizedException {
    }

    public void validateUserForRelationshipReHoming(String userId, String metadataCollectionName, Relationship instance, String newHomeMetadataCollectionId, String newHomeMetadataCollectionName) throws UserNotAuthorizedException {
    }

    public boolean validateEntityReferenceCopySave(EntityDetail instance) {
        return !"cocoMDS6".equals(this.serverName);
    }

    public boolean validateRelationshipReferenceCopySave(Relationship instance) {
        return !"cocoMDS6".equals(this.serverName);
    }
}

