/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.metadatasecurity.samples;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.security.Keys;
import java.security.Key;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.http.HttpHeadersThreadLocal;
import org.odpi.openmetadata.metadatasecurity.connectors.OpenMetadataPlatformSecurityConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CocoPharmaPlatformSecurityConnectorTokenBased
extends OpenMetadataPlatformSecurityConnector {
    private final byte[] secret = Base64.getDecoder().decode("d14uaEwsGU3cXopmxaEDqhQTow81zixFWbFUuu3budQ");
    private static final Logger log = LoggerFactory.getLogger(CocoPharmaPlatformSecurityConnectorTokenBased.class);

    public void validateUserForNewServer(String userId) throws UserNotAuthorizedException {
        String methodName = "validateUserForNewServer";
        if (!this.isAllowedToPerformAction(userId, PlatformRoles.PLATFORM_ADMINISTRATOR).booleanValue()) {
            super.throwUnauthorizedPlatformAccess(userId, "validateUserForNewServer");
        }
    }

    public void validateUserAsOperatorForPlatform(String userId) throws UserNotAuthorizedException {
        String methodName = "validateUserAsOperatorForPlatform";
        if (!this.isAllowedToPerformAction(userId, PlatformRoles.PLATFORM_OPERATOR).booleanValue()) {
            super.throwUnauthorizedPlatformAccess(userId, "validateUserAsOperatorForPlatform");
        }
    }

    public void validateUserAsInvestigatorForPlatform(String userId) throws UserNotAuthorizedException {
        String methodName = "validateUserAsInvestigatorForPlatform";
        if (!this.isAllowedToPerformAction(userId, PlatformRoles.PLATFORM_INVESTIGATOR).booleanValue()) {
            super.throwUnauthorizedPlatformAccess(userId, "validateUserAsInvestigatorForPlatform");
        }
    }

    private List<String> getUserActionsFromToken(String userId) {
        Map headersMap = (Map)HttpHeadersThreadLocal.getHeadersThreadLocal().get();
        if (headersMap != null && !headersMap.isEmpty()) {
            Jws jwtClaims = Jwts.parserBuilder().setSigningKey((Key)Keys.hmacShaKeyFor((byte[])this.secret)).build().parseClaimsJws((String)headersMap.get("authorization"));
            String username = ((Claims)jwtClaims.getBody()).getSubject();
            List actions = (List)((Claims)jwtClaims.getBody()).get("actions", List.class);
            if (username.equals(userId) && actions != null && !actions.isEmpty()) {
                log.info("User {} validated for issuing requests.", (Object)username);
                return actions;
            }
        }
        return null;
    }

    private Boolean isAllowedToPerformAction(String userId, PlatformRoles role) {
        List<String> userActions = this.getUserActionsFromToken(userId);
        if (userActions != null && !userActions.isEmpty() && userActions.contains(role.getName())) {
            return true;
        }
        return false;
    }

    private static enum PlatformRoles {
        PLATFORM_ADMINISTRATOR,
        PLATFORM_OPERATOR,
        PLATFORM_INVESTIGATOR;


        private String getName() {
            return this.toString().toLowerCase();
        }
    }
}

