/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.test.unittest.utilities;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.testng.Assert;

public class BeanTestBase {
    private <T> void testStringEqualsHashcode(T testObject, T clonedObject, T differentObject, String className) {
        Assert.assertNotEquals(testObject, null);
        Assert.assertNotEquals(clonedObject, null);
        Assert.assertNotEquals(differentObject, null);
        Assert.assertNotEquals(testObject, (Object)"DummyString");
        Assert.assertEquals(clonedObject, testObject);
        Assert.assertEquals(clonedObject, clonedObject);
        Assert.assertNotEquals(testObject, differentObject);
        Assert.assertEquals((int)testObject.hashCode(), (int)testObject.hashCode());
        Assert.assertEquals((int)testObject.hashCode(), (int)clonedObject.hashCode());
        Assert.assertNotEquals((Object)testObject.hashCode(), (Object)differentObject.hashCode());
        Assert.assertTrue((boolean)testObject.toString().contains(className));
    }

    protected <T> T testJSON(T testObject, Class<T> testObjectClass) {
        ObjectMapper objectMapper = new ObjectMapper();
        String jsonString = null;
        try {
            jsonString = objectMapper.writeValueAsString(testObject);
        }
        catch (Throwable exc) {
            Assert.fail((String)("Exception: " + exc.getMessage()));
        }
        try {
            return (T)objectMapper.readValue(jsonString, testObjectClass);
        }
        catch (Throwable exc) {
            Assert.fail((String)("Exception: " + exc.getMessage()));
            return null;
        }
    }

    public <T> T testResponseObject(T testObject, T clonedObject, T differentObject, Class<T> testObjectClass) {
        this.testStringEqualsHashcode(testObject, clonedObject, differentObject, testObjectClass.getSimpleName());
        return this.testJSON(testObject, testObjectClass);
    }
}

