/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.test.unittest.utilities;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.MessageDefinition;
import org.testng.Assert;

abstract class MessageSetTest {
    private List<String> existingMessageIds = new ArrayList<String>();
    private List<String> existingMessageTemplates = new ArrayList<String>();
    private List<String> existingSystemActions = new ArrayList<String>();
    private List<String> existingUserActions = new ArrayList<String>();

    MessageSetTest() {
    }

    private boolean isUniqueOrdinal(String ordinal) {
        if (this.existingMessageIds.contains(ordinal)) {
            return false;
        }
        this.existingMessageIds.add(ordinal);
        return true;
    }

    private boolean isUniqueMessageTemplate(String template) {
        if (this.existingMessageTemplates.contains(template)) {
            return false;
        }
        this.existingMessageTemplates.add(template);
        return true;
    }

    private boolean isUniqueSystemAction(String systemAction) {
        if (this.existingSystemActions.contains(systemAction)) {
            return false;
        }
        this.existingSystemActions.add(systemAction);
        return true;
    }

    private boolean isUniqueUserAction(String userAction) {
        if (this.existingUserActions.contains(userAction)) {
            return false;
        }
        this.existingUserActions.add(userAction);
        return true;
    }

    void testSingleMessageDefinitionValues(MessageDefinition messageDefinition, String messageIdPrefix, String ... messageParameters) {
        Assert.assertNotNull((Object)messageDefinition.getMessageId(), (String)("Message definition " + messageDefinition.toString() + " has null messageId"));
        Assert.assertNotNull((Object)messageDefinition.getMessageTemplate(), (String)("Message definition " + messageDefinition.toString() + " has null messageTemplate"));
        Assert.assertNotNull((Object)messageDefinition.getSystemAction(), (String)("Message definition " + messageDefinition.toString() + " has null system action"));
        Assert.assertNotNull((Object)messageDefinition.getUserAction(), (String)("Message definition " + messageDefinition.toString() + " has null user action"));
        Assert.assertNotEquals((Object)"", (Object)messageDefinition.getMessageId(), (String)("Message definition " + messageDefinition.toString() + " has empty messageId"));
        Assert.assertNotEquals((Object)"", (Object)messageDefinition.getMessageTemplate(), (String)("Message definition " + messageDefinition.toString() + " has empty message template"));
        Assert.assertNotEquals((Object)"", (Object)messageDefinition.getSystemAction(), (String)("Message definition " + messageDefinition.toString() + " has empty system action"));
        Assert.assertNotEquals((Object)"", (Object)messageDefinition.getUserAction(), (String)("Message definition " + messageDefinition.toString() + " has empty user action"));
        Assert.assertTrue((boolean)this.isUniqueOrdinal(messageDefinition.getMessageId()), (String)("Message definition " + messageDefinition.getMessageId() + " does not have a unique messageId"));
        Assert.assertTrue((boolean)this.isUniqueMessageTemplate(messageDefinition.getMessageTemplate()), (String)("Message definition " + messageDefinition.getMessageId() + " does not have a unique messageTemplate"));
        Assert.assertTrue((boolean)this.isUniqueSystemAction(messageDefinition.getSystemAction()), (String)("Message definition " + messageDefinition.getMessageId() + " does not have a unique system action"));
        Assert.assertTrue((boolean)this.isUniqueUserAction(messageDefinition.getUserAction()), (String)("Message definition " + messageDefinition.getMessageId() + " does not have a unique user action"));
        Assert.assertTrue((boolean)messageDefinition.getMessageId().startsWith(messageIdPrefix), (String)("Message definition " + messageDefinition.getMessageId() + " does not start with the correct message prefix: " + messageIdPrefix));
        Assert.assertFalse((boolean)messageDefinition.getMessageId().endsWith(" "), (String)("Message definition " + messageDefinition.getMessageId() + " has a space at the end of its messageId"));
        if (messageParameters.length == 0) {
            Assert.assertNull((Object)messageDefinition.getMessageParams());
        } else {
            Assert.assertEquals((Object[])messageParameters, (Object[])messageDefinition.getMessageParams());
        }
    }
}

