/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.test.unittest.utilities;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import org.testng.Assert;

public class BeanTestBase {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final ObjectReader OBJECT_READER = OBJECT_MAPPER.reader();
    private static final ObjectWriter OBJECT_WRITER = OBJECT_MAPPER.writer();

    private <T> void testStringEqualsHashcode(T testObject, T clonedObject, T differentObject, String className) {
        Assert.assertNotEquals(testObject, null);
        Assert.assertNotEquals(clonedObject, null);
        Assert.assertNotEquals(differentObject, null);
        Assert.assertNotEquals(testObject, (Object)"DummyString");
        Assert.assertEquals(clonedObject, testObject);
        Assert.assertEquals(clonedObject, clonedObject);
        Assert.assertNotEquals(testObject, differentObject);
        Assert.assertEquals((int)testObject.hashCode(), (int)testObject.hashCode());
        Assert.assertEquals((int)testObject.hashCode(), (int)clonedObject.hashCode());
        Assert.assertNotEquals((Object)testObject.hashCode(), (Object)differentObject.hashCode());
        Assert.assertTrue((boolean)testObject.toString().contains(className));
    }

    protected <T> T testJSON(T testObject, Class<T> testObjectClass) {
        String jsonString = null;
        try {
            jsonString = OBJECT_WRITER.writeValueAsString(testObject);
        }
        catch (Throwable exc) {
            Assert.fail((String)("Exception: " + exc.getMessage()));
        }
        try {
            return (T)OBJECT_READER.readValue(jsonString, testObjectClass);
        }
        catch (Throwable exc) {
            Assert.fail((String)("Exception: " + exc.getMessage()));
            return null;
        }
    }

    public <T> T testResponseObject(T testObject, T clonedObject, T differentObject, Class<T> testObjectClass) {
        this.testStringEqualsHashcode(testObject, clonedObject, differentObject, testObjectClass.getSimpleName());
        return this.testJSON(testObject, testObjectClass);
    }
}

