/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.test.unittest.utilities;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.odpi.openmetadata.frameworks.auditlog.MessageFormatter;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.MessageDefinition;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.testng.Assert;

public class OCFCheckedExceptionBasedTest {
    private final String reportingClassName = "TestClassName";
    private final String reportingActionDescription = "TestActionDescription";
    private final Throwable reportedCaughtException = new Exception("TestReportedCaughtException");
    private final ExceptionMessageDefinition messageDefinition;
    private final Map<String, Object> reportedRelatedProperties = new HashMap<String, Object>();
    private final Map<String, Object> emptyRelatedProperties = new HashMap<String, Object>();

    protected OCFCheckedExceptionBasedTest() {
        int reportedHTTPCode = 404;
        String reportedErrorMessageId = "TestErrorMessageId";
        String reportedErrorMessage = "TestErrorMessage";
        String reportedSystemAction = "TestSystemAction";
        String reportedUserAction = "TestUserAction";
        this.messageDefinition = new ExceptionMessageDefinition(reportedHTTPCode, reportedErrorMessageId, reportedErrorMessage, reportedSystemAction, reportedUserAction);
        this.reportedRelatedProperties.put("propertyName1", "propertyValue1");
    }

    private <T> T getBasicException(Class<T> exceptionClass, Throwable wrappedException, Map<String, Object> relatedProperties) {
        T exception = null;
        try {
            if (wrappedException == null && relatedProperties == null) {
                Constructor<T> constructor = exceptionClass.getConstructor(ExceptionMessageDefinition.class, String.class, String.class);
                exception = constructor.newInstance(this.messageDefinition, "TestClassName", "TestActionDescription");
            } else if (wrappedException != null && relatedProperties != null) {
                Constructor<T> constructor = exceptionClass.getConstructor(ExceptionMessageDefinition.class, String.class, String.class, Throwable.class, Map.class);
                exception = constructor.newInstance(this.messageDefinition, "TestClassName", "TestActionDescription", wrappedException, relatedProperties);
            } else if (wrappedException != null) {
                Constructor<T> constructor = exceptionClass.getConstructor(ExceptionMessageDefinition.class, String.class, String.class, Throwable.class);
                exception = constructor.newInstance(this.messageDefinition, "TestClassName", "TestActionDescription", wrappedException);
            } else {
                Constructor<T> constructor = exceptionClass.getConstructor(ExceptionMessageDefinition.class, String.class, String.class, Map.class);
                exception = constructor.newInstance(this.messageDefinition, "TestClassName", "TestActionDescription", relatedProperties);
            }
        }
        catch (Throwable error) {
            Assert.fail((String)error.toString());
        }
        return exception;
    }

    private <T> T getEnhancedException(Class<T> exceptionClass, String additionalProperty, Throwable wrappedException, Map<String, Object> relatedProperties) {
        T exception = null;
        try {
            if (wrappedException == null && relatedProperties == null) {
                Constructor<T> constructor = exceptionClass.getConstructor(ExceptionMessageDefinition.class, String.class, String.class, String.class);
                exception = constructor.newInstance(this.messageDefinition, "TestClassName", "TestActionDescription", additionalProperty);
            } else if (wrappedException != null && relatedProperties != null) {
                Constructor<T> constructor = exceptionClass.getConstructor(ExceptionMessageDefinition.class, String.class, String.class, Throwable.class, String.class, Map.class);
                exception = constructor.newInstance(this.messageDefinition, "TestClassName", "TestActionDescription", wrappedException, additionalProperty, relatedProperties);
            } else if (wrappedException != null) {
                Constructor<T> constructor = exceptionClass.getConstructor(ExceptionMessageDefinition.class, String.class, String.class, Throwable.class, String.class);
                exception = constructor.newInstance(this.messageDefinition, "TestClassName", "TestActionDescription", wrappedException, additionalProperty);
            } else {
                Constructor<T> constructor = exceptionClass.getConstructor(ExceptionMessageDefinition.class, String.class, String.class, String.class, Map.class);
                exception = constructor.newInstance(this.messageDefinition, "TestClassName", "TestActionDescription", additionalProperty, relatedProperties);
            }
        }
        catch (Throwable error) {
            Assert.fail((String)error.toString());
        }
        return exception;
    }

    private void testExceptionValues(OCFCheckedExceptionBase exception, Throwable nestedException, Map<String, Object> exceptionProperties) {
        MessageFormatter messageFormatter = new MessageFormatter();
        Assert.assertEquals((int)this.messageDefinition.getHttpErrorCode(), (int)exception.getReportedHTTPCode());
        Assert.assertEquals((String)"TestClassName", (String)exception.getReportingClassName());
        Assert.assertEquals((String)"TestActionDescription", (String)exception.getReportingActionDescription());
        Assert.assertEquals((String)messageFormatter.getFormattedMessage((MessageDefinition)this.messageDefinition), (String)exception.getReportedErrorMessage());
        Assert.assertEquals((String)this.messageDefinition.getMessageId(), (String)exception.getReportedErrorMessageId());
        Assert.assertEquals((Object[])this.messageDefinition.getMessageParams(), (Object[])exception.getReportedErrorMessageParameters());
        Assert.assertEquals((String)this.messageDefinition.getSystemAction(), (String)exception.getReportedSystemAction());
        Assert.assertEquals((String)this.messageDefinition.getUserAction(), (String)exception.getReportedUserAction());
        if (nestedException == null) {
            Assert.assertNull((Object)exception.getReportedCaughtException());
        } else {
            Assert.assertEquals((Object)nestedException, (Object)exception.getReportedCaughtException());
        }
        if (exceptionProperties == null) {
            Assert.assertNull((Object)exception.getRelatedProperties());
        } else {
            Assert.assertEquals(exceptionProperties, (Map)exception.getRelatedProperties());
        }
    }

    private void testStringEqualsHashCode(OCFCheckedExceptionBase exception1, OCFCheckedExceptionBase exception2, OCFCheckedExceptionBase exception3, OCFCheckedExceptionBase exception4, String className) {
        Assert.assertEquals((int)exception1.hashCode(), (int)exception1.hashCode());
        Assert.assertNotEquals((Object)exception2.hashCode(), (Object)exception1.hashCode());
        Assert.assertNotEquals((Object)exception3.hashCode(), (Object)exception1.hashCode());
        Assert.assertNotEquals((Object)exception4.hashCode(), (Object)exception1.hashCode());
        Assert.assertEquals((int)exception2.hashCode(), (int)exception2.hashCode());
        Assert.assertNotEquals((Object)exception3.hashCode(), (Object)exception2.hashCode());
        Assert.assertNotEquals((Object)exception4.hashCode(), (Object)exception2.hashCode());
        Assert.assertEquals((int)exception3.hashCode(), (int)exception3.hashCode());
        Assert.assertNotEquals((Object)exception4.hashCode(), (Object)exception3.hashCode());
        Assert.assertEquals((int)exception4.hashCode(), (int)exception4.hashCode());
        Assert.assertEquals((Object)exception1, (Object)exception1);
        Assert.assertNotEquals((Object)this.reportedCaughtException, (Object)exception1);
        Assert.assertNotEquals((Object)exception2, (Object)exception1);
        Assert.assertNotEquals((Object)exception3, (Object)exception1);
        Assert.assertNotEquals((Object)exception4, (Object)exception1);
        Assert.assertEquals((Object)exception2, (Object)exception2);
        Assert.assertNotEquals((Object)this.reportedCaughtException, (Object)exception2);
        Assert.assertNotEquals((Object)exception3, (Object)exception2);
        Assert.assertNotEquals((Object)exception4, (Object)exception2);
        Assert.assertEquals((Object)exception3, (Object)exception3);
        Assert.assertNotEquals((Object)this.reportedCaughtException, (Object)exception3);
        Assert.assertNotEquals((Object)exception4, (Object)exception3);
        Assert.assertTrue((boolean)exception1.toString().contains(className));
        Assert.assertTrue((boolean)exception2.toString().contains(className));
        Assert.assertTrue((boolean)exception3.toString().contains(className));
        Assert.assertTrue((boolean)exception4.toString().contains(className));
        Assert.assertEquals((String)exception1.toString(), (String)exception1.toString());
        Assert.assertNotEquals((Object)exception2.toString(), (Object)exception1.toString());
        Assert.assertNotEquals((Object)exception3.toString(), (Object)exception1.toString());
        Assert.assertNotEquals((Object)exception4.toString(), (Object)exception1.toString());
        Assert.assertEquals((String)exception2.toString(), (String)exception2.toString());
        Assert.assertNotEquals((Object)exception3.toString(), (Object)exception2.toString());
        Assert.assertNotEquals((Object)exception4.toString(), (Object)exception2.toString());
        Assert.assertEquals((String)exception3.toString(), (String)exception3.toString());
        Assert.assertNotEquals((Object)exception4.toString(), (Object)exception3.toString());
        Assert.assertEquals((String)exception4.toString(), (String)exception4.toString());
    }

    protected void testException(Class<?> exceptionClass) {
        OCFCheckedExceptionBase exception1 = (OCFCheckedExceptionBase)this.getBasicException(exceptionClass, null, null);
        this.testExceptionValues(exception1, null, null);
        OCFCheckedExceptionBase exception2 = (OCFCheckedExceptionBase)this.getBasicException(exceptionClass, null, this.reportedRelatedProperties);
        this.testExceptionValues(exception2, null, this.reportedRelatedProperties);
        OCFCheckedExceptionBase exception3 = (OCFCheckedExceptionBase)this.getBasicException(exceptionClass, this.reportedCaughtException, null);
        this.testExceptionValues(exception3, this.reportedCaughtException, null);
        OCFCheckedExceptionBase exception4 = (OCFCheckedExceptionBase)this.getBasicException(exceptionClass, this.reportedCaughtException, this.reportedRelatedProperties);
        this.testExceptionValues(exception4, this.reportedCaughtException, this.reportedRelatedProperties);
        this.testStringEqualsHashCode(exception1, exception2, exception3, exception4, exceptionClass.getSimpleName());
        OCFCheckedExceptionBase exception5 = (OCFCheckedExceptionBase)this.getBasicException(exceptionClass, null, this.emptyRelatedProperties);
        Assert.assertNull((Object)exception5.getReportedCaughtException());
    }

    protected void testEnhancedException(Class<?> exceptionClass, String additionalProperty) {
        OCFCheckedExceptionBase exception1 = (OCFCheckedExceptionBase)this.getEnhancedException(exceptionClass, additionalProperty, null, null);
        this.testExceptionValues(exception1, null, null);
        OCFCheckedExceptionBase exception2 = (OCFCheckedExceptionBase)this.getEnhancedException(exceptionClass, additionalProperty, null, this.reportedRelatedProperties);
        this.testExceptionValues(exception2, null, this.reportedRelatedProperties);
        OCFCheckedExceptionBase exception3 = (OCFCheckedExceptionBase)this.getEnhancedException(exceptionClass, additionalProperty, this.reportedCaughtException, null);
        this.testExceptionValues(exception3, this.reportedCaughtException, null);
        OCFCheckedExceptionBase exception4 = (OCFCheckedExceptionBase)this.getEnhancedException(exceptionClass, additionalProperty, this.reportedCaughtException, this.reportedRelatedProperties);
        this.testExceptionValues(exception4, this.reportedCaughtException, this.reportedRelatedProperties);
        this.testStringEqualsHashCode(exception1, exception2, exception3, exception4, exceptionClass.getSimpleName());
        OCFCheckedExceptionBase exception5 = (OCFCheckedExceptionBase)this.getEnhancedException(exceptionClass, additionalProperty, null, this.emptyRelatedProperties);
        Assert.assertNull((Object)exception5.getReportedCaughtException());
    }
}

