/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.integration.openapis.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageSet;

public enum OpenAPIIntegrationConnectorErrorCode implements ExceptionMessageSet
{
    UNEXPECTED_EXCEPTION(500, "OPEN-API-INTEGRATION-CONNECTOR-500-001", "The {0} integration connector received an unexpected exception {1} when cataloguing APIs; the error message was: {1}", "The connector is unable to catalog one or more APIs.", "Use the details from the error message to determine the cause of the error and retry the request once it is resolved."),
    NULL_URL(400, "OPEN-API-INTEGRATION-CONNECTOR-400-014", "OMAG server has been called with a null local server name", "The system is unable to configure the local server without knowing what it is called.", "The local server name is supplied by the caller to the OMAG server. This call needs to be corrected before the server can operate correctly."),
    CLIENT_SIDE_REST_API_ERROR(503, "OPEN-API-INTEGRATION-CONNECTOR-503-001", "A client-side exception of {0} was received from API call {1} to URL {2}.  The error message was {3}", "The integration has issued a call to the open metadata access service REST API in a remote server and has received an exception from the local client libraries.", "Look for errors in the local server's console to understand and correct the source of the error.");

    private ExceptionMessageDefinition messageDefinition;

    private OpenAPIIntegrationConnectorErrorCode(int httpErrorCode, String errorMessageId, String errorMessage, String systemAction, String userAction) {
        this.messageDefinition = new ExceptionMessageDefinition(httpErrorCode, errorMessageId, errorMessage, systemAction, userAction);
    }

    public ExceptionMessageDefinition getMessageDefinition() {
        return this.messageDefinition;
    }

    public ExceptionMessageDefinition getMessageDefinition(String ... params) {
        this.messageDefinition.setMessageParameters(params);
        return this.messageDefinition;
    }

    public String toString() {
        return "OpenAPIIntegrationConnectorErrorCode{messageDefinition=" + this.messageDefinition + "}";
    }
}

