/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.integration.openapis;

import org.odpi.openmetadata.adapters.connectors.integration.openapis.ffdc.OpenAPIIntegrationConnectorAuditCode;
import org.odpi.openmetadata.adapters.connectors.integration.openapis.ffdc.OpenAPIIntegrationConnectorErrorCode;
import org.odpi.openmetadata.adapters.connectors.restclients.RESTClientConnector;
import org.odpi.openmetadata.adapters.connectors.restclients.factory.RESTClientFactory;
import org.odpi.openmetadata.adapters.connectors.restclients.spring.SpringRESTClientConnector;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.springframework.core.ParameterizedTypeReference;

public class RESTClient {
    protected String serverName;
    protected String url;
    protected AuditLog auditLog = null;
    private final RESTClientConnector clientConnector;

    protected RESTClient(String serverName, String url, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "RESTClient(no authentication)";
        this.serverName = serverName;
        this.url = url;
        this.auditLog = auditLog;
        RESTClientFactory factory = new RESTClientFactory(serverName, url);
        try {
            this.clientConnector = factory.getClientConnector();
        }
        catch (Exception error) {
            throw new InvalidParameterException(OpenAPIIntegrationConnectorErrorCode.NULL_URL.getMessageDefinition(serverName, error.getMessage()), this.getClass().getName(), "RESTClient(no authentication)", (Throwable)error, "url or serverName");
        }
    }

    protected RESTClient(String serverName, String url, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "RESTClient(userId and password)";
        this.serverName = serverName;
        this.url = url;
        this.auditLog = auditLog;
        RESTClientFactory factory = new RESTClientFactory(serverName, url, userId, password, null, auditLog);
        try {
            this.clientConnector = factory.getClientConnector();
        }
        catch (Exception error) {
            throw new InvalidParameterException(OpenAPIIntegrationConnectorErrorCode.NULL_URL.getMessageDefinition(serverName, error.getMessage()), this.getClass().getName(), "RESTClient(userId and password)", (Throwable)error, "url or serverName");
        }
    }

    protected <T> T callGetRESTCallNoParams(String methodName, Class<T> returnClass, String urlTemplate) throws PropertyServerException {
        try {
            return (T)this.clientConnector.callGetRESTCall(methodName, returnClass, urlTemplate, new Object[0]);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, error);
            return null;
        }
    }

    protected <T> T callGetRESTCall(String methodName, Class<T> returnClass, String urlTemplate, Object ... params) throws PropertyServerException {
        try {
            return (T)this.clientConnector.callGetRESTCall(methodName, returnClass, urlTemplate, params);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, error);
            return null;
        }
    }

    protected <T> T callGetRESTCall(String methodName, ParameterizedTypeReference<T> responseType, String urlTemplate, Object ... params) throws PropertyServerException {
        try {
            SpringRESTClientConnector clientConnector = (SpringRESTClientConnector)this.clientConnector;
            return (T)clientConnector.callGetRESTCall(methodName, responseType, urlTemplate, params);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, error);
            return null;
        }
    }

    protected <T> T callPostRESTCallNoParams(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody) throws PropertyServerException {
        try {
            return (T)this.clientConnector.callPostRESTCallNoParams(methodName, returnClass, urlTemplate, requestBody);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, error);
            return null;
        }
    }

    protected <T> T callPostRESTCall(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody, Object ... params) throws PropertyServerException {
        try {
            return (T)this.clientConnector.callPostRESTCall(methodName, returnClass, urlTemplate, requestBody, params);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, error);
            return null;
        }
    }

    protected <T> T callPostRESTCall(String methodName, ParameterizedTypeReference<T> responseType, String urlTemplate, Object requestBody, Object ... params) throws PropertyServerException {
        try {
            SpringRESTClientConnector clientConnector = (SpringRESTClientConnector)this.clientConnector;
            return (T)clientConnector.callPostRESTCall(methodName, responseType, urlTemplate, requestBody, params);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, error);
            return null;
        }
    }

    protected <T> T callPutRESTCall(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody, Object ... params) throws PropertyServerException {
        try {
            return (T)this.clientConnector.callPutRESTCall(methodName, returnClass, urlTemplate, requestBody, params);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, error);
            return null;
        }
    }

    protected <T> T callPutRESTCall(String methodName, ParameterizedTypeReference<T> responseType, String urlTemplate, Object requestBody, Object ... params) throws PropertyServerException {
        try {
            SpringRESTClientConnector clientConnector = (SpringRESTClientConnector)this.clientConnector;
            return (T)clientConnector.callPutRESTCall(methodName, responseType, urlTemplate, requestBody, params);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, error);
            return null;
        }
    }

    protected <T> T callDeleteRESTCall(String methodName, Class<T> returnClass, String urlTemplate, Object ... params) throws PropertyServerException {
        try {
            return (T)this.clientConnector.callDeleteRESTCall(methodName, returnClass, urlTemplate, null, params);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, error);
            return null;
        }
    }

    protected <T> T callDeleteRESTCall(String methodName, ParameterizedTypeReference<T> responseType, String urlTemplate, Object ... params) throws PropertyServerException {
        try {
            SpringRESTClientConnector clientConnector = (SpringRESTClientConnector)this.clientConnector;
            return (T)clientConnector.callDeleteRESTCall(methodName, responseType, urlTemplate, null, params);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, error);
            return null;
        }
    }

    private void logRESTCallException(String methodName, Exception error) throws PropertyServerException {
        if (this.auditLog != null) {
            this.auditLog.logException(methodName, OpenAPIIntegrationConnectorAuditCode.CLIENT_SIDE_REST_API_ERROR.getMessageDefinition(methodName, this.serverName, this.url, error.getMessage()), (Throwable)error);
        }
        throw new PropertyServerException(OpenAPIIntegrationConnectorErrorCode.CLIENT_SIDE_REST_API_ERROR.getMessageDefinition(methodName, this.serverName, this.url, error.getMessage()), this.getClass().getName(), methodName, (Throwable)error);
    }
}

