/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.integration.openapis;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.datamanager.api.DataManagerEventListener;
import org.odpi.openmetadata.accessservices.datamanager.events.DataManagerOutboundEvent;
import org.odpi.openmetadata.accessservices.datamanager.events.DataManagerOutboundEventType;
import org.odpi.openmetadata.adapters.connectors.integration.openapis.RESTClient;
import org.odpi.openmetadata.adapters.connectors.integration.openapis.ffdc.OpenAPIIntegrationConnectorAuditCode;
import org.odpi.openmetadata.adapters.connectors.integration.openapis.ffdc.OpenAPIIntegrationConnectorErrorCode;
import org.odpi.openmetadata.adapters.connectors.integration.openapis.properties.OpenAPIOperation;
import org.odpi.openmetadata.adapters.connectors.integration.openapis.properties.OpenAPISpecification;
import org.odpi.openmetadata.adapters.connectors.integration.openapis.properties.OpenAPITag;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.APIElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.APIOperationElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementControlHeader;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.EndpointElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.apis.APIProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.apis.APIOperationProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.integrationservices.api.connector.APIIntegratorConnector;
import org.odpi.openmetadata.integrationservices.api.connector.APIIntegratorContext;

public class OpenAPIMonitorIntegrationConnector
extends APIIntegratorConnector
implements DataManagerEventListener {
    private static final String urlMarker = "http";
    private String templateQualifiedName = null;
    private String targetRootURL = null;
    private final Map<String, RESTClient> restClients = new HashMap<String, RESTClient>();
    private APIIntegratorContext myContext = null;
    public static final ObjectReader OBJECT_READER = new ObjectMapper().reader();

    public void start() throws ConnectorCheckedException {
        Map configurationProperties;
        super.start();
        String methodName = "start";
        this.myContext = super.getContext();
        EndpointProperties endpoint = this.connectionProperties.getEndpoint();
        if (endpoint != null) {
            this.targetRootURL = endpoint.getAddress();
        }
        if ((configurationProperties = this.connectionProperties.getConfigurationProperties()) != null) {
            this.templateQualifiedName = super.getStringConfigurationProperty("templateQualifiedName", configurationProperties);
        }
        try {
            if (this.targetRootURL != null) {
                RESTClient restClient = new RESTClient(this.connectorName, this.targetRootURL, this.auditLog);
                this.restClients.put(this.targetRootURL, restClient);
            } else {
                this.getRESTClients();
            }
        }
        catch (OCFCheckedExceptionBase error) {
            throw new ConnectorCheckedException("start", error);
        }
        if (this.auditLog != null) {
            if (this.targetRootURL != null) {
                this.auditLog.logMessage("start", OpenAPIIntegrationConnectorAuditCode.CONNECTOR_CONFIGURATION_WITH_ENDPOINT.getMessageDefinition(this.connectorName, this.targetRootURL, this.templateQualifiedName));
            } else {
                this.auditLog.logMessage("start", OpenAPIIntegrationConnectorAuditCode.CONNECTOR_CONFIGURATION_NO_ENDPOINT.getMessageDefinition(this.connectorName, this.templateQualifiedName));
            }
        }
    }

    public void processEvent(DataManagerOutboundEvent event) {
        block4: {
            String methodName = "processEvent";
            if (event.getEventType() == DataManagerOutboundEventType.NEW_ELEMENT_CREATED && this.propertyHelper.isTypeOf((ElementControlHeader)event.getPrincipleElement(), OpenMetadataType.ENDPOINT.typeName)) {
                try {
                    EndpointElement endpointElement = this.myContext.getEndpointByGUID(event.getPrincipleElement().getGUID());
                    if (endpointElement != null) {
                        this.registerEndpoint(endpointElement, "processEvent");
                    }
                }
                catch (Exception error) {
                    if (this.auditLog == null) break block4;
                    this.auditLog.logMessage("processEvent", OpenAPIIntegrationConnectorAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), "processEvent", error.getMessage()));
                }
            }
        }
    }

    private void getRESTClients() {
        block4: {
            String methodName = "getRESTClients";
            try {
                List endpointElements = this.myContext.findEndpoints(urlMarker, 0, 0);
                if (endpointElements != null) {
                    for (EndpointElement endpointElement : endpointElements) {
                        if (endpointElement == null) continue;
                        this.registerEndpoint(endpointElement, "getRESTClients");
                    }
                }
            }
            catch (Exception error) {
                if (this.auditLog == null) break block4;
                this.auditLog.logMessage("getRESTClients", OpenAPIIntegrationConnectorAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), "getRESTClients", error.getMessage()));
            }
        }
    }

    private void registerEndpoint(EndpointElement endpointElement, String methodName) {
        if (endpointElement.getElementHeader() != null && endpointElement.getElementHeader().getGUID() != null && endpointElement.getEndpointProperties() != null && endpointElement.getEndpointProperties().getAddress() != null) {
            if (endpointElement.getEndpointProperties().getAddress().startsWith(urlMarker)) {
                try {
                    if (this.restClients.get(endpointElement.getEndpointProperties().getAddress()) == null) {
                        if (this.auditLog != null) {
                            this.auditLog.logMessage(methodName, OpenAPIIntegrationConnectorAuditCode.NEW_ENDPOINT.getMessageDefinition(this.connectorName, endpointElement.getEndpointProperties().getDisplayName(), endpointElement.getEndpointProperties().getAddress()));
                        }
                        RESTClient restClient = new RESTClient(this.connectorName, endpointElement.getEndpointProperties().getAddress(), this.auditLog);
                        this.restClients.put(endpointElement.getEndpointProperties().getAddress(), restClient);
                    }
                }
                catch (Exception error) {
                    if (this.auditLog != null) {
                        this.auditLog.logMessage(methodName, OpenAPIIntegrationConnectorAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), methodName, error.getMessage()));
                    }
                }
            }
        } else if (this.auditLog != null) {
            String elementType = "Endpoint";
            this.auditLog.logMessage(methodName, OpenAPIIntegrationConnectorAuditCode.BAD_ELEMENT.getMessageDefinition(this.connectorName, "Endpoint", methodName, endpointElement.toString()));
        }
    }

    public void refresh() throws ConnectorCheckedException {
        String methodName = "refresh";
        if (this.targetRootURL != null) {
            if (this.auditLog != null) {
                this.auditLog.logMessage("refresh", OpenAPIIntegrationConnectorAuditCode.CONNECTOR_REFRESH_WITH_ENDPOINT.getMessageDefinition(this.connectorName, this.targetRootURL));
            }
        } else if (this.auditLog != null) {
            this.auditLog.logMessage("refresh", OpenAPIIntegrationConnectorAuditCode.CONNECTOR_REFRESH_ALL_ENDPOINTS.getMessageDefinition(this.connectorName, Integer.toString(this.restClients.size())));
        }
        for (String url : this.restClients.keySet()) {
            if (url == null) continue;
            try {
                String endpointGUID;
                RESTClient restClient = this.restClients.get(url);
                String openAPIJSON = restClient.callGetRESTCallNoParams("refresh", String.class, url + "/v3/api-docs");
                if (openAPIJSON == null) continue;
                OpenAPISpecification openAPISpecification = (OpenAPISpecification)OBJECT_READER.readValue(openAPIJSON, OpenAPISpecification.class);
                String title = "<Untitled>";
                if (openAPISpecification == null) continue;
                if (this.auditLog != null) {
                    if (openAPISpecification.getInfo() != null) {
                        title = openAPISpecification.getInfo().getTitle();
                    }
                    this.auditLog.logMessage("refresh", OpenAPIIntegrationConnectorAuditCode.RETRIEVED_OPEN_API_SPEC.getMessageDefinition(this.connectorName, url, title));
                }
                if ((endpointGUID = this.getEndpointGUID(url, openAPISpecification)) == null) continue;
                HashMap<String, String> apiGUIDMap = new HashMap<String, String>();
                HashMap<CallSite, String> apiOperationGUIDMap = new HashMap<CallSite, String>();
                if (openAPISpecification.getTags() != null) {
                    for (OpenAPITag tag : openAPISpecification.getTags()) {
                        String apiGUID = this.getAPIGUID(url, endpointGUID, tag);
                        if (apiGUID == null) continue;
                        apiGUIDMap.put(tag.getName(), apiGUID);
                    }
                }
                if (openAPISpecification.getPaths() != null) {
                    Map<String, Map<String, OpenAPIOperation>> paths = openAPISpecification.getPaths();
                    for (String pathName : paths.keySet()) {
                        Map<String, OpenAPIOperation> pathDescription = paths.get(pathName);
                        if (pathDescription == null) continue;
                        for (String command : pathDescription.keySet()) {
                            String apiOperationQualifiedName = command.toUpperCase() + " " + pathName;
                            String apiOperationGUID = this.getAPIOperationGUID(apiGUIDMap, apiOperationQualifiedName, pathDescription.get(command));
                            if (apiOperationGUID == null) continue;
                            apiOperationGUIDMap.put((CallSite)((Object)apiOperationQualifiedName), apiOperationGUID);
                        }
                    }
                }
                super.logRecord("refresh", OpenAPIIntegrationConnectorAuditCode.CATALOGUED_OPEN_API_SPEC.getMessageDefinition(this.connectorName, url, title, endpointGUID, Integer.toString(apiGUIDMap.size()), Integer.toString(apiOperationGUIDMap.size())));
            }
            catch (Exception error) {
                super.logRecord("refresh", OpenAPIIntegrationConnectorAuditCode.UNABLE_TO_RETRIEVE_OPEN_API_SPEC.getMessageDefinition(error.getClass().getName(), this.connectorName, "refresh", url, error.getMessage()));
                throw new ConnectorCheckedException(OpenAPIIntegrationConnectorErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), error.getMessage()), ((Object)((Object)this)).getClass().getName(), "refresh", (Throwable)error);
            }
        }
    }

    private String getEndpointGUID(String url, OpenAPISpecification openAPISpecification) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List endpointElements = this.myContext.findEndpoints(".*.", 0, 0);
        String endpointGUID = null;
        String endpointQualifiedName = "ServerEndpoint:" + url;
        if (endpointElements != null) {
            for (EndpointElement endpointElement : endpointElements) {
                if (!endpointQualifiedName.equals(endpointElement.getEndpointProperties().getQualifiedName())) continue;
                endpointGUID = endpointElement.getElementHeader().getGUID();
            }
        }
        if (endpointGUID == null) {
            org.odpi.openmetadata.frameworks.openmetadata.properties.connections.EndpointProperties properties = new org.odpi.openmetadata.frameworks.openmetadata.properties.connections.EndpointProperties();
            properties.setQualifiedName(endpointQualifiedName);
            if (openAPISpecification.getInfo() != null) {
                properties.setDisplayName(openAPISpecification.getInfo().getTitle());
                properties.setResourceDescription(openAPISpecification.getInfo().getDescription());
            }
            endpointGUID = this.myContext.createEndpoint(properties);
        }
        return endpointGUID;
    }

    private String getAPIGUID(String url, String endpointGUID, OpenAPITag tag) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String apiGUID = null;
        if (tag.getName() != null) {
            String apiQualifiedName = "API:" + tag.getName() + "(" + url + ")";
            List apiElements = this.myContext.getAPIsByName(apiQualifiedName, 0, 0);
            if (apiElements != null) {
                for (APIElement apiElement : apiElements) {
                    if (!apiQualifiedName.equals(apiElement.getAPIProperties().getQualifiedName())) continue;
                    apiGUID = apiElement.getElementHeader().getGUID();
                }
            }
            if (apiGUID == null) {
                APIProperties properties = new APIProperties();
                properties.setQualifiedName(apiQualifiedName);
                properties.setName(tag.getName());
                properties.setDisplayDescription(tag.getDescription());
                apiGUID = this.myContext.createAPI(endpointGUID, properties);
            }
        }
        return apiGUID;
    }

    private String getAPIOperationGUID(Map<String, String> apiGUIDMap, String apiOperationQualifiedName, OpenAPIOperation operation) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String apiOperationGUID = null;
        String apiGUID = null;
        List<String> tags = operation.getTags();
        if (tags != null) {
            for (String string : tags) {
                apiGUID = apiGUIDMap.get(string);
            }
        }
        if (apiGUID != null) {
            List apiOperationElements = this.myContext.getAPIOperationsByName(apiOperationQualifiedName, 0, 0);
            if (apiOperationElements != null) {
                for (APIOperationElement apiOperationElement : apiOperationElements) {
                    if (!apiOperationQualifiedName.equals(apiOperationElement.getProperties().getQualifiedName())) continue;
                    apiOperationGUID = apiOperationElement.getElementHeader().getGUID();
                }
            }
            if (apiOperationGUID == null) {
                APIOperationProperties aPIOperationProperties = new APIOperationProperties();
                aPIOperationProperties.setQualifiedName(apiOperationQualifiedName);
                aPIOperationProperties.setDisplayName(operation.getOperationId());
                aPIOperationProperties.setDescription(operation.getDescription());
                apiOperationGUID = this.myContext.createAPIOperation(apiGUID, aPIOperationProperties);
            }
        }
        return apiOperationGUID;
    }

    public void disconnect() throws ConnectorCheckedException {
        String methodName = "disconnect";
        if (this.auditLog != null) {
            this.auditLog.logMessage("disconnect", OpenAPIIntegrationConnectorAuditCode.CONNECTOR_STOPPING.getMessageDefinition(this.connectorName));
        }
        super.disconnect();
    }
}

