/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.integration.openlineage;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import org.odpi.openmetadata.adapters.connectors.integration.openlineage.OpenLineageLogStore;
import org.odpi.openmetadata.adapters.connectors.integration.openlineage.ffdc.OpenLineageIntegrationConnectorAuditCode;
import org.odpi.openmetadata.adapters.connectors.integration.openlineage.ffdc.OpenLineageIntegrationConnectorErrorCode;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectorTypeProperties;
import org.odpi.openmetadata.integrationservices.lineage.connector.LineageIntegratorConnector;
import org.odpi.openmetadata.integrationservices.lineage.connector.LineageIntegratorContext;
import org.odpi.openmetadata.integrationservices.lineage.connector.OpenLineageEventListener;
import org.odpi.openmetadata.integrationservices.lineage.properties.OpenLineageRunEvent;

public abstract class OpenLineageLogStoreConnectorBase
extends LineageIntegratorConnector
implements OpenLineageLogStore,
OpenLineageEventListener {
    protected String destinationName = "<Unknown";
    protected LineageIntegratorContext myContext = null;

    @Override
    public String getDestinationName() {
        return this.destinationName;
    }

    @Override
    public abstract void storeEvent(OpenLineageRunEvent var1, String var2) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException;

    private String getJSONOpenLineageEvent(OpenLineageRunEvent openLineageEvent, String methodName) throws InvalidParameterException {
        String parameterName = "openLineageEvent";
        if (openLineageEvent != null) {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                return objectMapper.writeValueAsString((Object)openLineageEvent);
            }
            catch (Exception error) {
                throw new InvalidParameterException(OpenLineageIntegrationConnectorErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), methodName, error.getMessage()), this.getClass().getName(), methodName, (Throwable)error, "openLineageEvent");
            }
        }
        return null;
    }

    public void initialize(String connectorInstanceId, ConnectionProperties connectionProperties) {
        super.initialize(connectorInstanceId, connectionProperties);
        if (connectionProperties != null) {
            ConnectorTypeProperties connectorType;
            if (connectionProperties.getDisplayName() != null) {
                this.destinationName = connectionProperties.getDisplayName();
            } else if (connectionProperties.getConnectorType() != null && (connectorType = connectionProperties.getConnectorType()).getDisplayName() != null) {
                this.destinationName = connectorType.getDisplayName();
            }
        }
    }

    public synchronized void start() throws ConnectorCheckedException {
        super.start();
        this.myContext = super.getContext();
        if (this.myContext != null) {
            this.myContext.registerListener((OpenLineageEventListener)this);
        }
    }

    public void refresh() throws ConnectorCheckedException {
    }

    public void processOpenLineageRunEvent(OpenLineageRunEvent event, String rawEvent) {
        block3: {
            String methodName = "processOpenLineageRunEvent";
            String jsonEvent = rawEvent;
            try {
                if (jsonEvent == null) {
                    jsonEvent = this.getJSONOpenLineageEvent(event, "processOpenLineageRunEvent");
                }
                this.storeEvent(event, rawEvent);
            }
            catch (Exception error) {
                if (this.auditLog == null) break block3;
                this.auditLog.logException("processOpenLineageRunEvent", OpenLineageIntegrationConnectorAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), "processOpenLineageRunEvent", error.getMessage()), jsonEvent, (Throwable)error);
            }
        }
    }

    protected void logNoRawEvent(OpenLineageRunEvent openLineageEvent, String methodName) throws InvalidParameterException {
        String parameterName = "rawEvent";
        HashMap<String, String> additionalProperties = new HashMap<String, String>();
        if (openLineageEvent != null) {
            additionalProperties.put("rawEvent", openLineageEvent.toString());
        }
        throw new InvalidParameterException(OpenLineageIntegrationConnectorErrorCode.NO_RAW_EVENT.getMessageDefinition(this.connectorName, methodName), this.getClass().getName(), methodName, "rawEvent", additionalProperties);
    }
}

