/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.integration.openlineage;

import java.net.URI;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.odpi.openmetadata.accessservices.assetmanager.api.AssetManagerEventListener;
import org.odpi.openmetadata.accessservices.assetmanager.events.AssetManagerEventType;
import org.odpi.openmetadata.accessservices.assetmanager.events.AssetManagerOutTopicEvent;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ActionTargetElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GovernanceActionElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GovernanceActionProperties;
import org.odpi.openmetadata.adapters.connectors.integration.openlineage.ffdc.OpenLineageIntegrationConnectorAuditCode;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementClassification;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementHeader;
import org.odpi.openmetadata.integrationservices.lineage.connector.LineageIntegratorConnector;
import org.odpi.openmetadata.integrationservices.lineage.connector.LineageIntegratorContext;
import org.odpi.openmetadata.integrationservices.lineage.properties.OpenLineageInputDataSet;
import org.odpi.openmetadata.integrationservices.lineage.properties.OpenLineageJob;
import org.odpi.openmetadata.integrationservices.lineage.properties.OpenLineageNominalTimeRunFacet;
import org.odpi.openmetadata.integrationservices.lineage.properties.OpenLineageOutputDataSet;
import org.odpi.openmetadata.integrationservices.lineage.properties.OpenLineageParentRunFacet;
import org.odpi.openmetadata.integrationservices.lineage.properties.OpenLineageParentRunFacetJob;
import org.odpi.openmetadata.integrationservices.lineage.properties.OpenLineageParentRunFacetRun;
import org.odpi.openmetadata.integrationservices.lineage.properties.OpenLineageRun;
import org.odpi.openmetadata.integrationservices.lineage.properties.OpenLineageRunEvent;
import org.odpi.openmetadata.integrationservices.lineage.properties.OpenLineageRunFacets;

public class GovernanceActionOpenLineageIntegrationConnector
extends LineageIntegratorConnector
implements AssetManagerEventListener {
    private static final String inProgressGovernanceActionStatus = "InProgress";
    private static final String actionedGovernanceActionStatus = "Actioned";
    private static final String invalidGovernanceActionStatus = "Invalid";
    private static final String failedGovernanceActionStatus = "Failed";
    private static URI producer = URI.create("https://egeria-project.org/");
    private final ZoneId zoneId = ZoneId.systemDefault();
    private LineageIntegratorContext myContext = null;

    public void initialize(String connectorInstanceId, ConnectionProperties connectionProperties) {
        super.initialize(connectorInstanceId, connectionProperties);
    }

    public synchronized void start() throws ConnectorCheckedException {
        block3: {
            super.start();
            String methodName = "start";
            this.myContext = super.getContext();
            if (this.myContext != null) {
                try {
                    this.myContext.registerListener((AssetManagerEventListener)this);
                }
                catch (Exception error) {
                    if (this.auditLog == null) break block3;
                    this.auditLog.logException("start", OpenLineageIntegrationConnectorAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), "start", error.getMessage()), (Throwable)error);
                }
            }
        }
    }

    public void refresh() {
    }

    public void processEvent(AssetManagerOutTopicEvent event) {
        block5: {
            String methodName = "processEvent";
            ElementHeader elementHeader = event.getElementHeader();
            if ((event.getEventType() == AssetManagerEventType.NEW_ELEMENT_CREATED || event.getEventType() == AssetManagerEventType.ELEMENT_UPDATED) && "GovernanceAction".equals(elementHeader.getType().getTypeName())) {
                try {
                    String currentActionStatus;
                    String previousActionStatus = "";
                    if (event.getPreviousElementProperties() != null) {
                        previousActionStatus = event.getPreviousElementProperties().get("actionStatus").toString();
                    }
                    if (!previousActionStatus.equals(currentActionStatus = event.getElementProperties().get("actionStatus").toString()) && (inProgressGovernanceActionStatus.equals(currentActionStatus) || actionedGovernanceActionStatus.equals(currentActionStatus) || failedGovernanceActionStatus.equals(currentActionStatus) || invalidGovernanceActionStatus.equals(currentActionStatus))) {
                        GovernanceActionElement governanceAction = this.myContext.getGovernanceAction(elementHeader.getGUID());
                        this.publishOpenLineageEvent(currentActionStatus, event.getEventTime(), governanceAction);
                    }
                }
                catch (Exception error) {
                    if (this.auditLog == null) break block5;
                    String stringEvent = event.toString();
                    this.auditLog.logException("processEvent", OpenLineageIntegrationConnectorAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), "processEvent", error.getMessage()), stringEvent, (Throwable)error);
                }
            }
        }
    }

    private void publishOpenLineageEvent(String governanceActionStatus, Date eventTime, GovernanceActionElement governanceAction) {
        OpenLineageInputDataSet inputDataSet;
        OpenLineageRunEvent event = new OpenLineageRunEvent();
        event.setProducer(producer);
        event.setEventTime(this.getTimeStamp(eventTime));
        if (inProgressGovernanceActionStatus.equals(governanceActionStatus)) {
            event.setEventType("START");
        } else if (actionedGovernanceActionStatus.equals(governanceActionStatus)) {
            event.setEventType("COMPLETE");
        } else if (failedGovernanceActionStatus.equals(governanceActionStatus)) {
            event.setEventType("FAIL");
        } else if (invalidGovernanceActionStatus.equals(governanceActionStatus)) {
            event.setEventType("ABORT");
        }
        GovernanceActionProperties properties = governanceAction.getProperties();
        String namespace = properties.getProcessName();
        if (namespace.length() > 64) {
            String[] tokens = namespace.split(":");
            namespace = tokens[tokens.length - 1];
        }
        OpenLineageJob job = new OpenLineageJob();
        if (properties.getGovernanceActionTypeName() != null) {
            job.setName(properties.getGovernanceActionTypeName());
        } else {
            job.setName(properties.getGovernanceEngineName() + ":" + properties.getRequestType());
        }
        job.setNamespace(namespace);
        event.setJob(job);
        OpenLineageRun run = new OpenLineageRun();
        run.setRunId(UUID.fromString(governanceAction.getElementHeader().getGUID()));
        String anchorGUID = null;
        List classifications = governanceAction.getElementHeader().getClassifications();
        if (classifications != null) {
            for (ElementClassification classification : classifications) {
                if (classification == null || !"Anchors".equals(classification.getClassificationName()) || classification.getClassificationProperties() == null) continue;
                anchorGUID = classification.getClassificationProperties().get("anchorGUID").toString();
            }
        }
        OpenLineageRunFacets runFacets = new OpenLineageRunFacets();
        if (anchorGUID != null) {
            OpenLineageParentRunFacet parentRunFacet = new OpenLineageParentRunFacet();
            OpenLineageParentRunFacetJob parentRunFacetJob = new OpenLineageParentRunFacetJob();
            OpenLineageParentRunFacetRun parentRunFacetRun = new OpenLineageParentRunFacetRun();
            parentRunFacet.set_producer(producer);
            parentRunFacetJob.setName(properties.getProcessName());
            parentRunFacetJob.setNamespace(namespace);
            parentRunFacet.setJob(parentRunFacetJob);
            parentRunFacetRun.setRunId(UUID.fromString(anchorGUID));
            parentRunFacet.setRun(parentRunFacetRun);
            runFacets.setParent(parentRunFacet);
        }
        OpenLineageNominalTimeRunFacet nominalTimeRunFacet = new OpenLineageNominalTimeRunFacet();
        nominalTimeRunFacet.set_producer(producer);
        if (properties.getStartTime() == null) {
            nominalTimeRunFacet.setNominalStartTime(this.getTimeStamp(properties.getRequestedTime()));
        } else {
            nominalTimeRunFacet.setNominalStartTime(this.getTimeStamp(properties.getStartTime()));
        }
        if (properties.getCompletionTime() != null) {
            nominalTimeRunFacet.setNominalEndTime(this.getTimeStamp(properties.getCompletionTime()));
        }
        runFacets.setNominalTime(nominalTimeRunFacet);
        run.setFacets(runFacets);
        event.setRun(run);
        ArrayList<OpenLineageInputDataSet> inputDataSets = new ArrayList<OpenLineageInputDataSet>();
        if (governanceAction.getActionTargetElements() != null) {
            for (ActionTargetElement actionTarget : governanceAction.getActionTargetElements()) {
                if (actionTarget == null) continue;
                inputDataSet = new OpenLineageInputDataSet();
                inputDataSet.setName(actionTarget.getActionTargetName());
                inputDataSet.setNamespace(namespace);
                inputDataSets.add(inputDataSet);
            }
        }
        if (properties.getReceivedGuards() != null) {
            for (String guard : properties.getReceivedGuards()) {
                if (guard == null) continue;
                inputDataSet = new OpenLineageInputDataSet();
                inputDataSet.setName(guard);
                inputDataSet.setNamespace(namespace);
                inputDataSets.add(inputDataSet);
            }
        }
        if (properties.getRequestParameters() != null) {
            for (String requestParameter : properties.getRequestParameters().values()) {
                if (requestParameter == null) continue;
                inputDataSet = new OpenLineageInputDataSet();
                inputDataSet.setName(requestParameter);
                inputDataSet.setNamespace(namespace);
                inputDataSets.add(inputDataSet);
            }
        }
        event.setInputs(inputDataSets);
        if (properties.getCompletionTime() != null) {
            ArrayList<OpenLineageOutputDataSet> outputDataSets = new ArrayList<OpenLineageOutputDataSet>();
            if (properties.getCompletionGuards() != null) {
                for (String guard : properties.getCompletionGuards()) {
                    if (guard == null) continue;
                    OpenLineageOutputDataSet outputDataSet = new OpenLineageOutputDataSet();
                    outputDataSet.setName(guard);
                    outputDataSet.setNamespace(namespace);
                    outputDataSets.add(outputDataSet);
                }
            }
            event.setOutputs(outputDataSets);
        }
        this.myContext.publishOpenLineageRunEvent(event);
    }

    private String getTimeStamp(Date date) {
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(date.toInstant(), this.zoneId);
        String zonedDateString = zonedDateTime.toString();
        String[] dataTokens = zonedDateString.split("\\[");
        return dataTokens[0];
    }
}

