/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.integration.openlineage.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageSet;

public enum OpenLineageIntegrationConnectorErrorCode implements ExceptionMessageSet
{
    UNEXPECTED_EXCEPTION(500, "OPEN-LINEAGE-INTEGRATION-CONNECTOR-500-001", "The {0} integration connector received an unexpected {1} exception in method {2} when working with open lineage events; the error message was: {3}", "The connector is unable to process one or more lineage events.", "Use the details from the error message to determine the cause of the error and retry the request once it is resolved."),
    NO_RAW_EVENT(500, "OPEN-LINEAGE-INTEGRATION-CONNECTOR-500-002", "The {0} integration connector received an null raw open lineage event in method {1} when working with open lineage events", "The connector is unable to process an open lineage events because it has no content.", "Validate the set up and source of the events and retry the request once it is resolved.");

    private ExceptionMessageDefinition messageDefinition;

    private OpenLineageIntegrationConnectorErrorCode(int httpErrorCode, String errorMessageId, String errorMessage, String systemAction, String userAction) {
        this.messageDefinition = new ExceptionMessageDefinition(httpErrorCode, errorMessageId, errorMessage, systemAction, userAction);
    }

    public ExceptionMessageDefinition getMessageDefinition() {
        return this.messageDefinition;
    }

    public ExceptionMessageDefinition getMessageDefinition(String ... params) {
        this.messageDefinition.setMessageParameters(params);
        return this.messageDefinition;
    }

    public String toString() {
        return "OpenLineageIntegrationConnectorErrorCode{messageDefinition=" + this.messageDefinition + "}";
    }
}

