/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.integration.openlineage;

import java.nio.charset.StandardCharsets;
import java.util.List;
import org.odpi.openmetadata.adapters.connectors.integration.openlineage.OpenLineageLogStoreConnectorBase;
import org.odpi.openmetadata.adapters.connectors.integration.openlineage.ffdc.OpenLineageIntegrationConnectorErrorCode;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.odpi.openmetadata.integrationservices.lineage.properties.OpenLineageRunEvent;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class APIBasedOpenLineageLogStoreConnector
extends OpenLineageLogStoreConnectorBase {
    private static final String defaultLogStoreURL = "http://localhost:5000/api/v1/lineage";
    private String logStoreURL = null;
    private RestTemplate restTemplate = null;
    private HttpHeaders header = null;

    @Override
    public void start() throws ConnectorCheckedException {
        super.start();
        String methodName = "start";
        EndpointProperties endpoint = this.connectionProperties.getEndpoint();
        if (endpoint != null) {
            this.logStoreURL = endpoint.getAddress();
        }
        if (this.logStoreURL == null) {
            this.logStoreURL = defaultLogStoreURL;
        }
        try {
            this.restTemplate = new RestTemplate();
            List converters = this.restTemplate.getMessageConverters();
            converters.removeIf(httpMessageConverter -> httpMessageConverter instanceof StringHttpMessageConverter);
            converters.add(0, new StringHttpMessageConverter(StandardCharsets.UTF_8));
            this.header = new HttpHeaders();
            this.header.setContentType(MediaType.APPLICATION_JSON);
        }
        catch (Exception error) {
            throw new ConnectorCheckedException(OpenLineageIntegrationConnectorErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), "start", error.getMessage()), this.getClass().getName(), "start", (Throwable)error);
        }
    }

    @Override
    public void storeEvent(OpenLineageRunEvent openLineageEvent, String rawEvent) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "storeEvent";
        if (rawEvent != null) {
            HttpEntity request = new HttpEntity((Object)rawEvent, (MultiValueMap)this.header);
            this.restTemplate.exchange(this.logStoreURL, HttpMethod.POST, request, Void.class, new Object[0]);
        } else {
            super.logNoRawEvent(openLineageEvent, "storeEvent");
        }
    }
}

