/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.integration.openlineage;

import java.util.HashMap;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.integration.openlineage.ffdc.OpenLineageIntegrationConnectorAuditCode;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.odpi.openmetadata.integrationservices.lineage.connector.LineageIntegratorConnector;
import org.odpi.openmetadata.integrationservices.lineage.connector.LineageIntegratorContext;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicListener;

public class OpenLineageEventReceiverIntegrationConnector
extends LineageIntegratorConnector
implements OpenMetadataTopicListener {
    private LineageIntegratorContext myContext = null;
    private final Map<String, OpenMetadataTopicConnector> topicConnectors = new HashMap<String, OpenMetadataTopicConnector>();

    public void start() throws ConnectorCheckedException {
        super.start();
        String methodName = "start";
        this.myContext = super.getContext();
        if (this.myContext != null) {
            OpenMetadataTopicConnector topicConnector;
            if (this.embeddedConnectors != null) {
                for (Connector embeddedConnector : this.embeddedConnectors) {
                    EndpointProperties endpoint;
                    if (!(embeddedConnector instanceof OpenMetadataTopicConnector)) continue;
                    topicConnector = (OpenMetadataTopicConnector)embeddedConnector;
                    topicConnector.registerListener((OpenMetadataTopicListener)this);
                    ConnectionProperties connectionProperties = topicConnector.getConnection();
                    if (connectionProperties == null || (endpoint = connectionProperties.getEndpoint()) == null) continue;
                    this.topicConnectors.put(endpoint.getAddress(), topicConnector);
                }
            }
            for (String topicName : this.topicConnectors.keySet()) {
                topicConnector = this.topicConnectors.get(topicName);
                ConnectionProperties topicConnection = topicConnector.getConnection();
                if (this.auditLog != null) {
                    this.auditLog.logMessage("start", OpenLineageIntegrationConnectorAuditCode.KAFKA_RECEIVER_CONFIGURATION.getMessageDefinition(this.connectorName, topicName, topicConnection.getConnectionName()));
                }
                topicConnector.start();
            }
        }
    }

    public void processEvent(String event) {
        if (this.myContext != null) {
            this.myContext.publishOpenLineageRunEvent(event);
        }
    }

    public void refresh() {
    }

    public void disconnect() throws ConnectorCheckedException {
        String methodName = "disconnect";
        for (OpenMetadataTopicConnector topicConnector : this.topicConnectors.values()) {
            topicConnector.disconnect();
        }
        if (this.auditLog != null) {
            this.auditLog.logMessage("disconnect", OpenLineageIntegrationConnectorAuditCode.CONNECTOR_STOPPING.getMessageDefinition(this.connectorName));
        }
        super.disconnect();
    }
}

