/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.integration.openlineage;

import java.io.File;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.odpi.openmetadata.adapters.connectors.integration.openlineage.OpenLineageLogStoreConnectorBase;
import org.odpi.openmetadata.adapters.connectors.integration.openlineage.ffdc.OpenLineageIntegrationConnectorErrorCode;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.odpi.openmetadata.integrationservices.lineage.properties.OpenLineageRunEvent;

public class FileBasedOpenLineageLogStoreConnector
extends OpenLineageLogStoreConnectorBase {
    private static final String defaultLogDirectory = "open-lineage-log";
    private String logStoreDirectoryName = null;

    @Override
    public void start() throws ConnectorCheckedException {
        super.start();
        String methodName = "start";
        EndpointProperties endpoint = this.connectionProperties.getEndpoint();
        if (endpoint != null) {
            this.logStoreDirectoryName = endpoint.getAddress();
        }
        if (this.logStoreDirectoryName == null) {
            this.logStoreDirectoryName = defaultLogDirectory;
        }
        try {
            File logStoreDirectory = new File(this.logStoreDirectoryName);
            FileUtils.forceMkdir((File)logStoreDirectory);
        }
        catch (Exception error) {
            throw new ConnectorCheckedException(OpenLineageIntegrationConnectorErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), "start", error.getMessage()), this.getClass().getName(), "start", (Throwable)error);
        }
    }

    @Override
    public void storeEvent(OpenLineageRunEvent openLineageEvent, String rawEvent) throws InvalidParameterException, PropertyServerException {
        String methodName = "storeEvent";
        if (rawEvent != null) {
            String namespace = "default-namespace/";
            String jobName = "unformatted/";
            String runId = UUID.randomUUID().toString();
            String eventType = "UNKNOWN";
            ZonedDateTime zonedDateTime = ZonedDateTime.now();
            try {
                if (openLineageEvent != null) {
                    String eventTime = openLineageEvent.getEventTime();
                    zonedDateTime = ZonedDateTime.parse(eventTime);
                    eventType = openLineageEvent.getEventType();
                    if (openLineageEvent.getRun() != null && openLineageEvent.getRun().getRunId() != null) {
                        runId = openLineageEvent.getRun().getRunId().toString();
                    }
                    if (openLineageEvent.getJob() != null) {
                        if (openLineageEvent.getJob().getName() != null) {
                            jobName = openLineageEvent.getJob().getName();
                        }
                        if (openLineageEvent.getJob().getNamespace() != null) {
                            namespace = openLineageEvent.getJob().getNamespace();
                        }
                    }
                }
                String timestamp = zonedDateTime.getYear() + "-" + zonedDateTime.getMonthValue() + "-" + zonedDateTime.getDayOfMonth() + ":" + zonedDateTime.getHour() + "-" + zonedDateTime.getMinute() + "-" + zonedDateTime.getSecond() + ":" + zonedDateTime.getNano();
                File logStoreFile = new File(this.logStoreDirectoryName + "/" + namespace + "/" + jobName + "/" + runId + "-" + timestamp + "-" + eventType + ".openlineageevent");
                FileUtils.writeStringToFile((File)logStoreFile, (String)rawEvent, (String)null, (boolean)false);
            }
            catch (Exception error) {
                String parameterName = "openLineageEvent";
                HashMap<String, String> additionalProperties = new HashMap<String, String>();
                if (openLineageEvent != null) {
                    additionalProperties.put("openLineageEvent", openLineageEvent.toString());
                }
                throw new PropertyServerException(OpenLineageIntegrationConnectorErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), "storeEvent", error.getMessage()), this.getClass().getName(), "storeEvent", (Throwable)error, additionalProperties);
            }
        } else {
            super.logNoRawEvent(openLineageEvent, "storeEvent");
        }
    }
}

