/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.integration.openlineage;

import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ProcessElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ProcessProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ProcessStatus;
import org.odpi.openmetadata.adapters.connectors.integration.openlineage.ffdc.OpenLineageIntegrationConnectorAuditCode;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectorTypeProperties;
import org.odpi.openmetadata.integrationservices.lineage.connector.LineageIntegratorConnector;
import org.odpi.openmetadata.integrationservices.lineage.connector.LineageIntegratorContext;
import org.odpi.openmetadata.integrationservices.lineage.connector.OpenLineageEventListener;
import org.odpi.openmetadata.integrationservices.lineage.properties.OpenLineageJob;
import org.odpi.openmetadata.integrationservices.lineage.properties.OpenLineageParentRunFacetJob;
import org.odpi.openmetadata.integrationservices.lineage.properties.OpenLineageParentRunFacetRun;
import org.odpi.openmetadata.integrationservices.lineage.properties.OpenLineageRun;
import org.odpi.openmetadata.integrationservices.lineage.properties.OpenLineageRunEvent;

public class OpenLineageCataloguerIntegrationConnector
extends LineageIntegratorConnector
implements OpenLineageEventListener {
    protected String destinationName = "<Unknown";
    protected LineageIntegratorContext myContext = null;

    public synchronized void start() throws ConnectorCheckedException {
        super.start();
        if (this.connectionProperties != null) {
            ConnectorTypeProperties connectorType;
            if (this.connectionProperties.getDisplayName() != null) {
                this.destinationName = this.connectionProperties.getDisplayName();
            } else if (this.connectionProperties.getConnectorType() != null && (connectorType = this.connectionProperties.getConnectorType()).getDisplayName() != null) {
                this.destinationName = connectorType.getDisplayName();
            }
        }
        this.myContext = super.getContext();
        if (this.myContext != null) {
            this.myContext.registerListener((OpenLineageEventListener)this);
        }
    }

    public void refresh() throws ConnectorCheckedException {
    }

    public void processOpenLineageRunEvent(OpenLineageRunEvent event, String rawEvent) {
        block12: {
            String methodName = "processOpenLineageRunEvent";
            if (event != null) {
                try {
                    OpenLineageRun run;
                    String processGUID = null;
                    String parentProcessName = null;
                    Object parentProcessInstanceGUID = null;
                    OpenLineageJob job = event.getJob();
                    if (job != null && job.getName() != null) {
                        String qualifiedName = "OpenLineageJob:" + job.getName();
                        List existingProcesses = this.myContext.getProcessesByName(qualifiedName, 0, 0, null);
                        if (existingProcesses == null || existingProcesses.isEmpty()) {
                            ProcessProperties processProperties = new ProcessProperties();
                            if (job.getFacets() != null && (documentation = job.getFacets().getDocumentation()) != null) {
                                processProperties.setDescription(documentation.getDescription());
                            }
                            processProperties.setTypeName("DeployedSoftwareComponent");
                            processProperties.setQualifiedName(qualifiedName);
                            processGUID = this.myContext.createProcess(false, ProcessStatus.ACTIVE, processProperties);
                            this.myContext.publishProcess(processGUID, null);
                        } else if (existingProcesses.size() == 1) {
                            ProcessElement existingProcess = (ProcessElement)existingProcesses.get(0);
                            processGUID = existingProcess.getElementHeader().getGUID();
                            if (existingProcess.getProcessProperties().getDescription() == null && job.getFacets() != null && (documentation = job.getFacets().getDocumentation()) != null) {
                                ProcessProperties processProperties = new ProcessProperties();
                                processProperties.setDescription(documentation.getDescription());
                                this.myContext.updateProcess(processGUID, true, processProperties, null);
                            }
                        }
                    }
                    if ((run = event.getRun()) != null && run.getFacets() != null && run.getFacets().getParent() != null) {
                        OpenLineageParentRunFacetJob parentJob = run.getFacets().getParent().getJob();
                        OpenLineageParentRunFacetRun parentRun = run.getFacets().getParent().getRun();
                        if (parentJob != null) {
                            parentProcessName = parentJob.getName();
                            List list = this.myContext.getProcessesByName(parentProcessName, 0, 0, null);
                        }
                    }
                }
                catch (Exception error) {
                    if (this.auditLog == null) break block12;
                    String stringEvent = rawEvent;
                    if (rawEvent == null) {
                        stringEvent = event.toString();
                    }
                    this.auditLog.logException("processOpenLineageRunEvent", OpenLineageIntegrationConnectorAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), "processOpenLineageRunEvent", error.getMessage()), stringEvent, (Throwable)error);
                }
            }
        }
    }
}

